/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 G2\u00020\u0001:\u0001GB7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\b\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u000202H\u0016J\u0014\u00103\u001a\u0002002\n\u00104\u001a\u0006\u0012\u0002\b\u000305H\u0016J\b\u00106\u001a\u000200H\u0016J\u0010\u00107\u001a\u0002002\u0006\u00108\u001a\u000209H\u0014J\u0010\u0010:\u001a\u0002002\u0006\u0010;\u001a\u00020<H\u0002J\u000e\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020#J\u000e\u0010?\u001a\u0002002\u0006\u0010@\u001a\u00020#J\u000e\u0010A\u001a\u0002002\u0006\u0010B\u001a\u00020\u000fJ\u0015\u0010C\u001a\n D*\u0004\u0018\u00010<0<H\u0002\u00a2\u0006\u0002\u0010EJ\u0010\u0010F\u001a\u0002002\u0006\u00108\u001a\u000209H\u0014R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0011\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010$\u001a\u00020#2\u0006\u0010\"\u001a\u00020#8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00010-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lnet/msrandom/witchery/entity/EntityBrewEffectCloud;", "Lnet/minecraft/entity/Entity;", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "actionList", "Lnet/msrandom/witchery/brewing/action/BrewActionList;", "effect", "Lnet/msrandom/witchery/brewing/ModifiersImpact;", "(Lnet/minecraft/world/World;DDDLnet/msrandom/witchery/brewing/action/BrewActionList;Lnet/msrandom/witchery/brewing/ModifiersImpact;)V", "(Lnet/minecraft/world/World;)V", "color", "", "getColor", "()I", "duration", "getDuration", "setDuration", "(I)V", "durationOnUse", "effects", "modifiers", "Lnet/msrandom/witchery/brewing/ModifiersEffect;", "owner", "Lnet/minecraft/entity/EntityLivingBase;", "getOwner", "()Lnet/minecraft/entity/EntityLivingBase;", "setOwner", "(Lnet/minecraft/entity/EntityLivingBase;)V", "ownerUniqueId", "Ljava/util/UUID;", "radiusIn", "", "radius", "getRadius", "()F", "setRadius", "(F)V", "radiusOnUse", "radiusPerTick", "reapplicationDelay", "reapplicationDelayMap", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "waitTime", "entityInit", "", "getPushReaction", "Lnet/minecraft/block/material/EnumPushReaction;", "notifyDataManagerChange", "key", "Lnet/minecraft/network/datasync/DataParameter;", "onUpdate", "readEntityFromNBT", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "setIgnoreRadius", "ignoreRadius", "", "setRadiusOnUse", "radiusOnUseIn", "setRadiusPerTick", "radiusPerTickIn", "setWaitTime", "waitTimeIn", "shouldIgnoreRadius", "kotlin.jvm.PlatformType", "()Ljava/lang/Boolean;", "writeEntityToNBT", "Companion", "WitcheryResurrected"})
public final class EntityBrewEffectCloud
extends Entity {
    private BrewActionList effects;
    private final Object2IntMap<Entity> reapplicationDelayMap;
    private int duration;
    private int waitTime;
    private int reapplicationDelay;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private EntityLivingBase owner;
    private UUID ownerUniqueId;
    private ModifiersEffect modifiers;
    private static final DataParameter<Float> RADIUS;
    private static final DataParameter<Boolean> IGNORE_RADIUS;
    private static final DataParameter<NBTTagCompound> DATA;
    public static final Companion Companion;

    public final int getDuration() {
        return this.duration;
    }

    public final void setDuration(int n) {
        this.duration = n;
    }

    @Nullable
    public final EntityLivingBase getOwner() {
        block1: {
            Entity entity;
            UUID uUID = this.ownerUniqueId;
            if (uUID == null) break block1;
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            World serverWorld = this.world;
            if (this.owner == null && serverWorld instanceof WorldServer && (entity = ((WorldServer)serverWorld).getEntityFromUuid(it)) instanceof EntityLivingBase) {
                this.owner = (EntityLivingBase)entity;
            }
        }
        return this.owner;
    }

    public final void setOwner(@Nullable EntityLivingBase owner) {
        this.owner = owner;
        EntityLivingBase entityLivingBase = owner;
        this.ownerUniqueId = entityLivingBase != null ? entityLivingBase.getUniqueID() : null;
    }

    public final float getRadius() {
        Object object = this.getDataManager().get(RADIUS);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getDataManager().get(RADIUS)");
        return ((Number)object).floatValue();
    }

    public final void setRadius(float radiusIn) {
        double d0 = this.posX;
        double d1 = this.posY;
        double d2 = this.posZ;
        this.setSize(radiusIn * 2.0f, 0.5f);
        this.setPosition(d0, d1, d2);
        if (!this.world.isRemote) {
            this.getDataManager().set(RADIUS, (Object)Float.valueOf(radiusIn));
        }
    }

    public final int getColor() {
        if (this.effects == null) {
            this.effects = new BrewActionList((NBTTagCompound)this.dataManager.get(DATA));
        }
        BrewActionList brewActionList = this.effects;
        if (brewActionList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"effects");
        }
        ArrayList<ItemStack> arrayList = brewActionList.items;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"effects.items");
        return WitcheryUtils.getBrewColor((Collection<ItemStack>)arrayList);
    }

    protected void entityInit() {
        this.getDataManager().register(RADIUS, (Object)Float.valueOf(0.5f));
        this.getDataManager().register(IGNORE_RADIUS, (Object)false);
        this.getDataManager().register(DATA, (Object)new NBTTagCompound());
    }

    private final void setIgnoreRadius(boolean ignoreRadius) {
        this.getDataManager().set(IGNORE_RADIUS, (Object)ignoreRadius);
    }

    private final Boolean shouldIgnoreRadius() {
        return (Boolean)this.getDataManager().get(IGNORE_RADIUS);
    }

    /*
     * WARNING - void declaration
     */
    public void onUpdate() {
        block17: {
            boolean flag1;
            float f;
            Boolean flag;
            block15: {
                block16: {
                    super.onUpdate();
                    flag = this.shouldIgnoreRadius();
                    f = this.getRadius();
                    if (!this.world.isRemote) break block15;
                    Boolean bl = flag;
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"flag");
                    if (!bl.booleanValue()) break block16;
                    if (!this.rand.nextBoolean()) break block17;
                    boolean bl2 = false;
                    boolean bl3 = true;
                    while (bl2 <= bl3) {
                        void i;
                        float f1 = this.rand.nextFloat() * ((float)Math.PI * 2);
                        float f2 = MathHelper.sqrt((float)this.rand.nextFloat()) * 0.2f;
                        float f3 = MathHelper.cos((float)f1) * f2;
                        float f4 = MathHelper.sin((float)f1) * f2;
                        int c = this.rand.nextBoolean() ? 0xFFFFFF : this.getColor();
                        int red = c >>> 16 & 0xFF;
                        int green = c >>> 8 & 0xFF;
                        int blue = c & 0xFF;
                        this.world.spawnAlwaysVisibleParticle(EnumParticleTypes.SPELL_MOB.getParticleID(), this.posX + (double)f3, this.posY, this.posZ + (double)f4, (double)red / 255.0, (double)green / 255.0, (double)blue / 255.0, new int[0]);
                        ++i;
                    }
                    break block17;
                }
                float f5 = (float)Math.PI * f * f;
                int k1 = 0;
                while ((float)k1 < f5) {
                    float f6 = this.rand.nextFloat() * ((float)Math.PI * 2);
                    float f7 = MathHelper.sqrt((float)this.rand.nextFloat()) * f;
                    float f8 = MathHelper.cos((float)f6) * f7;
                    float f9 = MathHelper.sin((float)f6) * f7;
                    int l1 = this.getColor();
                    int i2 = l1 >> 16 & 0xFF;
                    int j2 = l1 >> 8 & 0xFF;
                    int j1 = l1 & 0xFF;
                    this.world.spawnAlwaysVisibleParticle(EnumParticleTypes.SPELL_MOB.getParticleID(), this.posX + (double)f8, this.posY, this.posZ + (double)f9, (double)((float)i2 / 255.0f), (double)((float)j2 / 255.0f), (double)((float)j1 / 255.0f), new int[0]);
                    ++k1;
                }
                break block17;
            }
            if (this.ticksExisted >= this.waitTime + this.duration) {
                this.setDead();
                return;
            }
            boolean bl = flag1 = this.ticksExisted < this.waitTime;
            if (Intrinsics.areEqual((Object)flag, (Object)flag1) ^ true) {
                this.setIgnoreRadius(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.setDead();
                    return;
                }
                this.setRadius(f);
            }
            if (this.ticksExisted % 5 == 0) {
                this.reapplicationDelayMap.object2IntEntrySet().removeIf((Predicate)new Predicate<Object2IntMap.Entry<Entity>>(this){
                    final /* synthetic */ EntityBrewEffectCloud this$0;

                    public final boolean test(@NotNull Object2IntMap.Entry<Entity> entry2) {
                        Intrinsics.checkParameterIsNotNull(entry2, (String)"entry");
                        return this.this$0.ticksExisted >= entry2.getIntValue();
                    }
                    {
                        this.this$0 = entityBrewEffectCloud;
                    }
                });
                BrewActionList brewActionList = this.effects;
                if (brewActionList == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"effects");
                }
                if (brewActionList.actions.isEmpty()) {
                    this.reapplicationDelayMap.clear();
                } else {
                    for (EntityLivingBase entity : this.world.getEntitiesWithinAABB(EntityLivingBase.class, this.getEntityBoundingBox())) {
                        double d1;
                        double d0;
                        double d2;
                        Map f7 = (Map)this.reapplicationDelayMap;
                        boolean bl4 = false;
                        Map f9 = f7;
                        boolean bl5 = false;
                        if (f9.containsKey(entity) || !entity.canBeHitWithPotion() || !((d2 = (d0 = entity.posX - this.posX) * d0 + (d1 = entity.posZ - this.posZ) * d1) <= (double)(f * f))) continue;
                        ((Map)this.reapplicationDelayMap).put(entity, this.ticksExisted + this.reapplicationDelay);
                        BrewActionList brewActionList2 = this.effects;
                        if (brewActionList2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"effects");
                        }
                        brewActionList2.applyToEntity(this.world, entity, this.modifiers);
                        if (this.radiusOnUse != 0.0f) {
                            if ((f += this.radiusOnUse) < 0.5f) {
                                this.setDead();
                                return;
                            }
                            this.setRadius(f);
                        }
                        if (this.durationOnUse == 0) continue;
                        this.duration += this.durationOnUse;
                        if (this.duration > 0) continue;
                        this.setDead();
                        return;
                    }
                }
            }
        }
    }

    public final void setRadiusOnUse(float radiusOnUseIn) {
        this.radiusOnUse = radiusOnUseIn;
    }

    public final void setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
    }

    public final void setWaitTime(int waitTimeIn) {
        this.waitTime = waitTimeIn;
    }

    protected void readEntityFromNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        this.ticksExisted = compound.getInteger("Age");
        this.duration = compound.getInteger("Duration");
        this.waitTime = compound.getInteger("WaitTime");
        this.reapplicationDelay = compound.getInteger("ReapplicationDelay");
        this.durationOnUse = compound.getInteger("DurationOnUse");
        this.radiusOnUse = compound.getFloat("RadiusOnUse");
        this.radiusPerTick = compound.getFloat("RadiusPerTick");
        this.setRadius(compound.getFloat("Radius"));
        this.ownerUniqueId = compound.getUniqueId("OwnerUUID");
        this.effects = new BrewActionList(compound);
        Vec3d position = this.getPositionVector();
        ModifiersImpact modifiers = new ModifiersImpact(position, false, 0, EntityUtil.playerOrFake(this.world, this.getOwner()));
        BrewActionList brewActionList = this.effects;
        if (brewActionList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"effects");
        }
        for (BrewAction action : brewActionList.actions) {
            World world = this.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
            BrewActionList brewActionList2 = this.effects;
            if (brewActionList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"effects");
            }
            action.prepareSplashPotion(world, brewActionList2, modifiers);
        }
        this.modifiers = new ModifiersEffect(1.0, 0.5, false, position, modifiers);
    }

    protected void writeEntityToNBT(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        compound.setInteger("Age", this.ticksExisted);
        compound.setInteger("Duration", this.duration);
        compound.setInteger("WaitTime", this.waitTime);
        compound.setInteger("ReapplicationDelay", this.reapplicationDelay);
        compound.setInteger("DurationOnUse", this.durationOnUse);
        compound.setFloat("RadiusOnUse", this.radiusOnUse);
        compound.setFloat("RadiusPerTick", this.radiusPerTick);
        compound.setFloat("Radius", this.getRadius());
        UUID uUID = this.ownerUniqueId;
        if (uUID != null) {
            UUID uUID2 = uUID;
            boolean bl = false;
            boolean bl2 = false;
            UUID it = uUID2;
            boolean bl3 = false;
            compound.setUniqueId("OwnerUUID", it);
        }
        NBTTagList itemList = new NBTTagList();
        BrewActionList brewActionList = this.effects;
        if (brewActionList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"effects");
        }
        for (ItemStack item : brewActionList.items) {
            itemList.appendTag((NBTBase)item.writeToNBT(new NBTTagCompound()));
        }
        compound.setTag("Items", (NBTBase)itemList);
    }

    public void notifyDataManagerChange(@NotNull DataParameter<?> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        if (Intrinsics.areEqual(RADIUS, key)) {
            this.setRadius(this.getRadius());
        }
        super.notifyDataManagerChange(key);
    }

    @NotNull
    public EnumPushReaction getPushReaction() {
        return EnumPushReaction.IGNORE;
    }

    public EntityBrewEffectCloud(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world);
        this.reapplicationDelayMap = (Object2IntMap)new Object2IntOpenHashMap();
        this.waitTime = 20;
        this.reapplicationDelay = 20;
        this.noClip = true;
        this.isImmuneToFire = true;
        this.setRadius(3.0f);
    }

    public EntityBrewEffectCloud(@NotNull World world, double x, double y, double z, @NotNull BrewActionList actionList, @NotNull ModifiersImpact effect) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)actionList, (String)"actionList");
        Intrinsics.checkParameterIsNotNull((Object)effect, (String)"effect");
        this(world);
        this.setPosition(x, y, z);
        this.effects = actionList;
        Vec3d position = this.getPositionVector();
        this.modifiers = new ModifiersEffect(1.0, 0.5, false, position, effect);
        this.duration = effect.lifetime.get() >= 0 ? 5 + effect.lifetime.get() * effect.lifetime.get() * 200 : 100;
        this.setRadius(RangesKt.coerceAtMost((int)(2 + effect.extent.get()), (int)10));
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList itemList = new NBTTagList();
        BrewActionList brewActionList = this.effects;
        if (brewActionList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"effects");
        }
        for (ItemStack item : brewActionList.items) {
            itemList.appendTag((NBTBase)item.writeToNBT(new NBTTagCompound()));
        }
        compound.setTag("Items", (NBTBase)itemList);
        this.dataManager.set(DATA, (Object)compound);
    }

    static {
        Companion = new Companion(null);
        RADIUS = EntityDataManager.createKey(EntityBrewEffectCloud.class, (DataSerializer)DataSerializers.FLOAT);
        IGNORE_RADIUS = EntityDataManager.createKey(EntityBrewEffectCloud.class, (DataSerializer)DataSerializers.BOOLEAN);
        DATA = EntityDataManager.createKey(EntityBrewEffectCloud.class, (DataSerializer)DataSerializers.COMPOUND_TAG);
    }

    public static final /* synthetic */ BrewActionList access$getEffects$p(EntityBrewEffectCloud $this) {
        BrewActionList brewActionList = $this.effects;
        if (brewActionList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"effects");
        }
        return brewActionList;
    }

    public static final /* synthetic */ void access$setEffects$p(EntityBrewEffectCloud $this, BrewActionList brewActionList) {
        $this.effects = brewActionList;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\b0\b\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/msrandom/witchery/entity/EntityBrewEffectCloud$Companion;", "", "()V", "DATA", "Lnet/minecraft/network/datasync/DataParameter;", "Lnet/minecraft/nbt/NBTTagCompound;", "kotlin.jvm.PlatformType", "IGNORE_RADIUS", "", "RADIUS", "", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

