/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.item.ItemEarmuffs;
import net.msrandom.witchery.util.EntityUtil;

public class EntityBanshee
extends EntitySummonedUndead {
    public EntityBanshee(World par1World) {
        super(par1World);
        ((PathNavigateGround)this.getNavigator()).setBreakDoors(true);
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true, false, null));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE).setBaseValue(40.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.2);
        this.getEntityAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(0.0);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        boolean startedScreaming = false;
        if (!this.world.isRemote && (this.ticksExisted % 100 == 0 || this.isScreaming() && this.ticksExisted % 20 == 0)) {
            double RADIUS = 6.0;
            double RADIUS_SQ = 36.0;
            AxisAlignedBB bounds = new AxisAlignedBB(this.posX - RADIUS, this.posY - RADIUS, this.posZ - RADIUS, this.posX + RADIUS, this.posY + RADIUS, this.posZ + RADIUS);
            List players = this.world.getEntitiesWithinAABB(EntityLivingBase.class, bounds);
            boolean playersFound = false;
            for (EntityLivingBase player : players) {
                if (!(this.getDistanceSq((Entity)player) <= RADIUS_SQ) || player != this.getAttackTarget() && player != this.getAttackTarget() && !(player instanceof EntityPlayer)) continue;
                playersFound = true;
                if (!this.isScreaming()) {
                    this.setScreaming(true);
                    startedScreaming = true;
                }
                if (player instanceof EntityPlayer && ItemEarmuffs.isHelmWorn((EntityPlayer)player)) continue;
                float maxHealth = player.getMaxHealth();
                EntityUtil.touchOfDeath((Entity)player, (EntityLivingBase)this, Math.max(0.1f * maxHealth, 1.0f));
            }
            if (!playersFound && this.isScreaming()) {
                this.setScreaming(false);
            }
        }
        if ((startedScreaming || this.ticksExisted % 60 == 0) && this.isScreaming()) {
            this.playSound(WitcherySounds.ENTITY_BANSHEE_SCREAM, 1.0f, this.world.rand.nextFloat() * 0.3f + 0.7f);
        }
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return WitcherySounds.ENTITY_SPECTRE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_SPECTRE_HURT;
    }
}

