/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.entity;

import com.google.common.base.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.entity.passive.coven.WitchEntity;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.brews.ItemKettleBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.IHandleDeathTouch;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntityBabaYaga
extends EntityMob
implements IRangedAttackMob,
IEntityOwnable,
IHandleDeathTouch,
WitchEntity {
    private static final DataParameter<Boolean> AGGRESSIVE = EntityDataManager.createKey(EntityBabaYaga.class, (DataSerializer)DataSerializers.BOOLEAN);
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.createKey(EntityBabaYaga.class, (DataSerializer)DataSerializers.OPTIONAL_UNIQUE_ID);
    private static final Item[] witchDrops = new Item[]{WitcheryIngredientItems.SPECTRAL_DUST, WitcheryIngredientItems.BAT_WOOL, WitcheryIngredientItems.FROG_TOE, WitcheryIngredientItems.OWLETS_WING, WitcheryIngredientItems.DOG_TONGUE, WitcheryBrewItems.VINES_BREW, WitcheryBrewItems.SPROUTING_BREW, WitcheryBrewItems.HITCHCOCK_BREW, WitcheryBrewItems.CURSED_LEAPING_BREW, WitcheryBrewItems.FROGS_TONGUE_BREW};
    private static final double MAX_HEALTH = 500.0;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.getDisplayName(), BossInfo.Color.PURPLE, BossInfo.Overlay.NOTCHED_10).setDarkenSky(true);
    long ticksSinceTeleport = 0L;
    private int potionUseTimer;
    private EntityPlayer owner;

    public EntityBabaYaga(World par1World) {
        super(par1World);
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, entity -> !entity.getUniqueID().equals(this.getOwnerId())));
        this.experienceValue = 70;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(AGGRESSIVE, (Object)false);
        this.dataManager.register(OWNER, (Object)Optional.absent());
    }

    protected void updateAITasks() {
        super.updateAITasks();
        this.bossInfo.setPercent(this.getHealth() / this.getMaxHealth());
    }

    public void addTrackingPlayer(EntityPlayerMP player) {
        super.addTrackingPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void removeTrackingPlayer(EntityPlayerMP player) {
        super.removeTrackingPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public boolean isNonBoss() {
        return false;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        UUID ownerId = this.getOwnerId();
        if (ownerId != null) {
            par1NBTTagCompound.setUniqueId("Owner", ownerId);
        }
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.hasUniqueId("Owner")) {
            this.setOwnerId(par1NBTTagCompound.getUniqueId("Owner"));
        }
    }

    public UUID getOwnerId() {
        return (UUID)((Optional)this.dataManager.get(OWNER)).orNull();
    }

    public EntityPlayer getOwner() {
        if (this.owner == null) {
            this.owner = WitcheryUtils.getPlayer(this.world, this.getOwnerId());
        }
        return this.owner;
    }

    public void setOwnerId(UUID id) {
        this.dataManager.set(OWNER, (Object)Optional.fromNullable((Object)id));
    }

    public int getTotalArmorValue() {
        return 4;
    }

    protected SoundEvent getAmbientSound() {
        return WitcherySounds.ENTITY_BABA_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ENTITY_WITCH_HURT;
    }

    protected SoundEvent getDeathSound() {
        return WitcherySounds.ENTITY_BABA_DEATH;
    }

    public void setSwingingArms(boolean swingingArms) {
    }

    @Override
    public boolean isDrinkingPotion() {
        return (Boolean)this.dataManager.get(AGGRESSIVE);
    }

    @Override
    public void setDrinkingPotion(boolean par1) {
        this.dataManager.set(AGGRESSIVE, (Object)par1);
    }

    @Override
    public int getPotionUseTimer() {
        return this.potionUseTimer;
    }

    @Override
    public void setPotionUseTimer(int potionUseTimer) {
        this.potionUseTimer = potionUseTimer;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH).setBaseValue(500.0);
        this.getEntityAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue(0.3);
    }

    protected int decreaseAirSupply(int par1) {
        return par1;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    public void onLivingUpdate() {
        if (!this.world.isRemote) {
            EntityPlayer owner;
            WitchEntity.doWitchAttack(this);
            if ((this.getNavigator().noPath() || this.world.rand.nextDouble() < 0.02) && this.getAttackTarget() != null && (long)this.ticksExisted - this.ticksSinceTeleport > 100L) {
                this.ticksSinceTeleport = this.ticksExisted;
                this.teleportToEntity((Entity)this.getAttackTarget());
            }
            if (this.world.rand.nextDouble() < 0.05 && this.getAttackTarget() != null && (this.getAttackTarget().isAirBorne || this.getAttackTarget() instanceof EntityPlayer && ((EntityPlayer)this.getAttackTarget()).capabilities.isFlying) && !this.getAttackTarget().isPotionActive(MobEffects.SLOWNESS)) {
                this.getAttackTarget().addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 200, 5));
            }
            if ((owner = this.getOwner()) != null) {
                double distance = this.getDistanceSq((Entity)owner);
                if (distance < 64.0 && this.ticksExisted % 100 == 0) {
                    int l = this.rand.nextInt(3);
                    Item i1 = witchDrops[this.rand.nextInt(witchDrops.length - 3)];
                    for (int j1 = 0; j1 < l; ++j1) {
                        this.entityDropItem(new ItemStack(i1), 0.0f);
                    }
                }
                if (this.ticksExisted > 600) {
                    this.setDead();
                    this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                    this.world.setEntityState((Entity)this, (byte)16);
                }
            }
        }
        super.onLivingUpdate();
    }

    protected void teleportToEntity(Entity par1Entity) {
        Vec3d vec3 = new Vec3d(this.posX - par1Entity.posX, this.getEntityBoundingBox().minY + (double)(this.height / 2.0f) - par1Entity.posY + (double)par1Entity.getEyeHeight(), this.posZ - par1Entity.posZ);
        vec3 = vec3.normalize();
        double d0 = 8.0;
        double d2 = this.posX + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.x * d0;
        double d3 = this.posY + (double)(this.rand.nextInt(16) - 8) - vec3.y * d0;
        double d4 = this.posZ + (this.rand.nextDouble() - 0.5) * 8.0 - vec3.z * d0;
        this.teleportTo(d2, d3, d4);
    }

    protected void teleportTo(double par1, double par3, double par5) {
        double d3 = this.posX;
        double d4 = this.posY;
        double d5 = this.posZ;
        this.posX = par1;
        this.posY = par3;
        this.posZ = par5;
        boolean flag = false;
        BlockPos pos = this.getPosition();
        if (!this.world.isAirBlock(pos)) {
            boolean flag2 = false;
            while (!flag2 && pos.getY() > 0) {
                IBlockState block = this.world.getBlockState(pos.down());
                if (block.getMaterial().blocksMovement()) {
                    flag2 = true;
                    continue;
                }
                this.posY -= 1.0;
                pos = pos.down();
            }
            if (flag2) {
                this.setPosition(this.posX, this.posY, this.posZ);
                if (this.world.getCollisionBoxes((Entity)this, this.getEntityBoundingBox()).isEmpty() && !this.world.containsAnyLiquid(this.getEntityBoundingBox())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.setPosition(d3, d4, d5);
            return;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f3 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.posX - d3) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            double d8 = d4 + (this.posY - d4) * d6 + this.rand.nextDouble() * (double)this.height;
            double d9 = d5 + (this.posZ - d5) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            this.world.spawnParticle(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f2, (double)f3, new int[0]);
        }
        this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 1.0f, 1.0f);
    }

    protected float applyPotionDamageCalculations(DamageSource par1DamageSource, float par2) {
        par2 = super.applyPotionDamageCalculations(par1DamageSource, par2);
        if (par1DamageSource.getTrueSource() == this) {
            par2 = 0.0f;
        }
        if (par1DamageSource.isMagicDamage()) {
            par2 *= 0.15f;
        }
        return par2;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte par1) {
        if (par1 == 15) {
            for (int i = 0; i < this.rand.nextInt(35) + 10; ++i) {
                this.world.spawnParticle(EnumParticleTypes.SPELL_WITCH, this.posX + this.rand.nextGaussian() * (double)0.13f, this.getEntityBoundingBox().maxY + 0.5 + this.rand.nextGaussian() * (double)0.13f, this.posZ + this.rand.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (par1 == 16) {
            for (int i = 0; i < 20; ++i) {
                this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            super.handleStatusUpdate(par1);
        }
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (!WitcheryUtils.isInstantKill((EntityLivingBase)this, source, damage)) {
            EntityLiving attacker;
            boolean result2 = super.attackEntityFrom(source, Math.min(damage, 15.0f));
            if (!this.world.isRemote && source.getTrueSource() != null && source.getTrueSource() instanceof EntityLiving && ((attacker = (EntityLiving)source.getTrueSource()).getCreatureAttribute() == EnumCreatureAttribute.UNDEAD || attacker instanceof EntityTameable && !((EntityTameable)attacker).isTamed())) {
                EntityCaveSpider spider = new EntityCaveSpider(this.world);
                spider.setLocationAndAngles(attacker.posX, attacker.posY, attacker.posZ, attacker.rotationPitch, attacker.rotationYaw);
                EntityLivingBase target = this.getAttackTarget();
                spider.setAttackTarget(target);
                spider.setRevengeTarget(target);
                this.world.spawnEntity((Entity)spider);
                spider.playSound(SoundEvents.ENTITY_ITEM_PICKUP, 0.5f, 0.4f / (spider.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(spider.posX, spider.posY, spider.posZ, 2.0f, 2.0f, EnumParticleTypes.SPELL_MOB), (Entity)spider);
                attacker.setDead();
            }
            if (!this.world.isRemote && source.getTrueSource() != null && source.getTrueSource() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)source.getTrueSource();
                if (!CreatureUtil.isWoodenDamage(source)) {
                    player.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)this, (Entity)player), damage * 0.25f);
                }
            }
            return result2;
        }
        return super.attackEntityFrom(source, damage);
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (!this.world.isRemote) {
            this.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
        }
        for (int i = 0; i < 20; ++i) {
            this.world.spawnParticle(EnumParticleTypes.PORTAL, this.posX + this.rand.nextDouble() * 2.0 - 1.0, this.posY + this.rand.nextDouble() * 2.0, this.posZ + this.rand.nextDouble() * 2.0 - 1.0, 0.0, 0.0, 0.0, new int[0]);
        }
        this.setDead();
    }

    protected void dropFewItems(boolean par1, int par2) {
        int j = this.rand.nextInt(3) + 2;
        for (int k = 0; k < j; ++k) {
            int l = this.rand.nextInt(3) + 1;
            Item i1 = witchDrops[this.rand.nextInt(witchDrops.length)];
            if (par2 > 0) {
                l += this.rand.nextInt(par2 + 1);
            }
            for (int j2 = 0; j2 < l; ++j2) {
                this.entityDropItem(new ItemStack(i1), 0.0f);
            }
        }
        Enchantment enchantment = (Enchantment)Enchantment.REGISTRY.getRandomObject(this.rand);
        int m = MathHelper.getInt((Random)this.rand, (int)Math.min(enchantment.getMinLevel() + 2, enchantment.getMaxLevel()), (int)enchantment.getMaxLevel());
        this.entityDropItem(ItemEnchantedBook.getEnchantedItemStack((EnchantmentData)new EnchantmentData(enchantment, m)), 0.0f);
        this.entityDropItem(new ItemStack((Item)WitcheryEquipmentItems.BABAS_HAT), 0.0f);
    }

    public void attackEntityWithRangedAttack(EntityLivingBase par1EntityLivingBase, float par2) {
        if (!this.isDrinkingPotion()) {
            if (this.world.rand.nextInt(3) == 0) {
                ItemKettleBrew brew;
                switch (this.world.rand.nextInt(12)) {
                    case 0: 
                    case 1: {
                        brew = WitcheryBrewItems.WEBS_BREW;
                        break;
                    }
                    case 2: 
                    case 3: {
                        brew = WitcheryBrewItems.THORNS_BREW;
                        break;
                    }
                    case 4: 
                    case 5: {
                        brew = WitcheryBrewItems.FROGS_TONGUE_BREW;
                        break;
                    }
                    case 6: 
                    case 7: {
                        brew = WitcheryBrewItems.INK_BREW;
                        break;
                    }
                    case 8: 
                    case 9: {
                        brew = WitcheryBrewItems.HITCHCOCK_BREW;
                        break;
                    }
                    case 10: {
                        brew = WitcheryBrewItems.BATS_BREW;
                        break;
                    }
                    case 11: {
                        brew = WitcheryBrewItems.WASTING_BREW;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                EntityWitchProjectile entityWitchProjectile = new EntityWitchProjectile(this.world, (EntityLivingBase)this, new ItemStack((Item)brew));
                entityWitchProjectile.rotationPitch += 20.0f;
                double d0 = par1EntityLivingBase.posX + par1EntityLivingBase.motionX - this.posX;
                double d2 = par1EntityLivingBase.posY + (double)par1EntityLivingBase.getEyeHeight() - (double)1.1f - this.posY;
                double d3 = par1EntityLivingBase.posZ + par1EntityLivingBase.motionZ - this.posZ;
                float f1 = MathHelper.sqrt((double)(d0 * d0 + d3 * d3));
                entityWitchProjectile.shoot(d0, d2 + (double)(f1 * 0.2f), d3, 0.75f, 8.0f);
                this.world.spawnEntity((Entity)entityWitchProjectile);
            } else {
                PotionType type = PotionTypes.HARMING;
                ItemStack stack = new ItemStack((Item)Items.SPLASH_POTION);
                double d4 = par1EntityLivingBase.posX + par1EntityLivingBase.motionX - this.posX;
                double d5 = par1EntityLivingBase.posY + (double)par1EntityLivingBase.getEyeHeight() - (double)1.1f - this.posY;
                double d6 = par1EntityLivingBase.posZ + par1EntityLivingBase.motionZ - this.posZ;
                float f2 = MathHelper.sqrt((double)(d4 * d4 + d6 * d6));
                if (f2 >= 8.0f && !par1EntityLivingBase.isPotionActive(MobEffects.SLOWNESS)) {
                    type = PotionTypes.SLOWNESS;
                } else if (par1EntityLivingBase.getHealth() >= 8.0f && !par1EntityLivingBase.isPotionActive(MobEffects.POISON)) {
                    type = PotionTypes.POISON;
                } else if (f2 <= 3.0f && !par1EntityLivingBase.isPotionActive(MobEffects.WEAKNESS) && this.rand.nextFloat() < 0.25f) {
                    type = PotionTypes.WEAKNESS;
                }
                EntityPotion entityPotion = new EntityPotion(this.world, (EntityLivingBase)this, PotionUtils.addPotionToItemStack((ItemStack)stack, (PotionType)type));
                entityPotion.rotationPitch += 20.0f;
                entityPotion.shoot(d4, d5 + (double)(f2 * 0.2f), d6, 0.75f, 8.0f);
                this.world.spawnEntity((Entity)entityPotion);
            }
        }
    }
}

