/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.dispenser;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;

public class BehaviourGlassBottle
implements IBehaviorDispenseItem {
    private final BehaviorDefaultDispenseItem defaultDispenserItemBehavior = new BehaviorDefaultDispenseItem();

    public ItemStack dispense(IBlockSource source, ItemStack stack) {
        EnumFacing facing = (EnumFacing)source.getBlockState().getValue((IProperty)BlockDispenser.FACING);
        for (EnumFacing cauldronFacing : EnumFacing.values()) {
            if (cauldronFacing == facing) continue;
            BlockPos pos = source.getBlockPos().offset(cauldronFacing);
            Block replaceBlock = source.getWorld().getBlockState(pos).getBlock();
            if (replaceBlock != WitcheryBlocks.CAULDRON) continue;
            ItemStack brew = WitcheryBlocks.CAULDRON.fillBottleFromCauldron(source.getWorld(), pos);
            if (!brew.isEmpty()) {
                IPosition position = BlockDispenser.getDispensePosition((IBlockSource)source);
                BehaviorDefaultDispenseItem.doDispense((World)source.getWorld(), (ItemStack)brew, (int)6, (EnumFacing)facing, (IPosition)position);
                stack.splitStack(1);
                source.getWorld().playEvent(1000, source.getBlockPos(), 0);
            }
            return stack;
        }
        return this.defaultDispenserItemBehavior.dispense(source, stack);
    }
}

