/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.dispenser;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.item.ItemEndlessWaterBrew;
import net.msrandom.witchery.util.BlockUtil;

public class BehaviourEndlessWater
implements IBehaviorDispenseItem {
    public ItemStack dispense(IBlockSource block, ItemStack stack) {
        if (!block.getWorld().isRemote) {
            EnumFacing facing = (EnumFacing)block.getBlockState().getValue((IProperty)BlockDispenser.FACING);
            int x = block.getBlockPos().getX() + facing.getXOffset();
            int y = block.getBlockPos().getY() + facing.getYOffset();
            int z = block.getBlockPos().getZ() + facing.getZOffset();
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState replaceBlock = block.getWorld().getBlockState(pos);
            FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)block.getWorld()));
            ItemEndlessWaterBrew item = (ItemEndlessWaterBrew)stack.getItem();
            if (item.getRemaining(stack) >= 1000) {
                if (BlockUtil.isReplaceableBlock(block.getWorld(), x, y, z, (EntityLivingBase)fakePlayer) && replaceBlock.getMaterial() != Material.WATER) {
                    item.use((EntityPlayer)fakePlayer, stack, 1000);
                    block.getWorld().setBlockState(pos, Blocks.FLOWING_WATER.getDefaultState());
                    block.getWorld().notifyBlockUpdate(pos, replaceBlock, replaceBlock, 0);
                    block.getWorld().playSound(null, pos, SoundEvents.ENTITY_PLAYER_SPLASH, SoundCategory.BLOCKS, 0.5f, 0.4f / (block.getWorld().rand.nextFloat() * 0.4f + 0.8f));
                } else if (replaceBlock.getBlock() == WitcheryBlocks.CAULDRON) {
                    if (WitcheryBlocks.CAULDRON.tryFillWith(block.getWorld(), pos, new FluidStack(FluidRegistry.WATER, 3000))) {
                        item.use((EntityPlayer)fakePlayer, stack, 3000);
                    }
                } else if (replaceBlock.getBlock() == WitcheryBlocks.KETTLE && WitcheryBlocks.KETTLE.tryFillWith(block.getWorld(), pos, new FluidStack(FluidRegistry.WATER, 1000))) {
                    item.use((EntityPlayer)fakePlayer, stack, 1000);
                }
            }
        }
        return stack;
    }
}

