/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.dispenser;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryWoodType;
import net.msrandom.witchery.entity.item.EntityWitchBoat;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/msrandom/witchery/dispenser/BehaviorWitchBoat;", "Lnet/minecraft/dispenser/BehaviorDefaultDispenseItem;", "woodType", "Lnet/msrandom/witchery/block/WitcheryWoodType;", "(Lnet/msrandom/witchery/block/WitcheryWoodType;)V", "dispenseBehavior", "dispenseStack", "Lnet/minecraft/item/ItemStack;", "source", "Lnet/minecraft/dispenser/IBlockSource;", "stack", "playDispenseSound", "", "WitcheryResurrected"})
public final class BehaviorWitchBoat
extends BehaviorDefaultDispenseItem {
    private final BehaviorDefaultDispenseItem dispenseBehavior;
    private final WitcheryWoodType woodType;

    @NotNull
    public ItemStack dispenseStack(@NotNull IBlockSource source, @NotNull ItemStack stack) {
        double d;
        double d2;
        double d1;
        double d0;
        World world;
        EnumFacing facing;
        block3: {
            block5: {
                block4: {
                    Material material;
                    BlockPos pos;
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                        facing = (EnumFacing)source.getBlockState().getValue((IProperty)BlockDispenser.FACING);
                        world = source.getWorld();
                        double d3 = source.getX();
                        EnumFacing enumFacing = facing;
                        Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"facing");
                        d0 = d3 + (double)enumFacing.getXOffset() * 1.125;
                        d1 = source.getY() + (double)facing.getYOffset() * 1.125;
                        d2 = source.getZ() + (double)facing.getZOffset() * 1.125;
                        pos = source.getBlockPos().offset(facing);
                        IBlockState iBlockState = world.getBlockState(pos);
                        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos)");
                        material = iBlockState.getMaterial();
                        if (!Intrinsics.areEqual((Object)Material.WATER, (Object)material)) break block2;
                        d = 1.0;
                        break block3;
                    }
                    if (Intrinsics.areEqual((Object)Material.AIR, (Object)material) ^ true) break block4;
                    IBlockState iBlockState = world.getBlockState(pos.down());
                    Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos.down())");
                    if (!(Intrinsics.areEqual((Object)Material.WATER, (Object)iBlockState.getMaterial()) ^ true)) break block5;
                }
                ItemStack itemStack = this.dispenseBehavior.dispense(source, stack);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"dispenseBehavior.dispense(source, stack)");
                return itemStack;
            }
            d = 0.0;
        }
        double d3 = d;
        World world2 = world;
        Intrinsics.checkExpressionValueIsNotNull((Object)world2, (String)"world");
        EntityWitchBoat boat2 = new EntityWitchBoat(world2, d0, d1 + d3, d2, this.woodType);
        boat2.rotationYaw = facing.getHorizontalAngle();
        world.spawnEntity((Entity)boat2);
        stack.shrink(1);
        return stack;
    }

    protected void playDispenseSound(@NotNull IBlockSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        source.getWorld().playEvent(1000, source.getBlockPos(), 0);
    }

    public BehaviorWitchBoat(@NotNull WitcheryWoodType woodType) {
        Intrinsics.checkParameterIsNotNull((Object)woodType, (String)"woodType");
        this.woodType = woodType;
        this.dispenseBehavior = new BehaviorDefaultDispenseItem();
    }
}

