/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.common.events;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fluids.BlockFluidBase;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryEntities;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemCrossbowPistol;
import net.msrandom.witchery.item.bolts.ItemCrossbowBolt;
import net.msrandom.witchery.registry.RegistryWrappers;
import net.msrandom.witchery.util.ReflectiveLambdaGenerator;
import net.msrandom.witchery.util.ResizingUtils;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\u0010\u000e\u001a6\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0000\u001a\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a(\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0000\"2\u0010\u0000\u001a&\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002 \u0003*\u0012\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0003*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"N\u0010\u0006\u001aB\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\t0\t \u0003* \u0012\f\u0012\n \u0003*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\t0\t\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"canDropLoot", "Ljava/util/function/Predicate;", "Lnet/minecraft/entity/EntityLivingBase;", "kotlin.jvm.PlatformType", "dropEquipment", "Lnet/msrandom/witchery/util/ReflectiveLambdaGenerator$EquipmentDropper;", "getLootTable", "Lkotlin/Function1;", "Lnet/minecraft/entity/EntityLiving;", "Lnet/minecraft/util/ResourceLocation;", "constructEntity", "", "entity", "Lnet/minecraft/entity/Entity;", "(Lnet/minecraft/entity/Entity;)Lkotlin/Unit;", "livingDrops", "", "livingEntity", "source", "Lnet/minecraft/util/DamageSource;", "isRecentlyHit", "lootingLevel", "", "drops", "", "Lnet/minecraft/entity/item/EntityItem;", "tickItem", "stack", "Lnet/minecraft/item/ItemStack;", "useBucket", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "hit", "Lnet/minecraft/util/math/RayTraceResult;", "WitcheryResurrected"})
@JvmName(name="CommonEventHandler")
public final class CommonEventHandler {
    private static final Predicate<EntityLivingBase> canDropLoot = ReflectiveLambdaGenerator.getLootDropableMethod();
    private static final Function1<EntityLiving, ResourceLocation> getLootTable = ReflectiveLambdaGenerator.getLootTableGetter();
    private static final ReflectiveLambdaGenerator.EquipmentDropper dropEquipment = ReflectiveLambdaGenerator.getDropEquipmentMethod();

    public static final boolean livingDrops(@NotNull EntityLivingBase livingEntity, @NotNull DamageSource source, boolean isRecentlyHit, int lootingLevel, @NotNull List<EntityItem> drops) {
        block9: {
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)livingEntity, (String)"livingEntity");
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull(drops, (String)"drops");
                if (livingEntity.world.isRemote) break block9;
                if (WitcheryUtils.isNoDrops(livingEntity)) {
                    return false;
                }
                if (!(livingEntity instanceof EntitySkeletonHorse)) break block10;
                NBTTagCompound horseData = ((EntitySkeletonHorse)livingEntity).getEntityData();
                if (!horseData.getBoolean("WitcheryIsBinky")) break block9;
                drops.clear();
                Collection collection = drops;
                EntityItem entityItem = new EntityItem(livingEntity.world, livingEntity.posX, livingEntity.posY, livingEntity.posZ, new ItemStack(WitcheryIngredientItems.BINKY_HEAD));
                boolean bl = false;
                collection.add(entityItem);
                break block9;
            }
            if (!(livingEntity instanceof EntityLiving)) break block9;
            Map horseData = WitcheryEntities.LOOT_TABLES;
            ResourceLocation resourceLocation = ((EntityLiving)livingEntity).getClass();
            boolean bl = false;
            Map map = horseData;
            boolean bl2 = false;
            if (map.containsKey(resourceLocation) && canDropLoot.test(livingEntity) && getLootTable.invoke((Object)livingEntity) == null) {
                LootTable table;
                LootTable lootTable;
                ResourceLocation resourceLocation2 = WitcheryEntities.LOOT_TABLES.get(((EntityLiving)livingEntity).getClass());
                if (resourceLocation2 != null) {
                    resourceLocation = resourceLocation2;
                    bl = false;
                    boolean bl3 = false;
                    ResourceLocation it = resourceLocation;
                    boolean bl4 = false;
                    World world = livingEntity.world;
                    Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"livingEntity.world");
                    lootTable = world.getLootTableManager().getLootTableFromLocation(it);
                } else {
                    lootTable = null;
                }
                LootTable lootTable2 = table = lootTable;
                if (lootTable2 != null) {
                    resourceLocation = lootTable2;
                    bl = false;
                    boolean bl5 = false;
                    ResourceLocation it = resourceLocation;
                    boolean bl6 = false;
                    World world = livingEntity.world;
                    if (world == null) {
                        throw new TypeCastException("null cannot be cast to non-null type net.minecraft.world.WorldServer");
                    }
                    LootContext.Builder builder = new LootContext.Builder((WorldServer)world).withLootedEntity((Entity)livingEntity).withDamageSource(source);
                    if (isRecentlyHit && ((EntityLiving)livingEntity).getAttackingEntity() instanceof EntityPlayer) {
                        EntityLivingBase entityLivingBase = ((EntityLiving)livingEntity).getAttackingEntity();
                        if (entityLivingBase == null) {
                            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
                        }
                        EntityPlayer player = (EntityPlayer)entityLivingBase;
                        builder = builder.withPlayer(player).withLuck(player.getLuck());
                    }
                    for (ItemStack stack : it.generateLootForPools(((EntityLiving)livingEntity).getRNG(), builder.build())) {
                        livingEntity.entityDropItem(stack, 0.0f);
                    }
                    dropEquipment.invoke((EntityLiving)livingEntity, isRecentlyHit, lootingLevel);
                }
            }
        }
        return true;
    }

    @Nullable
    public static final Unit constructEntity(@NotNull Entity entity) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        EntityType.Size size = WitcheryEntities.SIZES.get(entity.getClass());
        if (size != null) {
            EntityType.Size size2 = size;
            boolean bl = false;
            boolean bl2 = false;
            EntityType.Size it = size2;
            boolean bl3 = false;
            ResizingUtils.setSize(entity, it.getWidth(), it.getHeight());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final ItemStack useBucket(@NotNull EntityPlayer player, @NotNull World world, @NotNull BlockPos pos, @NotNull RayTraceResult hit) {
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
                Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                Intrinsics.checkParameterIsNotNull((Object)hit, (String)"hit");
                if (hit.typeOfHit != RayTraceResult.Type.BLOCK) break block7;
                var4_4 = world.getBlockState(pos);
                var5_5 = false;
                var6_8 = false;
                it = var4_4;
                $i$a$-let-CommonEventHandler$useBucket$1 = false;
                v0 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it");
                if (Intrinsics.areEqual((Object)v0.getBlock(), (Object)WitcheryBlocks.BREW_FLUID) ^ true) ** GOTO lbl-1000
                v1 = (Integer)it.getValue((IProperty)BlockFluidBase.LEVEL);
                if (v1 == null || v1 != 0) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                if (!v2) break block8;
            }
            v3 = ItemStack.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"ItemStack.EMPTY");
            return v3;
        }
        result = new ItemStack((Item)WitcheryGeneralItems.BREW_BUCKET);
        v4 = WitcheryTileEntities.BREW_FLUID.getAt((IBlockAccess)world, pos);
        if (v4 != null) {
            var5_6 = v4;
            var6_8 = false;
            var7_10 = false;
            it = var5_6;
            $i$a$-let-CommonEventHandler$useBucket$2 = false;
            result.setTagCompound(it.getEffects());
        }
        v5 = Blocks.AIR;
        Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"Blocks.AIR");
        world.setBlockState(pos, v5.getDefaultState(), 11);
        v6 = StatList.getObjectUseStats((Item)Items.BUCKET);
        if (v6 != null) {
            var5_7 = v6;
            var6_8 = false;
            var7_11 = false;
            it = var5_7;
            $i$a$-let-CommonEventHandler$useBucket$3 = false;
            player.addStat(it);
        }
        player.playSound(SoundEvents.ITEM_BUCKET_FILL, 1.0f, 1.0f);
        return result;
    }

    public static final void tickItem(@NotNull EntityLivingBase entity, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!entity.world.isRemote && entity instanceof EntityPlayer) {
            ItemStack offHand = ((EntityPlayer)entity).getHeldItemOffhand();
            if (Intrinsics.areEqual((Object)((EntityPlayer)entity).getHeldItemMainhand(), (Object)stack)) {
                int elapsed;
                ItemStack itemStack = offHand;
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"offHand");
                if (itemStack.getItem() instanceof ItemCrossbowPistol && (elapsed = (stack.getMaxItemUseDuration() - ((EntityPlayer)entity).getItemInUseCount()) % 25) > 0) {
                    if (elapsed < 24) {
                        if (elapsed % 6 == 0) {
                            WitcheryUtils.playSoundAt((EntityPlayer)entity, WitcherySounds.ITEM_CROSSBOW_CLICK, 1.0f, 1.0f);
                        }
                    } else {
                        ItemStack ammo;
                        ItemStack itemStack2;
                        Item loadedProjectile = ItemCrossbowPistol.Companion.getProjectile(offHand);
                        boolean shrink = false;
                        if (loadedProjectile == null) {
                            String string = WitcheryUtils.getOrCreateTag(stack).getString("PreferredBolt");
                            EntityPlayer entityPlayer = (EntityPlayer)entity;
                            ItemCrossbowPistol.Companion companion = ItemCrossbowPistol.Companion;
                            boolean bl = false;
                            boolean bl2 = false;
                            String $this$with = string;
                            boolean bl3 = false;
                            CharSequence charSequence = $this$with;
                            boolean bl4 = false;
                            Item item = charSequence.length() == 0 ? null : RegistryWrappers.ITEMS.get(new ResourceLocation($this$with));
                            ItemStack bolt = companion.findBolt(entityPlayer, item);
                            shrink = true;
                            itemStack2 = bolt.isEmpty() ? ItemStack.EMPTY : bolt;
                        } else {
                            shrink = false;
                            itemStack2 = new ItemStack(loadedProjectile);
                        }
                        ItemStack itemStack3 = ammo = itemStack2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"ammo");
                        if (!itemStack3.isEmpty()) {
                            WitcheryUtils.playSoundAt((EntityPlayer)entity, WitcherySounds.ITEM_CROSSBOW_WINDUP, 1.0f, 1.0f);
                            World world = entity.world;
                            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"entity.world");
                            Item item = ammo.getItem();
                            if (item == null) {
                                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.item.bolts.ItemCrossbowBolt");
                            }
                            if (ItemCrossbowPistol.Companion.launchBolt(offHand, world, (EntityPlayer)entity, (ItemCrossbowBolt)item, true, false)) {
                                if (shrink) {
                                    if (!((EntityPlayer)entity).capabilities.isCreativeMode) {
                                        ammo.shrink(1);
                                    }
                                } else {
                                    ItemCrossbowPistol.Companion.clearProjectile(stack);
                                }
                                entity.resetActiveHand();
                            }
                        }
                    }
                }
            }
        }
    }
}

