/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.common;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityWerewolf;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.PacketSyncEntitySize;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.resources.AlternateFormStatManager;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.transformation.AlternateFormStatType;
import net.msrandom.witchery.transformation.Transformation;
import net.msrandom.witchery.transformation.WerewolfTransformation;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.EntitySizeInfo;
import net.msrandom.witchery.util.ResizingUtils;
import net.msrandom.witchery.util.WitcheryUtils;

public class ShapeShift {
    public static final ShapeShift INSTANCE = new ShapeShift();
    public static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(UUID.fromString("10536417-7AA6-4033-A598-8E934CA77D98"), "Witchery Speed", 0.5, 2);
    public static final AttributeModifier DAMAGE_MODIFIER = new AttributeModifier(UUID.fromString("46C5271C-193B-4D41-9CAB-D071AAEE9D4A"), "Witchery Damage", 6.0, 2);
    public static final AttributeModifier HEALTH_MODIFIER = new AttributeModifier(UUID.fromString("615920F9-6675-4779-8B18-6A62A3671E94"), "Witchery Health", 40.0, 0);

    public void initCurrentShift(EntityPlayer player) {
        if (!player.world.isRemote) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            EntitySizeInfo sizeInfo = new EntitySizeInfo((EntityLivingBase)player);
            player.eyeHeight = sizeInfo.eyeHeight;
            this.initCurrentShift((EntityLivingBase)player, player, true);
            AlternateForm.Stats stats2 = this.getFormStats(playerEx);
            if (!player.capabilities.isCreativeMode) {
                player.capabilities.allowFlying = stats2.canFly();
                if (!player.capabilities.allowFlying && player.capabilities.isFlying) {
                    player.capabilities.isFlying = false;
                } else if (player.capabilities.allowFlying) {
                    player.capabilities.isFlying = true;
                }
                player.sendPlayerAbilities();
            }
            WitcheryNetworkChannel.sendToAll(new PacketSyncEntitySize((Entity)player));
        }
    }

    public void initCurrentShift(EntityLivingBase entity, EntityPlayer player, boolean applyDamage) {
        if (!entity.world.isRemote) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            EntitySizeInfo sizeInfo = new EntitySizeInfo((EntityLivingBase)player);
            ResizingUtils.setSize((Entity)entity, sizeInfo.defaultWidth, sizeInfo.defaultHeight);
            entity.stepHeight = sizeInfo.stepSize;
            AbstractAttributeMap playerAttributes = entity.getAttributeMap();
            AlternateForm.Stats stats2 = this.getFormStats(playerEx);
            if (stats2.getTransformationType() == null || playerEx.isTransformation(stats2.getTransformationType())) {
                this.applyModifier(SharedMonsterAttributes.MOVEMENT_SPEED, SPEED_MODIFIER, this.getStat(playerEx, AlternateFormStatType.SPEED), playerAttributes);
                if (applyDamage) {
                    this.applyModifier(SharedMonsterAttributes.ATTACK_DAMAGE, DAMAGE_MODIFIER, this.getStat(playerEx, AlternateFormStatType.DAMAGE), playerAttributes);
                }
                this.applyModifier(SharedMonsterAttributes.MAX_HEALTH, HEALTH_MODIFIER, this.getStat(playerEx, AlternateFormStatType.HEALTH), playerAttributes);
            } else {
                this.removeModifier(SharedMonsterAttributes.MOVEMENT_SPEED, SPEED_MODIFIER, playerAttributes);
                if (applyDamage) {
                    this.removeModifier(SharedMonsterAttributes.ATTACK_DAMAGE, DAMAGE_MODIFIER, playerAttributes);
                }
                this.removeModifier(SharedMonsterAttributes.MAX_HEALTH, HEALTH_MODIFIER, playerAttributes);
            }
        }
    }

    public void updatePlayerState(EntityPlayer player, PlayerExtendedData playerEx) {
        if (playerEx.getCurrentForm() == WitcheryAlternateForms.BAT) {
            if (player.capabilities.isFlying) {
                player.fallDistance = 0.0f;
            }
            if (!player.capabilities.allowFlying && !player.capabilities.isCreativeMode) {
                player.capabilities.allowFlying = true;
                player.sendPlayerAbilities();
            }
        }
    }

    public float updateFallState(EntityPlayer player, float distance) {
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        AlternateForm.Stats currentForm = this.getFormStats(playerEx);
        float fall = this.getStat(currentForm, playerEx, AlternateFormStatType.FALL);
        if (currentForm.canFly() || fall < 0.0f) {
            return 0.0f;
        }
        return Math.max(0.0f, distance - fall);
    }

    public void updateJump(EntityPlayer player) {
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        float jump = this.getStat(playerEx, AlternateFormStatType.JUMP);
        if (jump != 0.0f) {
            player.motionY += (double)jump;
            if (player.isSprinting()) {
                float f = player.rotationYaw * ((float)Math.PI / 180);
                float leap = this.getStat(playerEx, AlternateFormStatType.LEAP);
                player.motionX -= (double)(MathHelper.sin((float)f) * leap);
                player.motionZ += (double)(MathHelper.cos((float)f) * leap);
            }
        }
    }

    public float getStat(PlayerExtendedData playerEx, AlternateFormStatType type) {
        return this.getStat(this.getFormStats(playerEx), playerEx, type);
    }

    public AlternateForm.Stats getFormStats(PlayerExtendedData playerEx) {
        return AlternateFormStatManager.INSTANCE.getStats(playerEx.getEffectiveForm());
    }

    private float getStat(AlternateForm.Stats currentForm, PlayerExtendedData playerEx, AlternateFormStatType type) {
        Int2ObjectOpenHashMap<Object2FloatOpenHashMap<AlternateFormStatType>> cache = currentForm.statModifierCache;
        int level = currentForm.getTransformationType() == null ? 0 : ((Transformation)playerEx.getTransformation(currentForm.getTransformationType())).getLevel();
        Object2FloatOpenHashMap map = (Object2FloatOpenHashMap)cache.get(level);
        if (map == null) {
            map = new Object2FloatOpenHashMap();
            Int2ObjectOpenHashMap<Object2FloatOpenHashMap<AlternateFormStatType>> statModifiers = currentForm.getStatModifiers();
            for (int i = level; i >= 0; --i) {
                Object2FloatOpenHashMap levelModifiers = (Object2FloatOpenHashMap)statModifiers.get(i);
                if (levelModifiers == null) continue;
                for (Object2FloatMap.Entry entry2 : levelModifiers.object2FloatEntrySet()) {
                    AlternateFormStatType key = (AlternateFormStatType)entry2.getKey();
                    if (map.containsKey((Object)key)) continue;
                    map.put((Object)key, entry2.getFloatValue());
                }
            }
            cache.put(level, (Object)map);
        }
        return map.getFloat((Object)type);
    }

    public void updateChargeDamage(LivingHurtEvent event, EntityPlayer player, PlayerExtendedData playerEx) {
        if (this.isWolfAnimalForm(playerEx)) {
            if (this.itemHasDamageAttribute(player.getHeldItem(player.getActiveHand()))) {
                event.setAmount(2.0f);
            } else {
                float damage = this.getStat(playerEx, AlternateFormStatType.DAMAGE);
                if (damage != 0.0f && player.isSprinting()) {
                    event.setAmount(event.getAmount() + damage);
                }
            }
        }
        if (playerEx.getTransformation(WitcheryTransformations.WEREWOLF).getLevel() >= 3 && playerEx.getCurrentForm() == null && player.isSneaking()) {
            double ACCELERATION = 3.0;
            Vec3d look = player.getLookVec();
            double motionX = look.x * 0.6 * ACCELERATION;
            double motionY = 0.8999999999999999;
            double motionZ = look.z * 0.6 * ACCELERATION;
            if (event.getEntityLiving() instanceof EntityPlayerMP) {
                WitcheryNetworkChannel.sendTo(new PacketPushTarget(motionX, motionY, motionZ), (EntityPlayerMP)event.getEntityLiving());
            } else {
                event.getEntityLiving().motionX = motionX;
                event.getEntityLiving().motionY = motionY;
                event.getEntityLiving().motionZ = motionZ;
            }
        }
    }

    private boolean itemHasDamageAttribute(ItemStack item) {
        if (item == null) {
            return false;
        }
        EntityEquipmentSlot slot = item.getItem().getEquipmentSlot(item);
        Multimap modifiers = item.getAttributeModifiers(slot == null ? EntityEquipmentSlot.MAINHAND : slot);
        return modifiers.containsKey((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName());
    }

    public void rendArmor(EntityLivingBase victim, EntityPlayer player, PlayerExtendedData playerEx) {
        EntityEquipmentSlot slot;
        ItemStack armor;
        if (playerEx.getCurrentForm() == WitcheryAlternateForms.WOLFMAN && playerEx.getTransformation(WitcheryTransformations.WEREWOLF).getLevel() >= 9 && !(armor = victim.getItemStackFromSlot(slot = EntityEquipmentSlot.values()[1 + victim.world.rand.nextInt(4)])).isEmpty()) {
            boolean ripOffArmor;
            boolean bl = ripOffArmor = !armor.isItemStackDamageable();
            if (!ripOffArmor) {
                int damage = armor.getItemDamage();
                int rendAmount = (int)Math.ceil((float)armor.getMaxDamage() * 0.25f);
                armor.damageItem(rendAmount, (EntityLivingBase)player);
                if (victim instanceof EntityPlayer && armor.getItem() instanceof ItemArmor) {
                    ItemArmor armorItem = (ItemArmor)armor.getItem();
                    armorItem.onArmorTick(victim.world, (EntityPlayer)victim, armor);
                }
                boolean bl2 = ripOffArmor = armor.getItemDamage() <= damage;
            }
            if (ripOffArmor && victim instanceof EntityPlayer) {
                victim.setItemStackToSlot(slot, ItemStack.EMPTY);
                EntityItem droppedItem = victim.entityDropItem(armor, 1.0f);
                if (droppedItem != null) {
                    droppedItem.setPickupDelay(100);
                }
            }
        }
    }

    public void processCreatureKilled(LivingDeathEvent event, EntityPlayer attacker, PlayerExtendedData playerEx) {
        if (this.isWolfAnimalForm(playerEx) && playerEx.getTransformation(WitcheryTransformations.WEREWOLF).getLevel() >= 4 && !CreatureUtil.isUndead((Entity)event.getEntityLiving())) {
            if (attacker.getRNG().nextInt(3) == 0) {
                attacker.world.playSound(null, event.getEntityLiving().getPosition(), WitcherySounds.ENTITY_WEREWOLF_EAT, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)event.getEntityLiving().getRNG().nextDouble() * 0.4f + 0.8f));
            }
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles((Entity)event.getEntityLiving(), 1.0f, 2.0f, EnumParticleTypes.REDSTONE), (Entity)event.getEntityLiving());
            attacker.getFoodStats().addStats(8, 0.8f);
        }
    }

    public void processDigging(BlockEvent.HarvestDropsEvent event, EntityPlayer player, PlayerExtendedData playerEx) {
        long serverTime;
        long lastFind;
        WerewolfTransformation transformation = playerEx.getTransformation(WitcheryTransformations.WEREWOLF);
        if (playerEx.getCurrentForm() == WitcheryAlternateForms.WOLF && transformation.getLevel() >= 3 && event.getDrops().size() == 1 && ((ItemStack)event.getDrops().get(0)).getItem() == Item.getItemFromBlock((Block)Blocks.DIRT) && (lastFind = transformation.getLastBoneFind()) + 60000L < (serverTime = MinecraftServer.getCurrentTimeMillis()) && player.world.rand.nextInt(20) == 0) {
            transformation.setLastBoneFind(serverTime);
            event.getDrops().add(new ItemStack(Items.BONE, player.world.rand.nextInt(5) == 0 ? 2 : 1));
        }
    }

    public void processWolfInfection(EntityLivingBase entityLiving, PlayerExtendedData playerEx, float health) {
        if (playerEx.getTransformation(WitcheryTransformations.WEREWOLF).getLevel() >= 10 && this.isWolfAnimalForm(playerEx)) {
            if (entityLiving instanceof EntityVillager) {
                if (health < entityLiving.getMaxHealth() * 0.25f && health > 0.0f && entityLiving.world.rand.nextInt(4) == 1) {
                    EntityVillager villager = (EntityVillager)entityLiving;
                    NBTTagCompound data = new NBTTagCompound();
                    villager.writeEntityToNBT(data);
                    EntityWerewolf.convertToVillager((EntityLiving)villager, data, false);
                }
            } else if (entityLiving instanceof EntityPlayer && WitcheryConfigOptions.allowPlayerToPlayerWolfInfection) {
                WerewolfTransformation transformation;
                EntityPlayer victim = (EntityPlayer)entityLiving;
                PlayerExtendedData victimEx = WitcheryUtils.getExtension(victim);
                if (health < entityLiving.getMaxHealth() * 0.25f && health > 0.0f && !ItemHunterClothes.isWolfProtectionActive(entityLiving) && entityLiving.world.rand.nextInt(4) == 1 && (WitcheryConfigOptions.allowVampireWolfHybrids || !playerEx.isTransformation(WitcheryTransformations.VAMPIRE)) && (transformation = victimEx.getTransformation(WitcheryTransformations.WEREWOLF)).getLevel() == 0) {
                    transformation.setLevel(1);
                    victim.sendMessage(new TextComponentTranslation("witchery.werewolf.infection", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                }
            }
        }
    }

    public void processWolfInfection(EntityLivingBase entityLiving, EntityWerewolf attackingEntity, float health) {
        if (attackingEntity.isInfectious()) {
            if (entityLiving instanceof EntityVillager) {
                if (health < entityLiving.getMaxHealth() * 0.25f) {
                    EntityVillager villager = (EntityVillager)entityLiving;
                    NBTTagCompound data = new NBTTagCompound();
                    villager.writeEntityToNBT(data);
                    EntityWerewolf.convertToVillager((EntityLiving)villager, data, false);
                }
            } else if (entityLiving instanceof EntityPlayer) {
                WerewolfTransformation transformation;
                EntityPlayer victim = (EntityPlayer)entityLiving;
                PlayerExtendedData victimEx = WitcheryUtils.getExtension(victim);
                if ((WitcheryConfigOptions.allowVampireWolfHybrids || !victimEx.isTransformation(WitcheryTransformations.VAMPIRE)) && (transformation = victimEx.getTransformation(WitcheryTransformations.WEREWOLF)).getLevel() == 0) {
                    transformation.setLevel(1);
                    victim.sendMessage(new TextComponentTranslation("witchery.werewolf.infection", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                }
            }
        }
    }

    public boolean isAnimalForm(EntityPlayer player) {
        return this.isWolfAnimalForm(WitcheryUtils.getExtension(player));
    }

    public boolean isWolfAnimalForm(PlayerExtendedData playerEx) {
        return playerEx.getCurrentForm() != null && this.getFormStats(playerEx).canHowl();
    }

    public boolean isWolfmanAllowed(WerewolfTransformation transformation) {
        return transformation.getLevel() >= 5;
    }

    public boolean canControlTransform(WerewolfTransformation transformation) {
        return transformation.getLevel() >= 2;
    }

    public void applyModifier(IAttribute attribute, AttributeModifier modifier, double modification, AbstractAttributeMap playerAttributes) {
        IAttributeInstance attributeInstance = playerAttributes.getAttributeInstance(attribute);
        AttributeModifier attributeModifier = new AttributeModifier(modifier.getID(), modifier.getName(), modification, modifier.getOperation());
        attributeInstance.removeModifier(attributeModifier.getID());
        attributeInstance.applyModifier(attributeModifier);
    }

    public void removeModifier(IAttribute attribute, AttributeModifier modifier, AbstractAttributeMap playerAttributes) {
        IAttributeInstance attributeInstance = playerAttributes.getAttributeInstance(attribute);
        attributeInstance.removeModifier(modifier.getID());
    }
}

