/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.common;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.client.PacketUpdateRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.village.Village;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.biome.BiomeSavanna;
import net.minecraft.world.biome.BiomeTaiga;
import net.minecraft.world.loot.conditions.BlockStatePropertyCondition;
import net.minecraft.world.loot.conditions.MatchToolCondition;
import net.minecraft.world.loot.conditions.SurvivesExplosionCondition;
import net.minecraft.world.loot.functions.ExplosionDecayFunction;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.BlockAreaMarker;
import net.msrandom.witchery.block.BlockCoffin;
import net.msrandom.witchery.block.BlockVoidBramble;
import net.msrandom.witchery.block.WitcheryBlockLog;
import net.msrandom.witchery.block.WitcheryBlockPlanks;
import net.msrandom.witchery.block.WitcheryBlockPressurePlate;
import net.msrandom.witchery.block.WitcheryBlockSapling;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ritual.SmallRitual;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.common.events.CommonEventHandler;
import net.msrandom.witchery.common.events.PredictionsEventHandler;
import net.msrandom.witchery.config.WitcheryConfig;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityBroom;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.entity.EntityMindrake;
import net.msrandom.witchery.entity.EntityRitualItem;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.entity.EntityWereVillager;
import net.msrandom.witchery.entity.EntityWerewolf;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.entity.ai.EntityAIDigBlocks;
import net.msrandom.witchery.entity.ai.EntityAISleep;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.entity.item.EntityCrossbowBolt;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.entity.passive.EntityElle;
import net.msrandom.witchery.entity.passive.EntityOwl;
import net.msrandom.witchery.entity.passive.EntityToad;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.extensions.ExtendedDataManager;
import net.msrandom.witchery.extensions.LivingExtendedData;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.extensions.VillagerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.OverworldInfusion;
import net.msrandom.witchery.infusion.PlayerEffects;
import net.msrandom.witchery.infusion.brew.InfusedBrewEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.init.data.WitcheryLootTables;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.init.infusions.WitcheryInfusedBrews;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.integration.IntegrationManager;
import net.msrandom.witchery.item.ItemDeathsClothes;
import net.msrandom.witchery.item.ItemDeathsHand;
import net.msrandom.witchery.item.ItemGlassGoblet;
import net.msrandom.witchery.item.ItemGoblinClothes;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.item.ItemMoonCharm;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.ItemWitchesClothes;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.network.PacketExtendedVillagerSync;
import net.msrandom.witchery.network.PacketHowl;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.PacketPlayerStyle;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.PacketSelectPlayerAbility;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.network.resources.PacketUpdateAlternateFormStats;
import net.msrandom.witchery.network.resources.PacketUpdateBrewActions;
import net.msrandom.witchery.network.resources.PacketUpdateCreaturePowers;
import net.msrandom.witchery.network.resources.PacketUpdateRites;
import net.msrandom.witchery.network.resources.PacketUpdateSpiritEffects;
import net.msrandom.witchery.network.resources.PacketUpdateSymbolEffects;
import net.msrandom.witchery.potion.IHandleEnderTeleport;
import net.msrandom.witchery.potion.IHandleHarvestDrops;
import net.msrandom.witchery.potion.IHandleLivingDeath;
import net.msrandom.witchery.potion.IHandleLivingHurt;
import net.msrandom.witchery.potion.IHandleLivingJump;
import net.msrandom.witchery.potion.IHandleLivingSetAttackTarget;
import net.msrandom.witchery.potion.IHandleLivingUpdate;
import net.msrandom.witchery.potion.IHandlePlayerDrops;
import net.msrandom.witchery.potion.PotionEnslaved;
import net.msrandom.witchery.potion.PotionIllFitting;
import net.msrandom.witchery.potion.PotionParalysis;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.prediction.PredictionData;
import net.msrandom.witchery.resources.AlternateFormStatManager;
import net.msrandom.witchery.resources.BrewActionManager;
import net.msrandom.witchery.resources.CreaturePowerManager;
import net.msrandom.witchery.resources.RiteManager;
import net.msrandom.witchery.resources.SpiritEffectManager;
import net.msrandom.witchery.resources.SymbolEffectManager;
import net.msrandom.witchery.rite.curse.Curse;
import net.msrandom.witchery.rite.effect.RiteEffectPriorIncarnation;
import net.msrandom.witchery.rite.effect.RiteEffectProtectionCircleRepulsive;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.transformation.AlternateFormStatType;
import net.msrandom.witchery.transformation.Transformation;
import net.msrandom.witchery.transformation.TransformationType;
import net.msrandom.witchery.transformation.VampireTransformation;
import net.msrandom.witchery.transformation.WerewolfTransformation;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.WorldProviderSpiritWorld;
import net.msrandom.witchery.world.dimension.torment.WorldProviderTorment;

public class CommonEvents {
    public static void updateWerewolfEffects(EntityPlayer player) {
        player.addPotionEffect(new PotionEffect(MobEffects.NIGHT_VISION, 400, 0, true, true));
        if (player.isPotionActive(MobEffects.POISON)) {
            player.removePotionEffect(MobEffects.POISON);
        }
    }

    private static boolean isPotionAggressive(Potion potion) {
        return potion == MobEffects.MINING_FATIGUE || potion == MobEffects.SLOWNESS || potion == MobEffects.POISON || potion == MobEffects.WITHER || potion == MobEffects.WEAKNESS || potion == MobEffects.HUNGER;
    }

    private static void dropItemsOnHit(EntityPlayer player) {
        for (int i = -1; i < player.inventory.mainInventory.size(); ++i) {
            ItemStack stack;
            ItemStack itemStack = stack = i == -1 ? player.getHeldItemOffhand() : (ItemStack)player.inventory.mainInventory.get(i);
            if (stack.getItem() != WitcheryIngredientItems.BAT_BALL) continue;
            player.dropItem(stack, false);
            player.inventory.mainInventory.set(i, (Object)ItemStack.EMPTY);
        }
    }

    @SubscribeEvent
    public static void onServerChat(ServerChatEvent event) {
        boolean chatMasqueradeAllowed = WitcheryConfigOptions.allowChatMasquerading;
        PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)event.getPlayer());
        if (chatMasqueradeAllowed && playerEx.getCurrentForm() == WitcheryAlternateForms.PLAYER && playerEx.getOtherPlayerSkin() != null && !playerEx.getOtherPlayerSkin().isEmpty()) {
            String disguise = playerEx.getOtherPlayerSkin();
            TextComponentTranslation comp = new TextComponentTranslation("chat.type.text", new Object[]{CommonEvents.getPlayerChatName(event.getPlayer(), disguise), ForgeHooks.newChatWithLinks((String)event.getMessage())});
            event.setComponent((ITextComponent)comp);
            if (!event.getPlayer().world.isRemote) {
                for (EntityPlayer otherPlayer : event.getPlayer().world.playerEntities) {
                    if (!otherPlayer.capabilities.isCreativeMode || !event.getPlayer().getServer().getPlayerList().canSendCommands(otherPlayer.getGameProfile())) continue;
                    otherPlayer.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".chat_reveal", new Object[]{disguise, event.getPlayer().getName()}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                }
            }
        }
        if (event.getPlayer() != null && !event.isCanceled() && !event.getPlayer().world.isRemote && event.getMessage() != null) {
            WitcheryEquipmentItems.RUBY_SLIPPERS.trySayTheresNoPlaceLikeHome((EntityPlayer)event.getPlayer(), event.getMessage());
        }
    }

    private static ITextComponent getPlayerChatName(EntityPlayerMP player, String otherName) {
        TextComponentString chatcomponenttext = new TextComponentString(ScorePlayerTeam.formatPlayerName((Team)player.getTeam(), (String)otherName));
        chatcomponenttext.getStyle().setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/msg " + player.getName() + " "));
        return chatcomponenttext;
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        ExtendedDataManager.attach((arg_0, arg_1) -> event.addCapability(arg_0, arg_1), (Entity)event.getObject());
    }

    @SubscribeEvent
    public static void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        World world = event.getEntityPlayer().world;
        EntityPlayer player = event.getEntityPlayer();
        if (CreatureUtil.isWerewolf((Entity)player)) {
            if (!world.isRemote) {
                player.sendStatusMessage(new TextComponentTranslation("witchery.nosleep.wolf", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
                event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            }
        } else if (event.getEntityPlayer().isPotionActive(WitcheryPotionEffects.RESIZING) && !world.isRemote) {
            player.sendStatusMessage(new TextComponentTranslation("witchery.nosleep.resized", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public static void onSleepTimeCheck(SleepingTimeCheckEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (WitcheryUtils.getExtension(player).isTransformation(WitcheryTransformations.VAMPIRE) && player.world.getBlockState(event.getSleepingLocation()).getBlock() instanceof BlockCoffin) {
            event.setResult(player.world.isDaytime() ? Event.Result.ALLOW : Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onPlayerCloneEvent(PlayerEvent.Clone event) {
        PlayerExtendedData oldPlayerEx = WitcheryUtils.getExtension(event.getOriginal());
        NBTTagCompound oldPlayerNBT = new NBTTagCompound();
        oldPlayerEx.write(oldPlayerNBT);
        PlayerExtendedData newPlayerEx = WitcheryUtils.getExtension(event.getEntityPlayer());
        newPlayerEx.read(oldPlayerNBT);
        newPlayerEx.restorePlayerInventoryFrom(oldPlayerEx);
    }

    @SubscribeEvent
    public static void onPlayerWakeUpEvent(PlayerWakeUpEvent event) {
        int z;
        int y;
        int x;
        World world = event.getEntityPlayer().world;
        EntityPlayer player = event.getEntityPlayer();
        if (world.isDaytime() && WitcheryUtils.getExtension(player).isTransformation(WitcheryTransformations.VAMPIRE) && player.isPlayerFullyAsleep() && world.getBlockState(new BlockPos(x = MathHelper.floor((double)player.posX), y = MathHelper.floor((double)player.posY), z = MathHelper.floor((double)player.posZ))).getBlock() instanceof BlockCoffin) {
            for (EntityPlayer entityplayer : world.playerEntities) {
                if (entityplayer.isPlayerFullyAsleep()) continue;
                return;
            }
            long currentTime = world.getWorldTime() + 13000L;
            world.setWorldTime(currentTime % 24000L);
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        if (!event.isCanceled() && !event.getPlayer().world.isRemote && event.getEntityItem() != null) {
            event.getEntityItem().getItem();
            if (event.getEntityItem().getItem().getItem() == Item.getItemFromBlock((Block)WitcheryBlocks.MINDRAKE)) {
                event.getEntityItem().lifespan = 60;
                NBTTagCompound nbtItem = event.getEntityItem().getEntityData();
                nbtItem.setUniqueId("WitcheryThrower", event.getPlayer().getUniqueID());
            } else if (SmallRitual.rituals.containsKey(event.getEntityItem().getItem().getItem())) {
                event.getEntity().world.spawnEntity((Entity)new EntityRitualItem(event.getEntityItem()));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && !CommonEventHandler.livingDrops(event.getEntityLiving(), event.getSource(), event.isRecentlyHit(), event.getLootingLevel(), event.getDrops())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemExpireEvent(ItemExpireEvent event) {
        if (!event.isCanceled() && event.getEntityItem().getItem().getItem() == Item.getItemFromBlock((Block)WitcheryBlocks.MINDRAKE)) {
            for (int i = 0; i < event.getEntityItem().getItem().getCount(); ++i) {
                UUID thrower;
                EntityMindrake mindrake = new EntityMindrake(event.getEntityItem().world);
                mindrake.setLocationAndAngles(event.getEntityItem().posX, event.getEntityItem().posY, event.getEntityItem().posZ, 0.0f, 0.0f);
                NBTTagCompound nbtItem = event.getEntityItem().getEntityData();
                if (nbtItem.hasKey("WitcheryThrower") && (thrower = nbtItem.getUniqueId("WitcheryThrower")) != null) {
                    mindrake.enablePersistence();
                    mindrake.setTamed(true);
                    mindrake.setOwnerId(thrower);
                }
                mindrake.world.playSound(null, mindrake.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, mindrake.getSoundCategory(), 0.5f, 0.4f / ((float)mindrake.getRNG().nextDouble() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles((Entity)mindrake, 1.0f, 1.0f, EnumParticleTypes.EXPLOSION_NORMAL), (Entity)mindrake);
                event.getEntityItem().world.spawnEntity((Entity)mindrake);
            }
        }
    }

    public static void playerInteractEvent(PlayerInteractEvent event) {
        PotionEffect effect;
        ItemStack protectStack;
        int maxDamage;
        int repairThreshold;
        int itemDamage;
        EntityPlayer player;
        ItemStack heldItem;
        if (!event.getEntityPlayer().world.isRemote && !(heldItem = (player = event.getEntityPlayer()).getHeldItem(event.getHand())).isEmpty() && heldItem.isItemStackDamageable() && (itemDamage = heldItem.getItemDamage()) >= (repairThreshold = (int)((float)(maxDamage = heldItem.getMaxDamage()) * 0.9f)) && (protectStack = WitcheryPoppetItems.findBoundPoppetInWorld(WitcheryPoppetItems.TOOL_PROTECTION, player, 1000)) != null) {
            heldItem.setItemDamage(0);
            player.world.playSound(null, player.getPosition(), SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, player.getSoundCategory(), 0.5f, 0.4f / ((float)player.world.rand.nextDouble() * 0.4f + 0.8f));
        }
        if (!event.getEntityLiving().world.isRemote && !event.isCanceled()) {
            player = (EntityPlayer)event.getEntityLiving();
            PredictionsEventHandler.checkPredictionFulfillment(player);
            PlayerEffects.onInteract(player, event);
        }
        if (!event.getEntityPlayer().world.isRemote && (event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickBlock) && !event.getEntityPlayer().getHeldItem(event.getHand()).isEmpty() && event.getEntityPlayer().getHeldItem(event.getHand()).hasTagCompound() && event.getEntityPlayer().getHeldItem(event.getHand()).getTagCompound().hasKey("WitcheryCurse")) {
            NBTTagCompound root = event.getEntityPlayer().getHeldItem(event.getHand()).getTagCompound().getCompoundTag("WitcheryCurse");
            NBTTagCompound tag = root.getCompoundTag("Curse");
            int charges = root.getInteger("Count");
            long delay = root.getLong("Delay");
            if (delay == 0L || MinecraftServer.getCurrentTimeMillis() > delay) {
                if (charges > 0) {
                    WitcheryBrewEffects.applyToEntity(event.getEntityPlayer().world, (EntityLivingBase)event.getEntityPlayer(), tag, new ModifiersEffect(1.0, 1.0, false, event.getEntityPlayer().getPositionVector(), false, 0, EntityUtil.playerOrFake(event.getEntityPlayer().world, null)));
                    event.getEntityPlayer().world.playSound(null, event.getEntityPlayer().getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, event.getEntityPlayer().getSoundCategory(), 0.5f, 0.4f / ((float)event.getEntityPlayer().getRNG().nextDouble() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles((Entity)event.getEntityPlayer(), 1.0f, 1.0f, 0xFFFFFF), (Entity)event.getEntityPlayer());
                    --charges;
                }
                if (charges > 0) {
                    root.setInteger("Count", charges);
                    root.setLong("Delay", MinecraftServer.getCurrentTimeMillis() + 5000L);
                } else {
                    event.getEntityPlayer().getHeldItem(event.getHand()).getTagCompound().removeTag("WitcheryCurse");
                    if (event.getEntityPlayer().getHeldItem(event.getHand()).getTagCompound().isEmpty()) {
                        event.getEntityPlayer().getHeldItem(event.getHand()).setTagCompound(null);
                    }
                }
            }
        }
        if ((effect = event.getEntityPlayer().getActivePotionEffect(WitcheryPotionEffects.PARALYSED)) != null && effect.getAmplifier() >= 4) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            return;
        }
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(event.getEntityPlayer());
        VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
        if (transformation.getSelectedPower() != VampireTransformation.Power.NONE) {
            if (event.getHand() == EnumHand.MAIN_HAND) {
                if (event instanceof PlayerInteractEvent.RightClickEmpty) {
                    WitcheryNetworkChannel.sendToServer(new PacketSelectPlayerAbility(transformation, true));
                } else if (!event.getWorld().isRemote) {
                    transformation.triggerSelectedPower(null);
                }
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
        if (event.getWorld().isRemote) {
            if (event.getHand() == EnumHand.MAIN_HAND && (event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickBlock) && event.getEntityPlayer().rotationPitch == -90.0f && event.getEntityPlayer().isSneaking()) {
                WitcheryNetworkChannel.sendToServer(new PacketHowl());
            }
        } else if (event instanceof PlayerInteractEvent.LeftClickBlock && !event.getEntityPlayer().capabilities.isCreativeMode) {
            Block block;
            if (playerEx.isTransformation(WitcheryTransformations.VAMPIRE) && event.getWorld().getBlockState(event.getPos()).getBlock() == WitcheryBlocks.GARLIC_GARLAND) {
                event.getEntityPlayer().setFire(1);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            } else if (playerEx.getCurrentForm() == WitcheryAlternateForms.WOLF && playerEx.getTransformation(WitcheryTransformations.WEREWOLF).getLevel() >= 3 && event.getEntityPlayer().isSneaking()) {
                Block block2 = event.getWorld().getBlockState(event.getPos()).getBlock();
                if (block2 == Blocks.GRASS || block2 == Blocks.SAND || block2 == Blocks.DIRT || block2 == Blocks.MYCELIUM || block2 == Blocks.GRAVEL) {
                    EntityAIDigBlocks.tryHarvestBlock(event.getWorld(), event.getPos(), (EntityLivingBase)event.getEntityPlayer(), event.getEntityPlayer());
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    }
                }
            } else if (!(transformation.getLevel() < 6 || playerEx.getCurrentForm() != null || !event.getEntityPlayer().isSneaking() || !event.getEntityPlayer().getHeldItem(event.getHand()).isEmpty() && event.getEntityPlayer().getHeldItem(event.getHand()).getItem().canHarvestBlock(Blocks.STONE.getDefaultState()) || event.getEntityPlayer().getFoodStats().getFoodLevel() <= 0 || (block = event.getWorld().getBlockState(event.getPos()).getBlock()) != Blocks.STONE && block != Blocks.NETHERRACK && block != Blocks.COBBLESTONE)) {
                EntityAIDigBlocks.tryHarvestBlock(event.getWorld(), event.getPos(), (EntityLivingBase)event.getEntityPlayer(), event.getEntityPlayer());
                event.getEntityPlayer().addExhaustion(10.0f);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        CommonEvents.playerInteractEvent((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        CommonEvents.playerInteractEvent((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        CommonEvents.playerInteractEvent((PlayerInteractEvent)event);
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Block block;
        ItemStack belt;
        long counter = event.getEntityLiving().world.getTotalWorldTime();
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!event.getEntityLiving().world.isRemote) {
                int hunger;
                int prevHunger;
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                ShapeShift.INSTANCE.updatePlayerState(player, playerEx);
                for (Map.Entry<TransformationType<?>, Transformation> entry2 : playerEx.transformations.entrySet()) {
                    entry2.getValue().tick();
                }
                for (PredictionData prediction : playerEx.predictions) {
                    prediction.setTicks(prediction.getTicks() + 1);
                }
                VampireTransformation vampireTransformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
                if (vampireTransformation.getLevel() > 0 && (prevHunger = player.getFoodStats().prevFoodLevel) < (hunger = player.getFoodStats().getFoodLevel())) {
                    player.getFoodStats().addStats(-player.getFoodStats().getFoodLevel(), 0.0f);
                }
                if (event.getEntity().ticksExisted % 40 == 1) {
                    ItemStack stack;
                    int i;
                    AlternateForm.Stats stats2 = AlternateFormStatManager.INSTANCE.getStats(playerEx.getEffectiveForm());
                    Item holdableItem = stats2.getHoldableItem();
                    if (holdableItem != Items.AIR) {
                        i = 0;
                        EntityEquipmentSlot hand = EntityEquipmentSlot.MAINHAND;
                        while (hand.getSlotType() == EntityEquipmentSlot.Type.HAND) {
                            stack = player.getItemStackFromSlot(hand);
                            if (stack.getItem() != holdableItem) {
                                player.entityDropItem(stack, 1.0f);
                                player.setItemStackToSlot(hand, ItemStack.EMPTY);
                            }
                            hand = PotionIllFitting.SLOTS[++i];
                        }
                    }
                    if (!stats2.wearsArmor()) {
                        IntegrationManager.dropPlayerBackpack(player);
                        for (i = 2; i <= 5; ++i) {
                            EntityEquipmentSlot slot = PotionIllFitting.SLOTS[i];
                            stack = player.getItemStackFromSlot(slot);
                            if (stack.isEmpty() || stack.getItem() == WitcheryGeneralItems.MOON_CHARM || player.openContainer != null && player.openContainer.windowId != 0 && slot.getSlotType() == EntityEquipmentSlot.Type.HAND) continue;
                            player.entityDropItem(stack, 1.0f);
                            player.setItemStackToSlot(slot, ItemStack.EMPTY);
                        }
                    }
                    if (playerEx.isTransformation(WitcheryTransformations.WEREWOLF)) {
                        boolean isFullMoon = CreatureUtil.isFullMoon(player.world);
                        AlternateForm creatureType = playerEx.getCurrentForm();
                        if (creatureType != null && stats2.canHowl()) {
                            if (!isFullMoon && !CommonEvents.hasMoonCharm(player) && ItemMoonCharm.isWolfsbaneInactive(player, playerEx)) {
                                playerEx.setCurrentForm(null);
                                player.world.playSound(null, player.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / ((float)player.getRNG().nextDouble() * 0.4f + 0.8f));
                                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles((Entity)player, 1.5f, 1.5f, EnumParticleTypes.EXPLOSION_NORMAL), (Entity)player);
                            } else {
                                CommonEvents.updateWerewolfEffects(player);
                            }
                        } else if (creatureType == null && isFullMoon && !CommonEvents.hasMoonCharm(player) && ItemMoonCharm.isWolfsbaneInactive(player, playerEx)) {
                            playerEx.setCurrentForm(WitcheryAlternateForms.WOLF);
                            player.world.playSound(null, player.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / ((float)player.getRNG().nextDouble() * 0.4f + 0.8f));
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles((Entity)player, 1.5f, 1.5f, EnumParticleTypes.EXPLOSION_NORMAL), (Entity)player);
                            CommonEvents.updateWerewolfEffects(player);
                        }
                    }
                    if (vampireTransformation.getLevel() > 0) {
                        Village closestVillage;
                        if (player.isInWater()) {
                            player.setAir(300);
                        }
                        if (playerEx.getCurrentForm() == WitcheryAlternateForms.BAT && !vampireTransformation.decreaseBlood(VampireTransformation.Power.BAT.getUpkeepCost(), true)) {
                            playerEx.setCurrentForm(null);
                        }
                        if (vampireTransformation.getLevel() == 3 && !player.world.isDaytime()) {
                            if (vampireTransformation.getQuestCount() >= 300 || vampireTransformation.getQuestCount() >= 10 && player.capabilities.isCreativeMode) {
                                if (vampireTransformation.getCanLevelUp() && vampireTransformation.levelUp()) {
                                    playerEx.sync();
                                }
                            } else if (WitcheryConfigOptions.allowVampireQuests) {
                                vampireTransformation.setQuestCount(vampireTransformation.getQuestCount() + 1);
                            }
                        }
                        if (vampireTransformation.getLevel() == 7 && vampireTransformation.getCanLevelUp() && (closestVillage = player.world.villageCollection.getNearestVillage(player.getPosition(), 32)) != null && vampireTransformation.getVisitedChunks().add(new ChunkPos(closestVillage.getCenter()))) {
                            if (vampireTransformation.getQuestCount() >= 3) {
                                if (vampireTransformation.levelUp()) {
                                    playerEx.sync();
                                }
                            } else {
                                vampireTransformation.setQuestCount(vampireTransformation.getQuestCount() + 1);
                                player.world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_PLING, player.getSoundCategory(), 1.0f, 1.0f);
                            }
                        }
                        if (vampireTransformation.getLevel() >= 2 && vampireTransformation.getNightVision()) {
                            player.addPotionEffect(new PotionEffect(MobEffects.NIGHT_VISION, 400, 0, true, true));
                        }
                        if (player.isPotionActive(MobEffects.POISON)) {
                            player.removePotionEffect(MobEffects.POISON);
                        }
                        if (player.isBurning() && player.isPotionActive(MobEffects.FIRE_RESISTANCE)) {
                            player.attackEntityFrom((DamageSource)EntityUtil.DamageSourceVampireFire.SOURCE, 2.0f);
                        }
                        while (player.getFoodStats().getFoodLevel() < 20 && vampireTransformation.decreaseBlood(5, true)) {
                            playerEx.sync();
                            player.getFoodStats().addStats(1, 4.0f);
                        }
                        if (vampireTransformation.getBloodPower() == 0 && player.getFoodStats().getFoodLevel() == 0) {
                            player.addPotionEffect(new PotionEffect(MobEffects.WEAKNESS, 200, 8, true, true));
                            player.addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 200, 1, true, true));
                            player.addPotionEffect(new PotionEffect(MobEffects.MINING_FATIGUE, 200, 1, true, true));
                        }
                        if (CreatureUtil.isInSunlight((EntityLivingBase)player) && !player.capabilities.isCreativeMode) {
                            if (vampireTransformation.getBloodPower() == 0 && player.ticksExisted > 400) {
                                EntityUtil.sunDeath(player);
                            }
                            if (vampireTransformation.getLevel() >= 5) {
                                vampireTransformation.decreaseBlood(60, false);
                                playerEx.sync();
                                player.addPotionEffect(new PotionEffect(MobEffects.WEAKNESS, 200, 3, false, true));
                                player.addPotionEffect(new PotionEffect(MobEffects.SLOWNESS, 200, 0, true, true));
                                player.addPotionEffect(new PotionEffect(MobEffects.MINING_FATIGUE, 200, 0, true, true));
                            } else {
                                vampireTransformation.setBloodPower(0);
                                playerEx.sync();
                            }
                            if (vampireTransformation.getBloodPower() == 0) {
                                player.setFire(5);
                            }
                        }
                    } else {
                        playerEx.giveHumanBlood(2);
                    }
                }
                if (counter % 4L == 0L) {
                    CommonEvents.handleBrewGrotesqueEffect(playerEx);
                    WorldProviderSpiritWorld.updatePlayerEffects(player.world, player, counter);
                    WorldProviderTorment.updatePlayerEffects(player.world, player, counter);
                    if (counter % 20L == 0L) {
                        CommonEvents.handleSyncEffects(player, player.getEntityData());
                        CommonEvents.handleBrewDepthsEffect(player);
                        CommonEvents.handleCurseEffects((EntityLivingBase)player);
                        CommonEvents.handleSeepingShoesEffect(player);
                        InfusedBrewEffect.checkActiveEffects(player.world, player, player.getEntityData(), counter % 1200L == 0L);
                    }
                    if (counter % 100L == 0L && !event.isCanceled()) {
                        BlockPos coords;
                        PredictionsEventHandler.checkPredictionFulfillment(player);
                        if (WitcheryConfigOptions.allowCovenWitchVisits && !playerEx.coven.isEmpty() && player.world.rand.nextInt(20) == 0 && (coords = player.getBedLocation(player.dimension)) != null && coords.distanceSq((double)((int)player.posX), (double)((int)player.posY), (double)((int)player.posZ)) < 256.0) {
                            EntityCovenWitch.summonCovenMember(player.world, player, 90);
                        }
                    }
                }
                PlayerEffects.onUpdate(player);
                if (counter % 100L == 1L) {
                    EntityWitchHunter.handleWitchHunterEffects(player);
                }
            }
            CommonEvents.handleIcySlippersEffect(player);
        } else if (!event.getEntityLiving().world.isRemote && counter % 20L == 0L) {
            CommonEvents.handleCurseEffects(event.getEntityLiving());
        }
        if (counter % 100L == 0L && (belt = event.getEntityLiving().getItemStackFromSlot(EntityEquipmentSlot.LEGS)).getItem() == WitcheryEquipmentItems.BARK_BELT && ((block = event.getEntityLiving().world.getBlockState(event.getEntityLiving().getPosition().down()).getBlock()) == Blocks.GRASS || block == Blocks.MYCELIUM)) {
            int maxChargeLevel = ItemWitchesClothes.getMaxChargeLevel(event.getEntityLiving());
            int currentChargeLevel = ItemWitchesClothes.getChargeLevel(belt);
            if (currentChargeLevel < maxChargeLevel) {
                ItemWitchesClothes.setChargeLevel(belt, Math.min(currentChargeLevel + 1, maxChargeLevel));
                event.getEntityLiving().world.playSound(null, event.getEntityLiving().getPosition(), WitcherySounds.ITEM_BARKBELT_WOOD_CREAK, SoundCategory.VOICE, 0.5f, (float)(0.8 + 2.0 * event.getEntityLiving().world.rand.nextGaussian()));
            }
        }
        for (IHandleLivingUpdate handler : WitcheryPotionEffects.LIVING_UPDATES) {
            if (event.isCanceled()) break;
            if (!event.getEntityLiving().isPotionActive((Potion)handler.getPotion())) continue;
            PotionEffect effect = event.getEntityLiving().getActivePotionEffect((Potion)handler.getPotion());
            handler.onLivingUpdate(event.getEntityLiving().world, event.getEntityLiving(), event, effect.getAmplifier(), effect.getDuration());
        }
    }

    private static boolean hasMoonCharm(EntityPlayer player) {
        if (player.getHeldItem(EnumHand.OFF_HAND).getItem() == WitcheryGeneralItems.MOON_CHARM || player.getHeldItem(EnumHand.MAIN_HAND).getItem() == WitcheryGeneralItems.MOON_CHARM) {
            return true;
        }
        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
            if (player.inventory.getStackInSlot(i).getItem() != WitcheryGeneralItems.MOON_CHARM) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        CommonEvents.playerInteractEvent((PlayerInteractEvent)event);
    }

    private static void handleSyncEffects(EntityPlayer player, NBTTagCompound nbtPlayer) {
        long nextSync;
        if (!player.world.isRemote && nbtPlayer.hasKey("WitcheryResyncLook") && (nextSync = nbtPlayer.getLong("WitcheryResyncLook")) <= player.world.getTotalWorldTime()) {
            nbtPlayer.removeTag("WitcheryResyncLook");
            WitcheryNetworkChannel.sendToDimension(new PacketPlayerStyle(player), player.dimension);
        }
    }

    private static void handleBrewGrotesqueEffect(PlayerExtendedData playerEx) {
        EntityPlayer player = (EntityPlayer)playerEx.entity;
        if (playerEx.grotesqueTicks > 0) {
            float radius = 4.0f;
            AxisAlignedBB bounds = new AxisAlignedBB(player.posX - (double)radius, player.posY - (double)radius, player.posZ - (double)radius, player.posX + (double)radius, player.posY + (double)radius, player.posZ + (double)radius);
            List list2 = player.world.getEntitiesWithinAABB(EntityLiving.class, bounds);
            for (EntityLiving entity : list2) {
                if (entity instanceof EntityDemon || !entity.isNonBoss() || entity instanceof EntityGolem || entity instanceof EntityWitch) continue;
                RiteEffectProtectionCircleRepulsive.push((Entity)entity, player.getPosition());
            }
            if (--playerEx.grotesqueTicks == 0) {
                WitcheryNetworkChannel.sendToDimension(new PacketPlayerStyle(player), player.dimension);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && (player = (EntityPlayer)event.getEntityLiving()).isRiding() && player.getRidingEntity() instanceof EntityBroom) {
            event.setDistance(0.0f);
        }
        if (!event.getEntity().world.isRemote && event.getEntity() instanceof EntityPlayer) {
            event.setDistance(ShapeShift.INSTANCE.updateFallState((EntityPlayer)event.getEntity(), event.getDistance()));
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntityLiving();
            Infusion.getInfusion(player).onFalling(player.world, player, event);
        }
    }

    @SubscribeEvent
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (!event.getWorld().isRemote && !event.isCanceled()) {
            if (WitcheryBlocks.LOOT_TABLES.containsKey(event.getState().getBlock())) {
                MatchToolCondition.init();
                BlockStatePropertyCondition.init();
                SurvivesExplosionCondition.init();
                ExplosionDecayFunction.init();
                LootTable table = event.getWorld().getLootTableManager().getLootTableFromLocation(WitcheryBlocks.LOOT_TABLES.get(event.getState().getBlock()));
                if (table != LootTable.EMPTY_LOOT_TABLE) {
                    EntityPlayer player = event.getHarvester();
                    if (player == null) {
                        player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)event.getWorld()));
                    }
                    if (Math.abs(event.getDropChance()) != 1.0f) {
                        player.getEntityData().setFloat("LastExplosionSize", 1.0f / event.getDropChance());
                    }
                    player.getEntityData().setTag("LastMinedState", (NBTBase)NBTUtil.writeBlockState((NBTTagCompound)new NBTTagCompound(), (IBlockState)event.getState()));
                    LootContext.Builder builder = new LootContext.Builder((WorldServer)event.getWorld()).withPlayer(player);
                    event.getDrops().clear();
                    for (ItemStack item : table.generateLootForPools(event.getWorld().rand, builder.build())) {
                        event.getDrops().add(item);
                    }
                    event.setDropChance(1.0f);
                    player.getEntityData().removeTag("LastExplosionSize");
                    player.getEntityData().removeTag("LastMinedState");
                }
            }
            if (event.getHarvester() != null) {
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(event.getHarvester());
                ShapeShift.INSTANCE.processDigging(event, event.getHarvester(), playerEx);
            }
        }
        if (event.getHarvester() != null && !event.getHarvester().world.isRemote) {
            PredictionsEventHandler.harvestDrops(event.getHarvester(), event.getPos(), event.getState(), event.getDrops());
            PlayerEffects.onHarvestDrops(event.getHarvester(), event);
            EntityAIDigBlocks.onHarvestDrops(event.getHarvester(), event);
        }
        if (!event.getWorld().isRemote && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(event.getWorld()) && !event.isCanceled()) {
            event.getDrops().removeIf(CommonEvents::isBannedSpiritObject);
        }
    }

    @SubscribeEvent
    public static void getItemBurnTime(FurnaceFuelBurnTimeEvent event) {
        Block block = Block.getBlockFromItem((Item)event.getItemStack().getItem());
        if (block instanceof WitcheryBlockSapling) {
            event.setBurnTime(100);
        } else if (block instanceof WitcheryBlockPlanks || block instanceof WitcheryBlockLog) {
            event.setBurnTime(300);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("witchery")) {
            WitcheryConfig.init();
        }
    }

    private static boolean isBannedSpiritObject(ItemStack stack) {
        if (!stack.isEmpty()) {
            Item item = stack.getItem();
            return item == Items.ENDER_PEARL || item == Items.BLAZE_POWDER;
        }
        return false;
    }

    private static void handleSeepingShoesEffect(EntityPlayer player) {
        if (!player.onGround) {
            return;
        }
        if (!player.isPotionActive(MobEffects.POISON) && !player.isPotionActive(MobEffects.WITHER)) {
            return;
        }
        ItemStack shoes = player.getItemStackFromSlot(EntityEquipmentSlot.FEET);
        if (shoes.getItem() != WitcheryEquipmentItems.SEEPING_SHOES) {
            return;
        }
        boolean poisonRemoved = false;
        if (player.isPotionActive(MobEffects.POISON)) {
            player.removePotionEffect(MobEffects.POISON);
            poisonRemoved = true;
        }
        if (player.isPotionActive(MobEffects.WITHER)) {
            player.removePotionEffect(MobEffects.WITHER);
            poisonRemoved = true;
        }
        if (poisonRemoved) {
            BlockPos p = player.getPosition();
            for (BlockPos pos : BlockPos.getAllInBox((BlockPos)p.add(-3, -1, -3), (BlockPos)p.add(3, 1, 3))) {
                if (!(pos.distanceSq((double)p.getX(), (double)pos.getY(), (double)pos.getZ()) <= 9.0) || !player.world.isAirBlock(pos.up()) || player.world.isAirBlock(pos)) continue;
                ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.DYE, 1, EnumDyeColor.WHITE.getDyeDamage()), (World)player.world, (BlockPos)pos, (EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityPlayer player;
        if (event.getTarget() != null && event.getEntityLiving() instanceof EntityLiving) {
            EntityLiving aggressorEntity = (EntityLiving)event.getEntityLiving();
            if (event.getTarget() instanceof EntityPlayer) {
                ItemStack stack;
                player = (EntityPlayer)event.getTarget();
                if (player.isInvisible()) {
                    if (aggressorEntity.world.getClosestPlayerToEntity((Entity)aggressorEntity, 16.0) != event.getTarget()) {
                        aggressorEntity.setAttackTarget(null);
                    }
                } else if (aggressorEntity.isPotionActive(MobEffects.BLINDNESS)) {
                    aggressorEntity.setAttackTarget(null);
                } else if (aggressorEntity instanceof EntityCreeper) {
                    stack = player.getItemStackFromSlot(EntityEquipmentSlot.CHEST);
                    if (!stack.isEmpty() && stack.getItem() == WitcheryEquipmentItems.WITCH_ROBES) {
                        aggressorEntity.setAttackTarget(null);
                    }
                } else if (aggressorEntity.isEntityUndead()) {
                    if (aggressorEntity instanceof EntityZombie && WitcheryUtils.getExtension(player).getTransformation(WitcheryTransformations.VAMPIRE).getLevel() >= 10) {
                        aggressorEntity.setAttackTarget(null);
                    } else {
                        stack = player.getItemStackFromSlot(EntityEquipmentSlot.CHEST);
                        if (!stack.isEmpty() && stack.getItem() == WitcheryEquipmentItems.NECROMANCERS_ROBES) {
                            aggressorEntity.setAttackTarget(null);
                        }
                    }
                }
            }
            if (event.getTarget() instanceof EntityVillageGuard && event.getEntityLiving() instanceof EntityGolem) {
                aggressorEntity.setAttackTarget(null);
            } else if (WitcheryConfigOptions.isZombieIgnoreVillagerActive() && event.getTarget() instanceof EntityVillager && event.getEntityLiving() instanceof EntityZombie) {
                aggressorEntity.setAttackTarget(null);
            }
        }
        if (event.getEntityLiving() instanceof EntityLiving) {
            EntityLiving livingEntity = (EntityLiving)event.getEntityLiving();
            if (livingEntity != null && event.getTarget() != null && event.getTarget() instanceof EntityPlayer) {
                player = (EntityPlayer)event.getTarget();
                if (!livingEntity.isPotionActive(WitcheryPotionEffects.ENSLAVED) && PotionEnslaved.isMobEnslavedBy(livingEntity, player)) {
                    livingEntity.setAttackTarget(null);
                }
            }
            for (IHandleLivingSetAttackTarget handler : WitcheryPotionEffects.LIVING_SET_ATTACK_TARGETS) {
                if (event.isCanceled()) break;
                if (!event.getEntityLiving().isPotionActive((Potion)handler.getPotion())) continue;
                handler.onLivingSetAttackTarget(livingEntity, event);
            }
        }
    }

    private static void handleIcySlippersEffect(EntityPlayer player) {
        ItemStack shoes = (ItemStack)player.inventory.armorInventory.get(0);
        if (shoes.getItem() == WitcheryEquipmentItems.ICY_SLIPPERS) {
            int k = MathHelper.floor((double)(player.posY - 1.0));
            for (int i = 0; i < 4; ++i) {
                int l;
                int j = MathHelper.floor((double)(player.posX + (double)((float)(i % 2 * 2 - 1) * 0.5f)));
                BlockPos pos = new BlockPos(j, k, l = MathHelper.floor((double)(player.posZ + (double)(((float)i / 2.0f % 2.0f * 2.0f - 1.0f) * 0.5f))));
                Block blockID = player.world.getBlockState(pos).getBlock();
                if (blockID == Blocks.FLOWING_WATER || blockID == Blocks.WATER) {
                    player.world.setBlockState(pos, Blocks.ICE.getDefaultState());
                    continue;
                }
                if (blockID != Blocks.FLOWING_LAVA && blockID != Blocks.LAVA) continue;
                player.world.setBlockState(pos, Blocks.OBSIDIAN.getDefaultState());
                if (player.world.rand.nextInt(10) != 0) continue;
                shoes.damageItem(1, (EntityLivingBase)player);
            }
        }
    }

    private static void handleBrewDepthsEffect(EntityPlayer player) {
        LivingExtendedData livingEx = WitcheryDataExtensions.LIVING.get((EntityLivingBase)player);
        if (livingEx.getDepthsTicks() > 0) {
            if (!player.isPotionActive(MobEffects.WATER_BREATHING)) {
                player.addPotionEffect(new PotionEffect(MobEffects.WATER_BREATHING, 6000));
            }
            if (!player.isInsideOfMaterial(Material.WATER)) {
                if (!player.isPotionActive(MobEffects.WITHER)) {
                    player.addPotionEffect(new PotionEffect(MobEffects.WITHER, 100, 1));
                }
            } else if (player.isPotionActive(MobEffects.WITHER)) {
                player.removePotionEffect(MobEffects.WITHER);
            }
            livingEx.setDepthsTicks(livingEx.getDepthsTicks() - 1);
            if (livingEx.getDepthsTicks() == 0) {
                if (player.isPotionActive(MobEffects.WATER_BREATHING)) {
                    player.removePotionEffect(MobEffects.WATER_BREATHING);
                }
                if (player.isPotionActive(MobEffects.POISON)) {
                    player.removePotionEffect(MobEffects.POISON);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        for (IHandleLivingJump handler : WitcheryPotionEffects.LIVING_JUMPS) {
            if (event.isCanceled()) break;
            if (!event.getEntityLiving().isPotionActive((Potion)handler.getPotion())) continue;
            PotionEffect effect = event.getEntityLiving().getActivePotionEffect((Potion)handler.getPotion());
            handler.onLivingJump(event, effect.getAmplifier());
        }
    }

    private static void handleCurseEffects(EntityLivingBase entity) {
        for (Object2IntMap.Entry curseEntry : WitcheryDataExtensions.LIVING.get(entity).getCurses().object2IntEntrySet()) {
            ((Curse)curseEntry.getKey()).affectEntity(curseEntry.getIntValue(), entity);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer player = event.player;
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        World world = event.player.world;
        ShapeShift.INSTANCE.initCurrentShift(player);
        Infusion.syncPlayer(world, player);
        playerEx.scheduleSync();
        WitcheryNetworkChannel.sendToDimension(new PacketPlayerStyle(player), world.provider.getDimension());
        if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && playerEx.getSpiritData().isSpiritWalking() && !playerEx.getSpiritData().isGhost()) {
            playerEx.getSpiritData().setMustWakeUp(true);
        } else if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && !playerEx.getSpiritData().isSpiritWalking()) {
            WorldProviderSpiritWorld.changeDimension(player, DimensionType.OVERWORLD);
            WorldProviderSpiritWorld.findTopAndSetPosition(player.world, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.world.isRemote) {
            EntityPlayer player = event.player;
            World world = event.player.world;
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            for (PotionEffect permanentEffect : playerEx.permanentEffects) {
                if (player.isPotionActive(permanentEffect.getPotion())) continue;
                player.addPotionEffect(permanentEffect);
            }
            playerEx.permanentEffects.clear();
            ShapeShift.INSTANCE.initCurrentShift(player);
            Infusion.syncPlayer(world, player);
            playerEx.scheduleSync();
            WitcheryNetworkChannel.sendToDimension(new PacketPlayerStyle(player), world.provider.getDimension());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.START) {
            OverworldInfusion.Shockwave.SHOCKWAVES.removeIf(shockwave -> shockwave.process(event.world));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && !event.player.world.isRemote) {
            if (event.phase == TickEvent.Phase.START) {
                Collection activeEffects = event.player.getActivePotionEffects();
                PlayerExtendedData playerExt = WitcheryUtils.getExtension(event.player);
                playerExt.updateWorship();
                if (activeEffects.size() > 0) {
                    playerExt.cacheIncurablePotionEffect(activeEffects);
                }
            } else if (event.phase == TickEvent.Phase.END) {
                PlayerExtendedData playerExt2 = WitcheryUtils.getExtension(event.player);
                playerExt2.restoreIncurablePotionEffects();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        long nextUpdate = event.player.world.getTotalWorldTime() + 300L;
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        playerEx.scheduleSync();
        for (EntityPlayer otherPlayer : player.world.playerEntities) {
            NBTTagCompound nbtOtherPlayer = otherPlayer.getEntityData();
            if (otherPlayer == player) continue;
            nbtOtherPlayer.setLong("WitcheryResyncLook", nextUpdate);
        }
        WitcheryNetworkChannel.sendToDimension(new PacketPlayerStyle(player), player.world.provider.getDimension());
        if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && playerEx.getSpiritData().isSpiritWalking() && !playerEx.getSpiritData().isGhost()) {
            playerEx.getSpiritData().setMustWakeUp(true);
        }
        if (!WitcheryResurrected.Companion.isInCompatibilityMode()) {
            WitcheryNetworkChannel.sendTo(new PacketUpdateRecipes(WitcheryUtils.getRecipeManager(player.world).getRecipes()), (EntityPlayerMP)player);
        }
        WitcheryNetworkChannel.sendTo(new PacketUpdateAlternateFormStats(AlternateFormStatManager.INSTANCE.getStats()), (EntityPlayerMP)player);
        WitcheryNetworkChannel.sendTo(new PacketUpdateSymbolEffects(SymbolEffectManager.INSTANCE.getEffects()), (EntityPlayerMP)player);
        WitcheryNetworkChannel.sendTo(new PacketUpdateRites(RiteManager.INSTANCE.getByGroup()), (EntityPlayerMP)player);
        WitcheryNetworkChannel.sendTo(new PacketUpdateBrewActions(BrewActionManager.INSTANCE.getActions()), (EntityPlayerMP)player);
        WitcheryNetworkChannel.sendTo(new PacketUpdateCreaturePowers(CreaturePowerManager.INSTANCE.getCreaturePowers()), (EntityPlayerMP)player);
        WitcheryNetworkChannel.sendTo(new PacketUpdateSpiritEffects(SpiritEffectManager.INSTANCE.getEffects()), (EntityPlayerMP)player);
    }

    @SubscribeEvent
    public static void onGetVillageBlock(BiomeEvent.GetVillageBlockID event) {
        Biome biome = event.getBiome();
        if (biome == null) {
            return;
        }
        IBlockState state = event.getOriginal();
        Block block = state.getBlock();
        Set types = BiomeDictionary.getTypes((Biome)biome);
        int structureType = -1;
        if (types.contains(BiomeDictionary.Type.SNOWY)) {
            structureType = 5;
        } else if (types.contains(BiomeDictionary.Type.MESA)) {
            structureType = 4;
        } else if (biome instanceof BiomeDesert || types.contains(BiomeDictionary.Type.SANDY)) {
            structureType = 1;
        } else if (biome instanceof BiomeSavanna || types.contains(BiomeDictionary.Type.SAVANNA)) {
            structureType = 2;
        } else if (biome instanceof BiomeTaiga) {
            structureType = 3;
        }
        switch (structureType) {
            case 1: {
                if (block == Blocks.LOG || block == Blocks.LOG2) {
                    event.setReplacement(Blocks.SANDSTONE.getDefaultState().withProperty((IProperty)BlockSandStone.TYPE, (Comparable)BlockSandStone.EnumType.SMOOTH));
                    break;
                }
                if (block == Blocks.COBBLESTONE) {
                    event.setReplacement(Blocks.SANDSTONE.getDefaultState());
                    break;
                }
                if (block == Blocks.PLANKS) {
                    event.setReplacement(Blocks.PLANKS.getDefaultState().withProperty((IProperty)BlockPlanks.VARIANT, (Comparable)BlockPlanks.EnumType.BIRCH));
                    break;
                }
                if (block == Blocks.OAK_STAIRS) {
                    event.setReplacement(Blocks.BIRCH_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, state.getValue((IProperty)BlockStairs.FACING)).withProperty((IProperty)BlockStairs.HALF, state.getValue((IProperty)BlockStairs.HALF)).withProperty((IProperty)BlockStairs.SHAPE, state.getValue((IProperty)BlockStairs.SHAPE)));
                    break;
                }
                if (block == Blocks.STONE_STAIRS) {
                    event.setReplacement(Blocks.SANDSTONE_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, state.getValue((IProperty)BlockStairs.FACING)).withProperty((IProperty)BlockStairs.HALF, state.getValue((IProperty)BlockStairs.HALF)).withProperty((IProperty)BlockStairs.SHAPE, state.getValue((IProperty)BlockStairs.SHAPE)));
                    break;
                }
                if (block == Blocks.GRAVEL) {
                    event.setReplacement(Blocks.SANDSTONE.getDefaultState());
                    break;
                }
                if (block == Blocks.STONEBRICK) {
                    event.setReplacement(Blocks.SANDSTONE.getDefaultState().withProperty((IProperty)BlockSandStone.TYPE, (Comparable)BlockSandStone.EnumType.SMOOTH));
                    break;
                }
                if (block == Blocks.WOODEN_SLAB) {
                    event.setReplacement(state.withProperty((IProperty)BlockWoodSlab.VARIANT, (Comparable)BlockPlanks.EnumType.BIRCH));
                    break;
                }
                if (block == Blocks.STONE_BRICK_STAIRS) {
                    event.setReplacement(Blocks.SANDSTONE_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, state.getValue((IProperty)BlockStairs.FACING)).withProperty((IProperty)BlockStairs.HALF, state.getValue((IProperty)BlockStairs.HALF)).withProperty((IProperty)BlockStairs.SHAPE, state.getValue((IProperty)BlockStairs.SHAPE)));
                    break;
                }
                if (block != Blocks.STONE_SLAB || state.getValue((IProperty)BlockStoneSlab.VARIANT) != BlockStoneSlab.EnumType.STONE && state.getValue((IProperty)BlockStoneSlab.VARIANT) != BlockStoneSlab.EnumType.COBBLESTONE) break;
                event.setReplacement(state.withProperty((IProperty)BlockStoneSlab.VARIANT, (Comparable)BlockStoneSlab.EnumType.SAND));
                break;
            }
            case 2: {
                if (block != Blocks.OAK_FENCE) break;
                event.setReplacement(Blocks.ACACIA_FENCE.getDefaultState().withProperty((IProperty)BlockFence.NORTH, state.getValue((IProperty)BlockFence.NORTH)).withProperty((IProperty)BlockFence.EAST, state.getValue((IProperty)BlockFence.EAST)).withProperty((IProperty)BlockFence.SOUTH, state.getValue((IProperty)BlockFence.SOUTH)).withProperty((IProperty)BlockFence.WEST, state.getValue((IProperty)BlockFence.WEST)));
                break;
            }
            case 3: {
                if (block == Blocks.STONEBRICK) {
                    event.setReplacement(Blocks.COBBLESTONE.getDefaultState());
                    break;
                }
                if (block != Blocks.OAK_FENCE) break;
                event.setReplacement(Blocks.SPRUCE_FENCE.getDefaultState().withProperty((IProperty)BlockFence.NORTH, state.getValue((IProperty)BlockFence.NORTH)).withProperty((IProperty)BlockFence.EAST, state.getValue((IProperty)BlockFence.EAST)).withProperty((IProperty)BlockFence.SOUTH, state.getValue((IProperty)BlockFence.SOUTH)).withProperty((IProperty)BlockFence.WEST, state.getValue((IProperty)BlockFence.WEST)));
                break;
            }
            case 4: {
                if (block == Blocks.LOG || block == Blocks.LOG2) {
                    event.setReplacement(Blocks.RED_SANDSTONE.getDefaultState().withProperty((IProperty)BlockRedSandstone.TYPE, (Comparable)BlockRedSandstone.EnumType.SMOOTH));
                    break;
                }
                if (block == Blocks.COBBLESTONE) {
                    event.setReplacement(Blocks.RED_SANDSTONE.getDefaultState());
                    break;
                }
                if (block == Blocks.PLANKS) {
                    event.setReplacement(Blocks.PLANKS.getDefaultState().withProperty((IProperty)BlockPlanks.VARIANT, (Comparable)BlockPlanks.EnumType.ACACIA));
                    break;
                }
                if (block == Blocks.OAK_STAIRS) {
                    event.setReplacement(Blocks.ACACIA_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, state.getValue((IProperty)BlockStairs.FACING)).withProperty((IProperty)BlockStairs.HALF, state.getValue((IProperty)BlockStairs.HALF)).withProperty((IProperty)BlockStairs.SHAPE, state.getValue((IProperty)BlockStairs.SHAPE)));
                    break;
                }
                if (block == Blocks.STONE_STAIRS) {
                    event.setReplacement(Blocks.RED_SANDSTONE_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, state.getValue((IProperty)BlockStairs.FACING)).withProperty((IProperty)BlockStairs.HALF, state.getValue((IProperty)BlockStairs.HALF)).withProperty((IProperty)BlockStairs.SHAPE, state.getValue((IProperty)BlockStairs.SHAPE)));
                    break;
                }
                if (block == Blocks.GRAVEL) {
                    event.setReplacement(Blocks.RED_SANDSTONE.getDefaultState());
                    break;
                }
                if (block == Blocks.STONEBRICK) {
                    event.setReplacement(Blocks.RED_SANDSTONE.getDefaultState().withProperty((IProperty)BlockRedSandstone.TYPE, (Comparable)BlockRedSandstone.EnumType.SMOOTH));
                    break;
                }
                if (block == Blocks.WOODEN_SLAB) {
                    event.setReplacement(Blocks.WOODEN_SLAB.getDefaultState().withProperty((IProperty)BlockWoodSlab.VARIANT, (Comparable)BlockPlanks.EnumType.ACACIA));
                    break;
                }
                if (block == Blocks.STONE_BRICK_STAIRS) {
                    event.setReplacement(Blocks.RED_SANDSTONE_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, state.getValue((IProperty)BlockStairs.FACING)).withProperty((IProperty)BlockStairs.HALF, state.getValue((IProperty)BlockStairs.HALF)).withProperty((IProperty)BlockStairs.SHAPE, state.getValue((IProperty)BlockStairs.SHAPE)));
                    break;
                }
                if (block != Blocks.STONE_SLAB || state.getValue((IProperty)BlockStoneSlab.VARIANT) != BlockStoneSlab.EnumType.STONE && state.getValue((IProperty)BlockStoneSlab.VARIANT) != BlockStoneSlab.EnumType.COBBLESTONE) break;
                event.setReplacement(Blocks.STONE_SLAB2.getDefaultState().withProperty((IProperty)BlockSlab.HALF, state.getValue((IProperty)BlockSlab.HALF)));
                break;
            }
            case 5: {
                if (block == Blocks.LOG || block == Blocks.LOG2) {
                    event.setReplacement(Blocks.PACKED_ICE.getDefaultState());
                    break;
                }
                if (block == Blocks.COBBLESTONE || block == Blocks.PLANKS || block == Blocks.STONEBRICK || block == Blocks.DIRT) {
                    event.setReplacement(Blocks.SNOW.getDefaultState());
                    break;
                }
                if (block == Blocks.OAK_STAIRS || block == Blocks.STONE_STAIRS || block == Blocks.STONE_BRICK_STAIRS) {
                    event.setReplacement(WitcheryBlocks.SNOW_STAIRS.getDefaultState().withProperty((IProperty)BlockStairs.FACING, state.getValue((IProperty)BlockStairs.FACING)).withProperty((IProperty)BlockStairs.HALF, state.getValue((IProperty)BlockStairs.HALF)).withProperty((IProperty)BlockStairs.SHAPE, state.getValue((IProperty)BlockStairs.SHAPE)));
                    break;
                }
                if (block == Blocks.GRAVEL) {
                    event.setReplacement(Blocks.PACKED_ICE.getDefaultState());
                    break;
                }
                if (block == Blocks.STONE_SLAB || block == Blocks.WOODEN_SLAB) {
                    event.setReplacement(WitcheryBlocks.SNOW_SLAB.getDefaultState().withProperty((IProperty)BlockSlab.HALF, state.getValue((IProperty)BlockSlab.HALF)));
                    break;
                }
                if (block instanceof BlockFence) {
                    event.setReplacement(WitcheryBlocks.PERPETUAL_ICE_FENCE.getDefaultState().withProperty((IProperty)BlockFence.NORTH, state.getValue((IProperty)BlockFence.NORTH)).withProperty((IProperty)BlockFence.EAST, state.getValue((IProperty)BlockFence.EAST)).withProperty((IProperty)BlockFence.SOUTH, state.getValue((IProperty)BlockFence.SOUTH)).withProperty((IProperty)BlockFence.WEST, state.getValue((IProperty)BlockFence.WEST)));
                    break;
                }
                if (block != Blocks.WOODEN_PRESSURE_PLATE) break;
                event.setReplacement(WitcheryBlocks.SNOW_PRESSURE_PLATE.getDefaultState().withProperty((IProperty)WitcheryBlockPressurePlate.POWERED, state.getValue((IProperty)BlockPressurePlate.POWERED)));
            }
        }
        if (event.getReplacement() != null) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onArrowLoose(ArrowLooseEvent event) {
        if (!event.isCanceled() && ItemGoblinClothes.isQuiverWorn(event.getEntityPlayer())) {
            int l;
            int k;
            float f = (float)event.getCharge() / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityPlayer player = event.getEntityPlayer();
            EntityArrow entityarrow = ((ItemArrow)Items.ARROW).createArrow(player.world, new ItemStack(Items.ARROW), (EntityLivingBase)player);
            entityarrow.shoot((Entity)player, player.rotationPitch, player.rotationYaw, 0.0f, f * 3.0f, 1.0f);
            entityarrow.getEntityData().setBoolean("WitcheryMogged", true);
            if (f == 1.0f) {
                entityarrow.setIsCritical(true);
            }
            if ((k = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.POWER, (ItemStack)event.getBow())) > 0) {
                entityarrow.setDamage(entityarrow.getDamage() + (double)k * 0.5 + 0.5);
            }
            if ((l = EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.PUNCH, (ItemStack)event.getBow())) > 0) {
                entityarrow.setKnockbackStrength(l);
            }
            if (EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.FLAME, (ItemStack)event.getBow()) > 0) {
                entityarrow.setFire(100);
            }
            event.getBow().damageItem(1, (EntityLivingBase)event.getEntityPlayer());
            event.getEntityPlayer().world.playSound(null, event.getEntityPlayer().getPosition(), SoundEvents.ENTITY_ARROW_SHOOT, event.getEntityPlayer().getSoundCategory(), 1.0f, 1.0f / (event.getWorld().rand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            entityarrow.pickupStatus = EntityArrow.PickupStatus.CREATIVE_ONLY;
            if (!event.getEntityPlayer().world.isRemote) {
                event.getEntityPlayer().world.spawnEntity((Entity)entityarrow);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onArrowNock(ArrowNockEvent event) {
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(event.getEntityPlayer());
        if (playerEx.getCurrentForm() != null) {
            event.setAction(ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)event.getBow()));
            return;
        }
        if (event.getAction() == null && ItemGoblinClothes.isQuiverWorn(event.getEntityPlayer())) {
            event.getEntityPlayer().setActiveHand(event.getHand());
        }
    }

    public static void removePriorUserTag(ItemStack stack) {
        NBTTagCompound nbtItem;
        if (!stack.isEmpty() && (nbtItem = stack.getTagCompound()) != null && nbtItem.hasKey("WitcheryPriIncUsr")) {
            nbtItem.removeTag("WitcheryPriIncUsr");
            if (nbtItem.isEmpty()) {
                stack.setTagCompound(null);
            }
        }
    }

    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        ItemStack stack;
        NBTTagCompound nbtItem;
        if (event.getEntityItem() != null && !event.getEntityItem().world.isRemote && RiteEffectPriorIncarnation.isRitualAllowed() && !event.isCanceled() && (nbtItem = (stack = event.getEntityItem().getItem()).getTagCompound()) != null && nbtItem.hasUniqueId("WitcheryPriIncUsr")) {
            UUID username = nbtItem.getUniqueId("WitcheryPriIncUsr");
            MinecraftServer server = event.getEntityItem().getServer();
            for (WorldServer world : server.worlds) {
                EntityPlayer player = WitcheryUtils.getPlayer((World)world, username);
                if (player == null) continue;
                NBTTagCompound nbt = player.getEntityData();
                if (!nbt.hasKey("WitcheryPriIncInv")) {
                    NBTTagList tagList = new NBTTagList();
                    nbt.setTag("WitcheryPriIncInv", (NBTBase)tagList);
                }
                NBTTagList list2 = nbt.getTagList("WitcheryPriIncInv", 10);
                NBTTagCompound tagCompound = new NBTTagCompound();
                nbtItem.removeTag("WitcheryPriIncUsr");
                if (nbtItem.isEmpty()) {
                    stack.setTagCompound(null);
                }
                stack.writeToNBT(tagCompound);
                list2.appendTag((NBTBase)tagCompound);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityItemPickup(EntityItemPickupEvent event) {
        if (!event.getItem().world.isRemote && RiteEffectPriorIncarnation.isRitualAllowed() && !event.isCanceled()) {
            ItemStack stack = event.getItem().getItem();
            CommonEvents.removePriorUserTag(stack);
        }
    }

    private static void playTameEffect(EntityTameable entity, boolean tamed) {
        EnumParticleTypes s = EnumParticleTypes.HEART;
        if (!tamed) {
            s = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = entity.world.rand.nextGaussian() * 0.02;
            double d2 = entity.world.rand.nextGaussian() * 0.02;
            double d3 = entity.world.rand.nextGaussian() * 0.02;
            entity.world.spawnParticle(s, entity.posX + (double)(entity.world.rand.nextFloat() * entity.width * 2.0f) - (double)entity.width, entity.posY + 0.5 + (double)(entity.world.rand.nextFloat() * entity.height), entity.posZ + (double)(entity.world.rand.nextFloat() * entity.width * 2.0f) - (double)entity.width, d0, d2, d3, new int[0]);
        }
    }

    public static void checkForRendArmor(LivingHurtEvent event) {
        if (event.getSource().damageType.equals("player") && event.getSource().getTrueSource() != null && event.getSource().getTrueSource() instanceof EntityPlayer) {
            EntityPlayer attackingPlayer = (EntityPlayer)event.getSource().getTrueSource();
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(attackingPlayer);
            ShapeShift.INSTANCE.rendArmor(event.getEntityLiving(), attackingPlayer, playerEx);
        }
    }

    public static void checkForWolfInfection(LivingHurtEvent event, float health) {
        if (!event.isCanceled()) {
            if (event.getSource().damageType.equals("player") && event.getSource().getImmediateSource() != null && event.getSource().getImmediateSource() instanceof EntityPlayer) {
                EntityPlayer attackingPlayer = (EntityPlayer)event.getSource().getTrueSource();
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(attackingPlayer);
                ShapeShift.INSTANCE.processWolfInfection(event.getEntityLiving(), playerEx, health);
            } else if (event.getSource().damageType.equals("mob") && event.getSource().getImmediateSource() instanceof EntityWerewolf) {
                ShapeShift.INSTANCE.processWolfInfection(event.getEntityLiving(), (EntityWerewolf)event.getSource().getImmediateSource(), health);
            }
        }
    }

    public static void checkForChargeDamage(LivingHurtEvent event) {
        if (event.getSource().damageType.equals("player") && event.getSource().getTrueSource() != null && event.getSource().getTrueSource() instanceof EntityPlayer) {
            EntityPlayer attackingPlayer = (EntityPlayer)event.getSource().getTrueSource();
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(attackingPlayer);
            ShapeShift.INSTANCE.updateChargeDamage(event, attackingPlayer, playerEx);
        }
    }

    @SubscribeEvent
    public static void startTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (!target.world.isRemote) {
            if (target instanceof EntityPlayer) {
                WitcheryNetworkChannel.sendTo(new PacketPlayerStyle((EntityPlayer)target), (EntityPlayerMP)event.getEntityPlayer());
            } else if (target instanceof EntityVillager) {
                WitcheryNetworkChannel.sendTo(new PacketExtendedVillagerSync(WitcheryDataExtensions.VILLAGER.get((EntityVillager)target)), (EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            NBTTagCompound nbtData = event.getEntity().getEntityData();
            nbtData.setFloat("WitcheryInitialWidth", event.getEntity().width);
            nbtData.setFloat("WitcheryInitialHeight", event.getEntity().height);
        }
        if (!event.getEntity().world.isRemote && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
            playerEx.sync();
            ShapeShift.INSTANCE.initCurrentShift(player);
            Infusion.syncPlayer(event.getWorld(), player);
            for (EntityPlayer otherPlayer : event.getWorld().playerEntities) {
                if (otherPlayer == player) continue;
                WitcheryNetworkChannel.sendTo(new PacketPlayerStyle(otherPlayer), (EntityPlayerMP)player);
            }
            WitcheryNetworkChannel.sendToDimension(new PacketPlayerStyle(player), event.getWorld().provider.getDimension());
            if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && playerEx.getSpiritData().isSpiritWalking() && !playerEx.getSpiritData().isGhost()) {
                playerEx.getSpiritData().setMustWakeUp(true);
            } else if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && !playerEx.getSpiritData().isSpiritWalking()) {
                WorldProviderSpiritWorld.changeDimension(player, DimensionType.OVERWORLD);
                WorldProviderSpiritWorld.findTopAndSetPosition(player.world, player);
            }
        } else if (WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(event.getWorld()) && WitcheryConfigOptions.disallowedDreamEntities.contains(event.getEntity().getClass())) {
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof EntityVillager && !(event.getEntity() instanceof EntityWereVillager) && !(event.getEntity() instanceof EntityVillageGuard)) {
            EntityVillager villager = (EntityVillager)event.getEntity();
            villager.tasks.addTask(1, (EntityAIBase)new EntityAISleep(villager));
        } else if (!(event.getEntity() instanceof EntityPigZombie) && event.getEntity() instanceof EntityZombie || event.getEntity() instanceof AbstractSkeleton) {
            EntityCreature creature = (EntityCreature)event.getEntity();
            creature.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget(creature, EntityElle.class, 0, false, false, null));
        }
    }

    @SubscribeEvent
    public static void constructEntity(EntityEvent.EntityConstructing event) {
        if (!(event.getEntity() instanceof EntityAgeable)) {
            CommonEventHandler.constructEntity(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerDrops(PlayerDropsEvent event) {
        for (IHandlePlayerDrops handler : WitcheryPotionEffects.PLAYER_DROPS) {
            if (event.isCanceled()) break;
            if (!event.getEntityLiving().isPotionActive((Potion)handler.getPotion())) continue;
            handler.onPlayerDrops(event.getEntityPlayer(), event);
        }
        if (event.getEntityPlayer() != null && !event.getEntityPlayer().world.isRemote && event.getEntityPlayer().isPotionActive(WitcheryPotionEffects.KEEP_INVENTORY)) {
            event.setCanceled(true);
            return;
        }
        if (event.getEntityPlayer() != null && !event.getEntityPlayer().world.isRemote && RiteEffectPriorIncarnation.isRitualAllowed() && !event.isCanceled()) {
            if (event.getEntityPlayer().world.getGameRules().getBoolean("keepInventory")) {
                return;
            }
            List drops = event.getDrops();
            if (drops != null && drops.size() > 0) {
                EntityPlayer player = event.getEntityPlayer();
                for (EntityItem drop : drops) {
                    ItemStack stack = drop.getItem();
                    if (stack.isEmpty()) continue;
                    NBTTagCompound nbt = stack.getTagCompound();
                    if (nbt == null) {
                        nbt = new NBTTagCompound();
                        stack.setTagCompound(nbt);
                    }
                    nbt.setString("WitcheryPriIncUsr", player.getName());
                }
                NBTTagCompound nbt2 = player.getEntityData();
                if (nbt2.hasKey("WitcheryPriIncInv")) {
                    nbt2.removeTag("WitcheryPriIncInv");
                }
                nbt2.setDouble("WitcheryPriIncLocX", player.posX);
                nbt2.setDouble("WitcheryPriIncLocY", player.posY);
                nbt2.setDouble("WitcheryPriIncLocZ", player.posZ);
            }
        }
        if (!event.getEntityPlayer().world.isRemote && !event.isCanceled() && WitcheryUtils.getExtension(event.getEntityPlayer()).isTransformation(WitcheryTransformations.VAMPIRE)) {
            int ticks = (int)(WitcheryConfigOptions.vampireDeathItemKeepAliveMins * 1200.0);
            for (EntityItem item : event.getDrops()) {
                item.lifespan = ticks;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack;
        PotionEffect effect = event.getEntityPlayer().getActivePotionEffect(WitcheryPotionEffects.PARALYSED);
        if (effect != null && effect.getAmplifier() >= 4) {
            event.setCanceled(true);
            return;
        }
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(event.getEntityPlayer());
        VampireTransformation vampireTransformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
        if (vampireTransformation.getSelectedPower() != VampireTransformation.Power.NONE) {
            if (event.getHand() == EnumHand.MAIN_HAND && !event.getWorld().isRemote) {
                vampireTransformation.triggerSelectedPower(event.getTarget());
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
        }
        if (event.isCanceled()) {
            return;
        }
        if (event.getTarget() != null && !event.getTarget().world.isRemote && event.getTarget() instanceof EntityLiving && PotionEnslaved.isMobEnslavedBy((EntityLiving)event.getTarget(), event.getEntityPlayer())) {
            EntityPlayer player = event.getEntityPlayer();
            EntityLiving creature = (EntityLiving)event.getTarget();
            ItemStack heldObject = player.getHeldItem(event.getHand());
            if (heldObject.getItem() == WitcheryIngredientItems.GRAVEYARD_DUST && creature instanceof EntitySummonedUndead) {
                float maxHealth = creature.getMaxHealth() + 2.0f;
                if (maxHealth <= 50.0f) {
                    IAttributeInstance attribute = creature.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
                    attribute.setBaseValue((double)maxHealth);
                    creature.setHealth(maxHealth);
                    creature.enablePersistence();
                    event.getEntityPlayer().world.playSound(null, creature.getPosition(), SoundEvents.ENTITY_SILVERFISH_DEATH, event.getEntityPlayer().getSoundCategory(), 0.5f, 0.4f / ((float)event.getEntityPlayer().getRNG().nextDouble() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(event.getTarget().posX, event.getTarget().posY + (double)event.getTarget().height * 0.8, event.getTarget().posZ, 0.5f, 1.0f, EnumParticleTypes.SPELL_INSTANT), (Entity)creature);
                    if (!player.capabilities.isCreativeMode) {
                        heldObject.shrink(1);
                        if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                        }
                    }
                }
            } else if (!heldObject.isEmpty() && (creature instanceof EntityZombie || creature instanceof AbstractSkeleton)) {
                if (heldObject.getItem() instanceof ItemArmor) {
                    ItemArmor armor = (ItemArmor)heldObject.getItem();
                    if (creature.getItemStackFromSlot(EntityEquipmentSlot.values()[5 - armor.armorType.ordinal()]).isEmpty()) {
                        creature.setItemStackToSlot(EntityEquipmentSlot.values()[4 - armor.armorType.ordinal()], heldObject.splitStack(1));
                        creature.enablePersistence();
                        if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                        }
                    }
                } else if (heldObject.getItem() instanceof ItemSword && creature.getItemStackFromSlot(EntityEquipmentSlot.MAINHAND).isEmpty()) {
                    creature.setItemStackToSlot(EntityEquipmentSlot.MAINHAND, heldObject.splitStack(1));
                    creature.enablePersistence();
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
                    }
                }
            }
        }
        if (event.getTarget() != null && !event.getTarget().world.isRemote && event.getTarget() instanceof EntityVillager) {
            Village village;
            EntityVillager villager = (EntityVillager)event.getTarget();
            ItemStack heldObject2 = event.getEntityPlayer().getHeldItem(event.getHand());
            if (!villager.isChild() && heldObject2.getItem() == Items.LEATHER_CHESTPLATE && event.getEntityPlayer().isSneaking() && (village = villager.village) != null) {
                int rep = village.getPlayerReputation(event.getEntityPlayer().getUniqueID());
                if (rep >= 10) {
                    if (village.getNumVillagers() > 8) {
                        List list2 = event.getEntity().world.getEntitiesWithinAABB(EntityVillageGuard.class, new AxisAlignedBB((double)(village.getCenter().getX() - village.getVillageRadius()), (double)(village.getCenter().getY() - 4), (double)(village.getCenter().getZ() - village.getVillageRadius()), (double)(village.getCenter().getX() + village.getVillageRadius()), (double)(village.getCenter().getY() + 4), (double)(village.getCenter().getZ() + village.getVillageRadius())));
                        int numGuards = list2.size();
                        if (numGuards < MathHelper.floor((double)((double)village.getNumVillagers() * 0.25))) {
                            int villagerNumTrades = villager.getRecipes(event.getEntityPlayer()).size();
                            if (!CreatureUtil.isWerewolf(event.getTarget(), true) && event.getTarget().world.rand.nextInt(villagerNumTrades * 2 + 1) == 0) {
                                villager.playSound(SoundEvents.ENTITY_VILLAGER_YES, 1.0f, (villager.world.rand.nextFloat() - villager.world.rand.nextFloat()) * 0.2f + 1.0f);
                                event.getEntityPlayer().sendMessage(new TextComponentTranslation("witchery.village.guard_accept", new Object[0]).setStyle(new Style().setColor(TextFormatting.GREEN)));
                                EntityVillageGuard.createFrom(villager);
                            } else {
                                event.getEntityPlayer().sendMessage(new TextComponentTranslation("witchery.village.guard_refuse", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                                villager.playSound(SoundEvents.ENTITY_VILLAGER_NO, 1.0f, (villager.world.rand.nextFloat() - villager.world.rand.nextFloat()) * 0.2f + 1.0f);
                            }
                        } else {
                            event.getEntityPlayer().sendMessage(new TextComponentTranslation("witchery.village.already_guarded", new Object[0]).setStyle(new Style().setColor(TextFormatting.BLUE)));
                            event.getEntityPlayer().world.playSound(null, event.getEntityPlayer().getPosition(), SoundEvents.BLOCK_NOTE_SNARE, event.getEntityPlayer().getSoundCategory(), 0.5f, 0.4f / ((float)event.getEntityPlayer().getRNG().nextDouble() * 0.4f + 0.8f));
                        }
                    } else {
                        event.getEntityPlayer().sendMessage(new TextComponentTranslation("witchery.village.small_village", new Object[0]).setStyle(new Style().setColor(TextFormatting.BLUE)));
                        event.getEntityPlayer().world.playSound(null, event.getEntityPlayer().getPosition(), SoundEvents.BLOCK_NOTE_SNARE, event.getEntityPlayer().getSoundCategory(), 0.5f, 0.4f / ((float)event.getEntityPlayer().getRNG().nextDouble() * 0.4f + 0.8f));
                    }
                } else {
                    event.getEntityPlayer().sendMessage(new TextComponentTranslation("witchery.village.low_reputation", new Object[0]).setStyle(new Style().setColor(TextFormatting.BLUE)));
                    event.getEntityPlayer().world.playSound(null, event.getEntityPlayer().getPosition(), SoundEvents.BLOCK_NOTE_SNARE, event.getEntityPlayer().getSoundCategory(), 0.5f, 0.4f / ((float)event.getEntityPlayer().getRNG().nextDouble() * 0.4f + 0.8f));
                }
            }
        }
        if (!event.getEntity().world.isRemote && event.getTarget() != null && event.getTarget() instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)event.getTarget();
            WerewolfTransformation transformation = playerEx.getTransformation(WitcheryTransformations.WEREWOLF);
            if (transformation.getLevel() == 7 && transformation.getQuestState() == WerewolfTransformation.QuestState.STARTED && playerEx.getCurrentForm() == WitcheryAlternateForms.WOLF && !wolf.isTamed() && !wolf.isAngry()) {
                if (wolf.world.rand.nextInt(3) == 0) {
                    wolf.setTamed(true);
                    wolf.getNavigator().clearPath();
                    wolf.setAttackTarget(null);
                    wolf.getAISit().setSitting(true);
                    wolf.setHealth(20.0f);
                    wolf.setOwnerId(event.getEntityPlayer().getUniqueID());
                    CommonEvents.playTameEffect((EntityTameable)wolf, true);
                    transformation.setQuestCount(transformation.getQuestCount() + 1);
                } else {
                    CommonEvents.playTameEffect((EntityTameable)wolf, false);
                    wolf.world.setEntityState((Entity)wolf, (byte)6);
                    if (wolf.world.rand.nextInt(10) == 0) {
                        wolf.setAngry(true);
                        wolf.setAttackTarget((EntityLivingBase)event.getEntityPlayer());
                    }
                }
            }
        }
        if (!(heldStack = event.getEntityPlayer().getHeldItem(event.getHand())).isEmpty()) {
            if (heldStack.getItem() instanceof ItemTaglockKit) {
                ItemTaglockKit.onEntityInteract(event.getEntityPlayer().world, event.getEntityPlayer(), heldStack, event);
                if (event.isCanceled()) {
                    return;
                }
            }
            if (heldStack.getItem() instanceof ItemGlassGoblet) {
                ItemGlassGoblet.onEntityInteract(event.getEntityPlayer().world, event.getEntityPlayer(), heldStack, event);
                if (event.isCanceled()) {
                    return;
                }
            }
            if (heldStack.getItem() == WitcheryIngredientItems.STAKE && WitcheryConfigOptions.allowStakingVampires && event.getTarget() instanceof EntityPlayer) {
                EntityPlayer victim2 = (EntityPlayer)event.getTarget();
                if (WitcheryUtils.getExtension(victim2).isTransformation(WitcheryTransformations.VAMPIRE) && victim2.isPlayerSleeping()) {
                    event.getEntityPlayer().world.playSound(null, victim2.posX, victim2.posY + (double)victim2.height * 0.8, victim2.posZ, WitcherySounds.ENTITY_VAMPIRE_BLOOD_DRINK, event.getEntityPlayer().getSoundCategory(), 0.5f, 0.4f / ((float)event.getEntityPlayer().getRNG().nextDouble() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(victim2.posX, victim2.posY + (double)victim2.height * 0.8, victim2.posZ, victim2.width, victim2.height, EnumParticleTypes.FLAME), (Entity)victim2);
                    victim2.attackEntityFrom((DamageSource)new EntityDamageSource("stake", (Entity)event.getEntityPlayer()), Float.MAX_VALUE);
                    heldStack.shrink(1);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (!event.isCanceled()) {
            PredictionsEventHandler.livingHurt(event.getEntityLiving(), event.getSource());
            if (!event.getEntityLiving().world.isRemote) {
                EntityPlayer player;
                Entity source;
                if (event.getSource().isProjectile()) {
                    boolean mogged;
                    if (event.getSource().getImmediateSource() != null && (mogged = event.getSource().getImmediateSource().getEntityData().getBoolean("WitcheryMogged"))) {
                        if (event.getEntityLiving().isAirBorne) {
                            event.setAmount(event.getAmount() * 3.0f);
                        }
                        if (event.getEntityLiving().isPotionActive(MobEffects.WEAKNESS)) {
                            event.getEntityLiving().removePotionEffect(MobEffects.WEAKNESS);
                        }
                        event.getEntityLiving().addPotionEffect(new PotionEffect(MobEffects.WEAKNESS, 200, 0));
                    }
                } else if (event.getSource().getDamageType().equals("player") && (source = event.getSource().getTrueSource()) instanceof EntityPlayer && ItemGoblinClothes.isBeltWorn(player = (EntityPlayer)source) && player.getHeldItemMainhand().isEmpty()) {
                    event.setAmount(5.0f);
                    EntityLivingBase entity = event.getEntityLiving();
                    if (entity instanceof EntityPlayer) {
                        WitcheryNetworkChannel.sendTo(new PacketPushTarget(entity.motionX, 1.0, entity.motionZ), (EntityPlayerMP)entity);
                    } else {
                        entity.motionY = 1.0;
                    }
                }
                CommonEvents.checkForChargeDamage(event);
                if (event.getEntityLiving() instanceof EntityPlayer) {
                    ItemStack hat;
                    boolean wolfForm;
                    EntityPlayer player2 = (EntityPlayer)event.getEntityLiving();
                    float playerHealth = player2.getHealth();
                    PlayerExtendedData playerEx = WitcheryUtils.getExtension(player2);
                    if (event.getSource() == DamageSource.DROWN && playerEx.isTransformation(WitcheryTransformations.VAMPIRE)) {
                        event.setCanceled(true);
                        return;
                    }
                    boolean bl = wolfForm = playerEx.isTransformation(WitcheryTransformations.WEREWOLF) && playerEx.getCurrentForm() != null && AlternateFormStatManager.INSTANCE.getStats(playerEx.getCurrentForm()).canHowl();
                    if (wolfForm && !WitcheryUtils.isInstantKill((EntityLivingBase)player2, event.getSource(), event.getAmount()) && event.getSource() != DamageSource.IN_WALL && event.getSource() != DamageSource.DROWN && event.getSource() != DamageSource.FALL) {
                        if (!event.getSource().isFireDamage()) {
                            float damageReduction = ShapeShift.INSTANCE.getStat(playerEx, AlternateFormStatType.RESISTANCE);
                            event.setAmount(Math.max(0.0f, event.getAmount() - damageReduction));
                        }
                        if (!CreatureUtil.isWerewolf(event.getSource().getImmediateSource())) {
                            if (!CreatureUtil.isSilverDamage(event.getSource())) {
                                event.setAmount(Math.max(ShapeShift.INSTANCE.getStat(playerEx, AlternateFormStatType.DAMAGE_PERCENTAGE) * event.getAmount(), 2.0f));
                            } else {
                                event.setAmount(event.getAmount() + 5.0f);
                            }
                        }
                        if (event.getAmount() <= 0.0f) {
                            event.setCanceled(true);
                            return;
                        }
                    }
                    if (ItemDeathsClothes.isFullSetWorn((EntityLivingBase)player2) && player2.getHeldItemMainhand().getItem() instanceof ItemDeathsHand) {
                        event.setAmount(Math.min(event.getAmount(), 7.0f));
                    }
                    float healthAfterDamage = EntityUtil.getHealthAfterDamage(event, playerHealth, (EntityLivingBase)player2);
                    if ((WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player2) || playerEx.getSpiritData().isGhost()) && healthAfterDamage <= 0.0f && !player2.capabilities.isCreativeMode) {
                        event.setCanceled(true);
                        event.setResult(Event.Result.DENY);
                        playerEx.getSpiritData().setMustWakeUp(true);
                        return;
                    }
                    CommonEvents.dropItemsOnHit(player2);
                    EntityCrossbowBolt bolt = EntityCrossbowBolt.getSourceBolt(event.getSource());
                    boolean ignoreProtection = wolfForm || bolt != null && bolt.isPoweredDraining();
                    boolean hasHunterSet = ItemHunterClothes.isFullSetWorn((EntityLivingBase)player2, false);
                    if (hasHunterSet && event.getSource().isMagicDamage() && player2.world.rand.nextDouble() < 0.25) {
                        event.setCanceled(true);
                        return;
                    }
                    if ((event.getSource() instanceof EntityDamageSource || event.getSource().isExplosion()) && !ignoreProtection && (hat = player2.getItemStackFromSlot(EntityEquipmentSlot.HEAD)).getItem() == WitcheryEquipmentItems.BABAS_HAT && !WitcheryDimensions.TORMENT.isInDimension((Entity)player2) && player2.world.rand.nextDouble() < 0.25 && Infusion.acquireEnergy(player2.world, player2, 5, true)) {
                        BlockVoidBramble.teleportRandomly(player2.world, player2.getPosition(), (Entity)player2, 6);
                        event.setCanceled(true);
                        return;
                    }
                    if (event.getSource() instanceof EntityDamageSource) {
                        ItemStack vampiricPoppetStack;
                        PotionEffect effect;
                        int i;
                        List effects2;
                        ItemStack stack2;
                        ItemStack stack3;
                        EntityLivingBase living;
                        int currentLevel;
                        EntityDamageSource entitySource = (EntityDamageSource)event.getSource();
                        ItemStack belt = player2.getItemStackFromSlot(EntityEquipmentSlot.LEGS);
                        if (belt.getItem() == WitcheryEquipmentItems.BARK_BELT && !CreatureUtil.isWoodenDamage(event.getSource()) && (currentLevel = Math.min(ItemWitchesClothes.getChargeLevel(belt), ItemWitchesClothes.getMaxChargeLevel((EntityLivingBase)player2))) > 0) {
                            World world = player2.world;
                            Random rand = world.rand;
                            int cost = currentLevel > 1 && rand.nextDouble() < 0.25 ? 2 : 1;
                            ItemWitchesClothes.setChargeLevel(belt, Math.max(currentLevel - cost, 0));
                            event.setCanceled(true);
                            for (int i2 = 0; i2 < cost; ++i2) {
                                double dx = 1.0 * (double)(rand.nextBoolean() ? -1 : 1);
                                double dy = 1.0 * (double)(rand.nextBoolean() ? -1 : 1);
                                EntityItem item = new EntityItem(world, player2.posX + dx, player2.posY + 1.5, player2.posZ + dy, new ItemStack(Items.STICK));
                                item.setPickupDelay(60);
                                item.lifespan = 60;
                                world.spawnEntity((Entity)item);
                            }
                            return;
                        }
                        BiPredicate<EntityPlayer, ItemStack> condition = (p, stack) -> stack.getItem() == WitcheryGeneralItems.HUNTSMANS_SPEAR && player2.getActiveItemStack() == stack;
                        if ((condition.test(player2, player2.getHeldItemMainhand()) || condition.test(player2, player2.getHeldItemOffhand())) && player2.world.rand.nextDouble() < 0.25 && entitySource.getTrueSource() != null && entitySource.getTrueSource() instanceof EntityLivingBase && (living = (EntityLivingBase)entitySource.getTrueSource()).isEntityAlive()) {
                            EntityWolf wolf = new EntityWolf(player2.world);
                            wolf.setLocationAndAngles(player2.posX, player2.posY, player2.posZ, player2.rotationPitch, player2.rotationYawHead);
                            wolf.setAttackTarget(living);
                            wolf.setAngry(true);
                            wolf.addPotionEffect(new PotionEffect(MobEffects.WITHER, 12000, 1));
                            player2.world.spawnEntity((Entity)wolf);
                        }
                        boolean louseUsed = false;
                        for (int j = 0; j < InventoryPlayer.getHotbarSize(); ++j) {
                            stack3 = player2.inventory.getStackInSlot(j);
                            if (stack3.isEmpty() || stack3.getItem() != WitcheryGeneralItems.PARASYTIC_LOUSE || stack3.getItemDamage() <= 0) continue;
                            List list2 = PotionUtils.getEffectsFromStack((ItemStack)stack3);
                            if (!list2.isEmpty()) {
                                PotionEffect effect2 = new PotionEffect((PotionEffect)list2.get(0));
                                if (CommonEvents.isPotionAggressive(effect2.getPotion()) && event.getSource().getTrueSource() != null && event.getSource().getTrueSource() instanceof EntityLivingBase) {
                                    ((EntityLivingBase)event.getSource().getTrueSource()).addPotionEffect(effect2);
                                } else {
                                    if (effect2.getPotion() != MobEffects.REGENERATION) continue;
                                    player2.addPotionEffect(effect2);
                                }
                                player2.attackEntityFrom(DamageSource.MAGIC, 1.0f);
                                stack3.setItemDamage(0);
                                louseUsed = true;
                                break;
                            }
                            stack3.setItemDamage(0);
                        }
                        if (!louseUsed && WitcheryEquipmentItems.BITING_BELT.isBeltWorn(player2) && (stack2 = player2.getItemStackFromSlot(EntityEquipmentSlot.LEGS)).hasTagCompound()) {
                            effects2 = PotionUtils.getEffectsFromStack((ItemStack)stack2);
                            boolean done = false;
                            int size = effects2.size();
                            for (i = 0; i < size; ++i) {
                                if (done || player2.isPotionActive((effect = new PotionEffect((PotionEffect)effects2.get(i))).getPotion()) || effect.getPotion() == MobEffects.REGENERATION) continue;
                                done = true;
                                if (CommonEvents.isPotionAggressive(effect.getPotion()) && event.getSource().getTrueSource() != null && event.getSource().getTrueSource() instanceof EntityLivingBase) {
                                    ((EntityLivingBase)event.getSource().getTrueSource()).addPotionEffect(effect);
                                } else {
                                    player2.addPotionEffect(effect);
                                }
                                player2.attackEntityFrom(DamageSource.MAGIC, 1.0f);
                                WitcheryUtils.removeEffect(stack2, i);
                                --size;
                                --i;
                            }
                        }
                        CommonEvents.checkForRendArmor(event);
                        if (!ignoreProtection && !playerEx.isTransformation(WitcheryTransformations.VAMPIRE) && (vampiricPoppetStack = WitcheryPoppetItems.findBoundPoppetInWorld(WitcheryPoppetItems.VAMPIRIC, player2, 66, true, false)) != null) {
                            EntityWitchHunter.blackMagicPerformed(player2);
                            EntityLivingBase targetEntity = ItemTaglockKit.getBoundEntity(player2.world, vampiricPoppetStack, 1);
                            if (targetEntity != null && !WitcheryPoppetItems.voodooProtectionActivated(player2, vampiricPoppetStack, targetEntity, true, false) && !ItemHunterClothes.isFullSetWorn(targetEntity, false)) {
                                if (targetEntity instanceof EntityPlayer) {
                                    targetEntity.attackEntityFrom(event.getSource(), event.getAmount());
                                    event.setCanceled(true);
                                } else if (targetEntity instanceof EntityLiving && targetEntity.isEntityAlive()) {
                                    targetEntity.attackEntityFrom(event.getSource(), Math.min(event.getAmount(), 15.0f));
                                    if (!targetEntity.isEntityAlive()) {
                                        ItemTaglockKit.clearTaglock(vampiricPoppetStack, 1);
                                    }
                                    event.setCanceled(true);
                                }
                                return;
                            }
                        }
                        if (!louseUsed) {
                            for (int j = 0; j < InventoryPlayer.getHotbarSize(); ++j) {
                                stack3 = player2.inventory.getStackInSlot(j);
                                if (!stack3.isEmpty() && stack3.getItem() == WitcheryGeneralItems.PARASYTIC_LOUSE && PotionUtils.getPotionFromItem((ItemStack)stack3) != PotionTypes.EMPTY) {
                                    List list3 = PotionUtils.getEffectsFromStack((ItemStack)stack3);
                                    if (!list3.isEmpty()) {
                                        PotionEffect effect3 = new PotionEffect((PotionEffect)list3.get(0));
                                        if (effect3.getPotion() == MobEffects.REGENERATION) {
                                            player2.addPotionEffect(effect3);
                                        }
                                        player2.attackEntityFrom(DamageSource.MAGIC, 1.0f);
                                        PotionUtils.addPotionToItemStack((ItemStack)stack3, (PotionType)PotionTypes.EMPTY);
                                        louseUsed = true;
                                        break;
                                    }
                                    PotionUtils.addPotionToItemStack((ItemStack)stack3, (PotionType)PotionTypes.EMPTY);
                                }
                                ++j;
                            }
                        }
                        if (!louseUsed && WitcheryEquipmentItems.BITING_BELT.isBeltWorn(player2) && (stack = player2.getItemStackFromSlot(EntityEquipmentSlot.LEGS)).hasTagCompound()) {
                            effects2 = PotionUtils.getEffectsFromStack((ItemStack)stack);
                            boolean done = false;
                            int size = effects2.size();
                            for (i = 0; i < size; ++i) {
                                if (done || player2.isPotionActive((effect = new PotionEffect((PotionEffect)effects2.get(i))).getPotion()) || effect.getPotion() == MobEffects.REGENERATION) continue;
                                done = true;
                                player2.addPotionEffect(effect);
                                player2.attackEntityFrom(DamageSource.MAGIC, 1.0f);
                                WitcheryUtils.removeEffect(stack, i);
                                --size;
                                --i;
                            }
                        }
                    }
                    if (healthAfterDamage <= 0.0f && !wolfForm && !playerEx.isTransformation(WitcheryTransformations.VAMPIRE)) {
                        if (event.getSource() == DamageSource.FALL || event.getSource() == DamageSource.FALLING_BLOCK) {
                            WitcheryPoppetItems.cancelEventIfPoppetFound(player2, WitcheryPoppetItems.EARTH_PROTECTION, event, false);
                        } else if (event.getSource().isFireDamage() || event.getSource().isExplosion()) {
                            WitcheryPoppetItems.cancelEventIfPoppetFound(player2, WitcheryPoppetItems.FIRE_PROTECTION, event, true);
                            if (event.isCanceled()) {
                                player2.addPotionEffect(new PotionEffect(MobEffects.FIRE_RESISTANCE, 60, 0));
                            }
                        } else if (event.getSource() == DamageSource.DROWN) {
                            WitcheryPoppetItems.cancelEventIfPoppetFound(player2, WitcheryPoppetItems.WATER_PROTECTION, event, true);
                            if (event.isCanceled()) {
                                player2.addPotionEffect(new PotionEffect(MobEffects.WATER_BREATHING, 60, 0));
                            }
                        } else if (event.getSource() == DamageSource.STARVE) {
                            WitcheryPoppetItems.cancelEventIfPoppetFound(player2, WitcheryPoppetItems.STARVATION_PROTECTION, event, true);
                            if (event.isCanceled()) {
                                player2.addPotionEffect(new PotionEffect(MobEffects.SATURATION, 60, 0));
                            }
                        }
                        if (!event.isCanceled()) {
                            WitcheryPoppetItems.cancelEventIfPoppetFound(player2, WitcheryPoppetItems.DEATH_PROTECTION, event, true, ignoreProtection);
                            if (event.isCanceled()) {
                                if (player2.isBurning() || event.getSource().isFireDamage() || event.getSource().isExplosion()) {
                                    player2.addPotionEffect(new PotionEffect(MobEffects.FIRE_RESISTANCE, 120, 0));
                                } else if (event.getSource() == DamageSource.DROWN) {
                                    player2.addPotionEffect(new PotionEffect(MobEffects.WATER_BREATHING, 120, 0));
                                } else if (event.getSource() == DamageSource.STARVE) {
                                    player2.addPotionEffect(new PotionEffect(MobEffects.SATURATION, 120, 0));
                                }
                            }
                        }
                    }
                    if (!event.isCanceled() && healthAfterDamage <= 2.0f && event.getSource().damageType.equals(DamageSource.STARVE.damageType)) {
                        WitcheryPoppetItems.cancelEventIfPoppetFound(player2, WitcheryPoppetItems.STARVATION_PROTECTION, event, true);
                        if (event.isCanceled()) {
                            player2.addPotionEffect(new PotionEffect(MobEffects.SATURATION, 60, 0));
                        }
                    }
                    Familiars.handlePlayerHurt(event, player2);
                    CommonEvents.checkForWolfInfection(event, healthAfterDamage);
                    WitcheryPoppetItems.checkForArmorProtection(player2);
                } else {
                    if (event.getEntityLiving() instanceof EntityGoblin && event.getSource() == DamageSource.FALL) {
                        event.setCanceled(true);
                        return;
                    }
                    if (event.getEntityLiving() instanceof EntityVillager && event.getSource() != null && event.getSource().getTrueSource() != null && (event.getSource().getTrueSource() instanceof EntityVillageGuard || event.getSource().getTrueSource() instanceof EntityWitchHunter)) {
                        event.setCanceled(true);
                        return;
                    }
                    if (WitcheryConfigOptions.isReduceZombieVillagerDamageActive() && event.getEntityLiving() instanceof EntityVillager && event.getSource().getTrueSource() != null && event.getSource().getTrueSource() instanceof EntityZombie) {
                        event.setAmount(0.5f);
                    }
                    CommonEvents.checkForRendArmor(event);
                    CommonEvents.checkForWolfInfection(event, EntityUtil.getHealthAfterDamage(event, event.getEntityLiving().getHealth(), event.getEntityLiving()));
                }
            }
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (event.getSource().isFireDamage() && event.isCancelable() && !event.isCanceled() && ((ItemStack)player.inventory.armorInventory.get(2)).getItem() == WitcheryEquipmentItems.DEATH_ROBE) {
                if (!player.isPotionActive(MobEffects.FIRE_RESISTANCE)) {
                    player.addPotionEffect(new PotionEffect(MobEffects.FIRE_RESISTANCE, 100, 0));
                }
                event.setCanceled(true);
            }
            if (!event.isCanceled()) {
                Infusion.getInfusion(player).onHurt(player, event);
            }
        }
        for (IHandleLivingHurt handler : WitcheryPotionEffects.LIVING_HURTS) {
            if (event.isCanceled()) break;
            if (!handler.handleAllHurtEvents() && !event.getEntityLiving().isPotionActive((Potion)handler.getPotion())) continue;
            PotionEffect effect = event.getEntityLiving().getActivePotionEffect((Potion)handler.getPotion());
            handler.onLivingHurt(event.getEntityLiving().world, event.getEntityLiving(), event, effect != null ? effect.getAmplifier() : -1);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingDeath(LivingDeathEvent event) {
        Collection activeEffects;
        PlayerExtendedData playerEx;
        EntityPlayer player;
        Entity attacker;
        Entity entitySource;
        if (!event.getEntityLiving().world.isRemote && (event.getEntityLiving() instanceof EntityWitch || event.getEntityLiving() instanceof EntityCovenWitch) && (entitySource = event.getSource().getImmediateSource()) instanceof EntityPlayer) {
            EntityPlayer player2 = (EntityPlayer)entitySource;
            boolean hasArthana = player2.getHeldItemMainhand().getItem() == WitcheryGeneralItems.ARTHANA || player2.getHeldItemOffhand().getItem() == WitcheryGeneralItems.ARTHANA;
            double d = player2.world.rand.nextDouble();
            double d2 = hasArthana ? 0.5 : 0.33;
            if (d < d2) {
                ItemStack itemstack = new ItemStack((Item)WitcheryGeneralItems.WITCH_HAND);
                EntityItem entityItem = new EntityItem(event.getEntityLiving().world, event.getEntityLiving().posX, event.getEntityLiving().posY, event.getEntityLiving().posZ, itemstack);
                event.getEntityLiving().world.spawnEntity((Entity)entityItem);
            }
        }
        if (event.getEntityLiving().world.isRemote && !event.isCanceled()) {
            if (event.getEntityLiving() instanceof EntityPlayer) {
                if (event.getSource().getImmediateSource() != null && event.getSource().getImmediateSource() instanceof EntityPlayer && event.getSource().getImmediateSource() != event.getEntityLiving()) {
                    attacker = (EntityPlayer)event.getSource().getImmediateSource();
                    for (BlockAreaMarker.TileEntityAreaMarker tile : BlockAreaMarker.AreaMarkerRegistry.instance().tiles) {
                        if (!tile.isNear((EntityLivingBase)attacker)) continue;
                        tile.addKiller((EntityPlayer)attacker);
                    }
                }
                player = (EntityPlayer)event.getEntityLiving();
                playerEx = WitcheryUtils.getExtension(player);
                LivingExtendedData livingEx = WitcheryDataExtensions.LIVING.get((EntityLivingBase)player);
                if (playerEx.isTransformation(WitcheryTransformations.VAMPIRE)) {
                    event.setCanceled(true);
                    player.setHealth(1.0f);
                }
                livingEx.setDepthsTicks(0);
                PlayerEffects.removeAll(player);
            }
            Familiars.handleLivingDeath(event);
        } else if (!(event.getEntityLiving().world.isRemote || event.isCancelable() && event.isCanceled())) {
            WerewolfTransformation transformation;
            EntityPlayer lastAttacker;
            if (event.getEntityLiving() instanceof EntityPlayer && (playerEx = WitcheryUtils.getExtension(player = (EntityPlayer)event.getEntityLiving())).isTransformation(WitcheryTransformations.VAMPIRE)) {
                if (player.getHealth() > 0.0f) {
                    event.setCanceled(true);
                    return;
                }
                if (CreatureUtil.checkForVampireDeath((EntityLivingBase)player, event.getSource())) {
                    event.setCanceled(true);
                    return;
                }
            }
            CommonEvents.dropExtraItemsFromNBT(event);
            attacker = event.getSource().getTrueSource();
            if (attacker instanceof EntityPlayer) {
                EntityPlayer player2 = (EntityPlayer)attacker;
                PlayerExtendedData playerEx2 = WitcheryUtils.getExtension(player2);
                WerewolfTransformation transformation2 = playerEx2.getTransformation(WitcheryTransformations.WEREWOLF);
                if (transformation2.getLevel() == 4 && event.getEntity() instanceof EntityHornedHuntsman && transformation2.getQuestState() == WerewolfTransformation.QuestState.STARTED) {
                    transformation2.setQuestState(WerewolfTransformation.QuestState.COMPLETE);
                }
                if (playerEx2.hasVampireBook()) {
                    boolean dropPage;
                    boolean bl = dropPage = !event.getEntityLiving().isNonBoss() || (event.getEntityLiving() instanceof EntityPigZombie || event.getEntityLiving() instanceof EntityEnderman) && player2.world.rand.nextDouble() < 0.09 || PotionParalysis.isVillager((Entity)event.getEntityLiving()) && player2.world.rand.nextDouble() < 0.1 || event.getEntityLiving().isEntityUndead() && player2.world.rand.nextDouble() < 0.02;
                    if (dropPage) {
                        EntityItem entityItem = new EntityItem(event.getEntityLiving().world, event.getEntityLiving().posX, event.getEntityLiving().posY + 1.0, event.getEntityLiving().posZ, new ItemStack(WitcheryIngredientItems.VAMPIRE_BOOK_PAGE));
                        event.getEntityLiving().world.spawnEntity((Entity)entityItem);
                    }
                }
            } else if (event.getEntity() instanceof EntityHornedHuntsman && (lastAttacker = ((EntityHornedHuntsman)event.getEntity()).getAttackingPlayer()) != null && (transformation = WitcheryUtils.getExtension(lastAttacker).getTransformation(WitcheryTransformations.WEREWOLF)).getLevel() == 4 && transformation.getQuestState() == WerewolfTransformation.QuestState.STARTED) {
                transformation.setQuestState(WerewolfTransformation.QuestState.COMPLETE);
            }
            Entity entitySource2 = event.getSource().getImmediateSource();
            if (entitySource2 instanceof EntityPlayer) {
                boolean allowDrops;
                VampireTransformation vampireTransformation;
                EntityPlayer player3 = (EntityPlayer)entitySource2;
                PlayerExtendedData playerEx3 = WitcheryUtils.getExtension(player3);
                boolean hasArthana = player3.getHeldItemMainhand().getItem() == WitcheryGeneralItems.ARTHANA;
                ItemStack itemstack = ItemStack.EMPTY;
                ShapeShift.INSTANCE.processCreatureKilled(event, player3, playerEx3);
                WerewolfTransformation werewolfTransformation = playerEx3.getTransformation(WitcheryTransformations.WEREWOLF);
                if (werewolfTransformation.getLevel() == 5 && ShapeShift.INSTANCE.isWolfAnimalForm(playerEx3) && werewolfTransformation.getQuestState() == WerewolfTransformation.QuestState.STARTED) {
                    if (event.getEntity() instanceof IMob && !player3.onGround) {
                        werewolfTransformation.setQuestCount(werewolfTransformation.getQuestCount() + 1);
                    }
                } else if (werewolfTransformation.getLevel() == 8 && playerEx3.getCurrentForm() == WitcheryAlternateForms.WOLFMAN && werewolfTransformation.getQuestState() == WerewolfTransformation.QuestState.STARTED) {
                    if (event.getEntity() instanceof EntityPigZombie) {
                        werewolfTransformation.setQuestCount(werewolfTransformation.getQuestCount() + 1);
                    }
                } else if (werewolfTransformation.getLevel() == 9 && ShapeShift.INSTANCE.isWolfAnimalForm(playerEx3) && werewolfTransformation.getQuestState() == WerewolfTransformation.QuestState.STARTED && (event.getEntity() instanceof EntityVillager || event.getEntity() instanceof EntityPlayer)) {
                    werewolfTransformation.setQuestCount(werewolfTransformation.getQuestCount() + 1);
                }
                if ((vampireTransformation = playerEx3.getTransformation(WitcheryTransformations.VAMPIRE)).getLevel() == 5 && vampireTransformation.getCanLevelUp() && event.getEntity() instanceof EntityBlaze) {
                    if (vampireTransformation.getQuestCount() >= 19) {
                        if (vampireTransformation.levelUp()) {
                            playerEx3.sync();
                        }
                    } else {
                        vampireTransformation.setQuestCount(vampireTransformation.getQuestCount() + 1);
                    }
                }
                int baseLooting = EnchantmentHelper.getLootingModifier((EntityLivingBase)player3);
                double lootingFactor = 1.0 + (double)baseLooting;
                double halfLooting = 1.0 + (double)((float)baseLooting / 2.0f);
                if (InfusedBrewEffect.getActiveBrew(player3) == WitcheryInfusedBrews.GRAVE) {
                    float maxHealth = player3.getMaxHealth();
                    if (event.getEntityLiving() instanceof EntityPlayer) {
                        player3.getFoodStats().addStats(20, 0.9f);
                        player3.heal(maxHealth * 0.6f);
                    } else if (event.getEntityLiving() instanceof EntityVillager) {
                        player3.getFoodStats().addStats(20, 0.9f);
                        player3.heal(maxHealth * 0.4f);
                    } else if (event.getEntityLiving() instanceof EntityAnimal) {
                        player3.getFoodStats().addStats(8, 0.8f);
                        player3.heal(maxHealth * 0.1f);
                    }
                }
                ItemGlassGoblet.handleCreatureDeath(player3.world, player3, event.getEntityLiving());
                boolean bl = allowDrops = !WitcheryUtils.isNoDrops(event.getEntityLiving());
                if (allowDrops) {
                    if (event.getEntityLiving() instanceof EntityVillager) {
                        VillagerExtendedData villagerEx = WitcheryDataExtensions.VILLAGER.get((EntityVillager)event.getEntityLiving());
                        vampireTransformation.fillBloodReserve(villagerEx.getBlood());
                        playerEx3.sync();
                    } else if (event.getEntityLiving() instanceof EntityVillageGuard) {
                        EntityVillageGuard guard = (EntityVillageGuard)event.getEntityLiving();
                        vampireTransformation.fillBloodReserve(guard.getBlood());
                        playerEx3.sync();
                    } else if (event.getEntityLiving() instanceof EntityPlayer) {
                        PlayerExtendedData targetEx = WitcheryUtils.getExtension((EntityPlayer)event.getEntityLiving());
                        vampireTransformation.fillBloodReserve(targetEx.getHumanBlood());
                        playerEx3.sync();
                    } else if (event.getEntityLiving() instanceof AbstractSkeleton) {
                        AbstractSkeleton skeleton = (AbstractSkeleton)event.getEntityLiving();
                        if (hasArthana && !(skeleton instanceof EntityWitherSkeleton) && event.getEntityLiving().world.rand.nextDouble() <= Math.min(0.05 * lootingFactor, 1.0)) {
                            itemstack = new ItemStack(Items.SKULL, 1, 0);
                        } else if (hasArthana && event.getEntityLiving().world.rand.nextDouble() <= Math.min(0.04 * lootingFactor, 1.0)) {
                            itemstack = new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST);
                        }
                    } else if (event.getEntityLiving() instanceof EntityZombie) {
                        if (hasArthana && event.getEntityLiving().world.rand.nextDouble() <= Math.min(0.02 * lootingFactor, 1.0)) {
                            itemstack = new ItemStack(Items.SKULL, 1, 2);
                        } else if (hasArthana && event.getEntityLiving().world.rand.nextDouble() <= Math.min(0.03 * lootingFactor, 1.0)) {
                            itemstack = new ItemStack(WitcheryIngredientItems.SPECTRAL_DUST);
                        }
                    } else if (event.getEntityLiving() instanceof EntityCreeper) {
                        if (hasArthana && event.getEntityLiving().world.rand.nextDouble() <= Math.min(0.01 * lootingFactor, 1.0)) {
                            itemstack = new ItemStack(Items.SKULL, 1, 4);
                        } else {
                            double d = event.getEntityLiving().world.rand.nextDouble();
                            double d3 = hasArthana ? 0.08 : 0.02;
                            if (d <= Math.min(d3 * lootingFactor, 1.0)) {
                                itemstack = new ItemStack(WitcheryIngredientItems.CREEPER_HEART);
                            }
                        }
                    } else if (event.getEntityLiving() instanceof EntityDemon) {
                        if (hasArthana && event.getEntityLiving().world.rand.nextDouble() <= Math.min(0.33 * halfLooting, 1.0)) {
                            itemstack = new ItemStack((Block)WitcheryBlocks.DEMON_HEART);
                        }
                    } else if (event.getEntityLiving() instanceof EntityPlayer) {
                        if (hasArthana && event.getEntityLiving().world.rand.nextDouble() <= Math.min(0.1 * halfLooting, 1.0)) {
                            EntityPlayer victim = (EntityPlayer)event.getEntityLiving();
                            itemstack = new ItemStack(Items.SKULL, 1, 3);
                            NBTTagCompound tag = itemstack.getTagCompound();
                            if (tag == null) {
                                tag = new NBTTagCompound();
                                itemstack.setTagCompound(tag);
                            }
                            tag.setString("SkullOwner", victim.getName());
                        }
                    } else if (event.getEntityLiving() instanceof EntityBat) {
                        double d = player3.world.rand.nextDouble();
                        double d4 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.75) : 0.33;
                        if (d <= d4) {
                            itemstack = new ItemStack(WitcheryIngredientItems.BAT_WOOL);
                        }
                    } else if (event.getEntityLiving() instanceof EntityWolf) {
                        double d = player3.world.rand.nextDouble();
                        double d5 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.75) : 0.33;
                        if (d <= d5) {
                            itemstack = new ItemStack(WitcheryIngredientItems.DOG_TONGUE);
                        }
                        if (player3.world.rand.nextInt(12) <= Math.min(baseLooting, 3)) {
                            event.getEntityLiving().entityDropItem(new ItemStack((Block)WitcheryBlocks.WOLF_HEAD, 1, 0), 0.0f);
                        }
                    } else if (event.getEntityLiving() instanceof EntityOwl) {
                        if (!((EntityOwl)event.getEntityLiving()).isTemp()) {
                            double d = player3.world.rand.nextDouble();
                            double d6 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.5) : 0.2;
                            if (d <= d6) {
                                itemstack = new ItemStack(WitcheryIngredientItems.OWLETS_WING);
                            }
                        }
                    } else if (event.getEntityLiving() instanceof EntitySheep) {
                        if (CreatureUtil.isWerewolf(entitySource2, false) && !event.getEntityLiving().isChild() && event.getEntityLiving().world.rand.nextInt(4) != 0) {
                            itemstack = new ItemStack(WitcheryIngredientItems.SHEEP_LIVER);
                        }
                    } else if (event.getEntityLiving() instanceof EntityToad) {
                        if (!((EntityToad)event.getEntityLiving()).isTemp()) {
                            double d = player3.world.rand.nextDouble();
                            double d7 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.5) : 0.2;
                            if (d <= d7) {
                                itemstack = new ItemStack(WitcheryIngredientItems.FROG_TOE);
                            }
                        }
                    } else {
                        String name2;
                        Class<?> theClass = event.getEntityLiving().getClass();
                        if (theClass != null && !(name2 = theClass.getSimpleName()).isEmpty()) {
                            String upperName = name2.toUpperCase(Locale.ROOT);
                            if (upperName.contains("WOLF") || upperName.contains("DOG") || upperName.contains("FOX")) {
                                double d = player3.world.rand.nextDouble();
                                double d8 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.75) : 0.33;
                                if (d <= d8) {
                                    itemstack = new ItemStack(WitcheryIngredientItems.DOG_TONGUE);
                                }
                                if ((upperName.contains("WOLF") || upperName.contains("DOG")) && player3.world.rand.nextInt(12) <= Math.min(baseLooting, 3)) {
                                    event.getEntityLiving().entityDropItem(new ItemStack((Block)WitcheryBlocks.WOLF_HEAD), 0.0f);
                                }
                            } else if (upperName.contains("FIREBAT") || upperName.contains("BAT")) {
                                double d = player3.world.rand.nextDouble();
                                double d9 = hasArthana ? (baseLooting > 0 ? 1.0 : 0.75) : 0.33;
                                if (d <= d9) {
                                    itemstack = new ItemStack(WitcheryIngredientItems.BAT_WOOL);
                                }
                            }
                        }
                    }
                }
                if (!itemstack.isEmpty()) {
                    EntityItem entityItem2 = new EntityItem(event.getEntityLiving().world, event.getEntityLiving().posX, event.getEntityLiving().posY + 1.0, event.getEntityLiving().posZ, itemstack);
                    event.getEntityLiving().world.spawnEntity((Entity)entityItem2);
                }
            }
        }
        for (IHandleLivingDeath handler : WitcheryPotionEffects.LIVING_DEATHS) {
            if (event.isCanceled()) break;
            if (!event.getEntityLiving().isPotionActive((Potion)handler.getPotion())) continue;
            PotionEffect effect = event.getEntityLiving().getActivePotionEffect((Potion)handler.getPotion());
            handler.onLivingDeath(event.getEntityLiving().world, event.getEntityLiving(), event, effect.getAmplifier());
        }
        if (!event.getEntityLiving().world.isRemote && event.getEntityLiving() instanceof EntityPlayer && (activeEffects = (player = (EntityPlayer)event.getEntityLiving()).getActivePotionEffects()).size() > 0) {
            ArrayList<PotionEffect> permanentEffectList = new ArrayList<PotionEffect>();
            int allPermentantLevel = -1;
            if (player.isPotionActive(WitcheryPotionEffects.KEEP_EFFECTS)) {
                PotionEffect permAll = player.getActivePotionEffect(WitcheryPotionEffects.KEEP_EFFECTS);
                allPermentantLevel = permAll.getAmplifier();
            }
            for (PotionEffect effect2 : activeEffects) {
                Potion potion = effect2.getPotion();
                if (potion instanceof WitcheryPotion && ((WitcheryPotion)potion).isPermanent()) {
                    permanentEffectList.add(effect2);
                    continue;
                }
                if (WitcheryPotion.isDebuff(potion) || allPermentantLevel < effect2.getAmplifier()) continue;
                permanentEffectList.add(effect2);
            }
            if (permanentEffectList.size() > 0) {
                PlayerExtendedData playerEx2 = WitcheryUtils.getExtension(player);
                playerEx2.permanentEffects.clear();
                playerEx2.permanentEffects.addAll(permanentEffectList);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onEnderTeleport(EnderTeleportEvent event) {
        if (!event.isCanceled() && event.getEntityLiving() != null && !event.getEntityLiving().world.isRemote && event.getEntityLiving() instanceof EntityPlayer && ItemHunterClothes.isFullSetWorn(event.getEntityLiving(), false)) {
            event.setCanceled(true);
        }
        if (event.getEntityLiving() != null && (WitcheryDimensions.TORMENT.isInDimension((Entity)event.getEntityLiving()) || WitcheryDimensions.MIRROR.isInDimension((Entity)event.getEntityLiving()))) {
            event.setCanceled(true);
            return;
        }
        for (IHandleEnderTeleport handler : WitcheryPotionEffects.ENDER_TELEPORTS) {
            if (event.isCanceled()) break;
            if (!event.getEntityLiving().isPotionActive((Potion)handler.getPotion())) continue;
            handler.onEnderTeleport(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        for (IHandleHarvestDrops handler : WitcheryPotionEffects.HARVEST_DROPS) {
            if (event.isCanceled()) break;
            if (event.getHarvester() == null || !event.getHarvester().isPotionActive((Potion)handler.getPotion())) continue;
            PotionEffect effect = event.getHarvester().getActivePotionEffect((Potion)handler.getPotion());
            handler.onHarvestDrops(event.getWorld(), event, effect.getAmplifier());
        }
    }

    @SubscribeEvent
    public static void useBucket(FillBucketEvent event) {
    }

    @SubscribeEvent
    public static void loadLoot(LootTableLoadEvent event) {
        if (event.getName().equals((Object)WitcheryLootTables.BOOKSHOP)) {
            for (Item item : WitcheryConfigOptions.townBooks) {
                if (item == null) continue;
                event.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryItem(item, 1, 0, new LootFunction[0], new LootCondition[0], null)}, new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), item.getRegistryName().toString()));
            }
        }
    }

    @SubscribeEvent
    public static void tickItem(LivingEntityUseItemEvent.Tick event) {
        CommonEventHandler.tickItem(event.getEntityLiving(), event.getItem());
    }

    private static void dropExtraItemsFromNBT(LivingDeathEvent event) {
        NBTTagCompound nbtEntityData;
        if (!event.getEntityLiving().world.isRemote && (nbtEntityData = event.getEntityLiving().getEntityData()).hasKey("WitcheryExtraDrops")) {
            NBTTagList nbtExtraDrops = nbtEntityData.getTagList("WitcheryExtraDrops", 10);
            for (int i = 0; i < nbtExtraDrops.tagCount(); ++i) {
                NBTTagCompound nbtTag = nbtExtraDrops.getCompoundTagAt(i);
                ItemStack extraStack = new ItemStack(nbtTag);
                EntityItem entityItem = new EntityItem(event.getEntityLiving().world, event.getEntityLiving().posX, event.getEntityLiving().posY + 1.0, event.getEntityLiving().posZ, extraStack);
                event.getEntityLiving().world.spawnEntity((Entity)entityItem);
            }
        }
    }
}

