/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import org.apache.commons.lang3.StringUtils;

public class ChantCommand
implements ICommand {
    private final List<String> aliases = new ArrayList<String>();

    public ChantCommand() {
        this.aliases.add(this.getName());
    }

    public String getName() {
        return "chant";
    }

    public String getUsage(ICommandSender sender) {
        return this.getName() + " <message>";
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(new TextComponentTranslation("rite.witchery.unknown_chant", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            return;
        }
        String strings = StringUtils.join((Object[])args, (String)" ");
        Entity player = sender.getCommandSenderEntity();
        if (player instanceof EntityPlayer) {
            if (WitcheryEquipmentItems.RUBY_SLIPPERS.trySayTheresNoPlaceLikeHome((EntityPlayer)player, strings)) {
                return;
            }
            if (WitcheryBlocks.MIRROR.trySayMirrorMirrorSendMeHome((EntityPlayer)player, strings)) {
                return;
            }
        }
        sender.sendMessage(new TextComponentTranslation("rite.witchery.unknown_chant", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
    }

    public boolean checkPermission(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    public boolean isUsernameIndex(String[] astring, int i) {
        return false;
    }

    public int compareTo(ICommand iCommand) {
        return 0;
    }
}

