/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.entity.passive.EntityToad;

public class ModelToad
extends ModelBase {
    public ModelRenderer body;
    public ModelRenderer head;
    public ModelRenderer leftLeg;
    public ModelRenderer leftArm;
    public ModelRenderer rightLeg;
    public ModelRenderer rightArm;
    public ModelRenderer leftEye;
    public ModelRenderer rightEye;

    public ModelToad() {
        this.textureWidth = 24;
        this.textureHeight = 16;
        this.leftLeg = new ModelRenderer((ModelBase)this, 0, 5);
        this.leftLeg.setRotationPoint(1.5f, 0.7f, 2.0f);
        this.leftLeg.addBox(-1.0f, 0.0f, -2.0f, 2, 1, 2, 0.0f);
        this.setRotateAngle(this.leftLeg, 0.41887903f, 0.0f, 0.0f);
        this.leftEye = new ModelRenderer((ModelBase)this, 9, 0);
        this.leftEye.setRotationPoint(0.5f, -1.5f, -1.5f);
        this.leftEye.addBox(0.0f, -1.0f, -0.5f, 1, 1, 1, 0.0f);
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.setRotationPoint(0.0f, -0.5f, -2.0f);
        this.head.addBox(-1.5f, -1.5f, -3.0f, 3, 2, 3, 0.0f);
        this.setRotateAngle(this.head, 0.41887903f, 0.0f, 0.0f);
        this.body = new ModelRenderer((ModelBase)this, 4, 5);
        this.body.setRotationPoint(0.0f, 21.5f, 0.0f);
        this.body.addBox(-2.0f, -1.0f, -2.5f, 4, 2, 5, 0.0f);
        this.setRotateAngle(this.body, -0.41887903f, 0.0f, 0.0f);
        this.rightArm = new ModelRenderer((ModelBase)this, 0, 8);
        this.rightArm.mirror = true;
        this.rightArm.setRotationPoint(-1.4f, 0.3f, -2.0f);
        this.rightArm.addBox(-0.5f, 0.0f, -0.5f, 1, 3, 1, 0.0f);
        this.setRotateAngle(this.rightArm, 0.41887903f, 0.0f, 0.0f);
        this.leftArm = new ModelRenderer((ModelBase)this, 0, 8);
        this.leftArm.setRotationPoint(1.4f, 0.3f, -2.0f);
        this.leftArm.addBox(-0.5f, 0.0f, -0.5f, 1, 3, 1, 0.0f);
        this.setRotateAngle(this.leftArm, 0.41887903f, 0.0f, 0.0f);
        this.rightLeg = new ModelRenderer((ModelBase)this, 0, 5);
        this.rightLeg.mirror = true;
        this.rightLeg.setRotationPoint(-1.5f, 0.7f, 2.0f);
        this.rightLeg.addBox(-1.0f, 0.0f, -2.0f, 2, 1, 2, 0.0f);
        this.setRotateAngle(this.rightLeg, 0.41887903f, 0.0f, 0.0f);
        this.rightEye = new ModelRenderer((ModelBase)this, 9, 0);
        this.rightEye.mirror = true;
        this.rightEye.setRotationPoint(-0.5f, -1.5f, -1.5f);
        this.rightEye.addBox(-1.0f, -1.0f, -0.5f, 1, 1, 1, 0.0f);
        this.body.addChild(this.leftLeg);
        this.head.addChild(this.leftEye);
        this.body.addChild(this.head);
        this.body.addChild(this.rightArm);
        this.body.addChild(this.leftArm);
        this.body.addChild(this.rightLeg);
        this.head.addChild(this.rightEye);
    }

    public void render(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.isChild) {
            float f = 2.0f;
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)0.0f, (float)(5.0f * scale), (float)(f * scale));
            GlStateManager.scale((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.translate((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            GlStateManager.popMatrix();
        }
        this.body.render(scale);
    }

    public void setLivingAnimations(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTickTime) {
        EntityToad toad2 = (EntityToad)entity;
        if (toad2.isSitting()) {
            this.rightLeg.rotateAngleX = this.leftLeg.rotateAngleX = -0.3926991f;
        } else {
            this.rightLeg.rotateAngleX = this.leftLeg.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + ((double)limbSwingAmount <= 0.1 && (double)limbSwingAmount >= -0.1 ? 0.0f : 0.5f);
            this.rightArm.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.leftArm.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
    }

    public final void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.rotateAngleX = x;
        modelRenderer.rotateAngleY = y;
        modelRenderer.rotateAngleZ = z;
    }
}

