/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.util.WitcheryUtils;

public class ModelHornedHuntsman
extends ModelBiped {
    public ModelRenderer neck;
    public ModelRenderer moss;
    public ModelRenderer antlerLeft;
    public ModelRenderer antlerRight;
    public ModelRenderer clawsLeft;
    public ModelRenderer clawsRight;
    public ModelRenderer legLeft2;
    public ModelRenderer legRight2;

    public ModelHornedHuntsman() {
        this.textureWidth = 128;
        this.textureHeight = 64;
        this.clawsLeft = new ModelRenderer((ModelBase)this, 54, 22);
        this.clawsLeft.mirror = true;
        this.clawsLeft.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.clawsLeft.addBox(0.0f, 17.0f, -2.5f, 5, 4, 5, 0.0f);
        this.neck = new ModelRenderer((ModelBase)this, 0, 0);
        this.neck.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.neck.addBox(0.0f, 0.0f, 0.0f, 1, 1, 1, 0.0f);
        this.setRotateAngle(this.neck, -0.2617994f, 0.0f, 0.0f);
        this.bipedLeftLeg = new ModelRenderer((ModelBase)this, 34, 46);
        this.bipedLeftLeg.setRotationPoint(3.0f, 16.0f, 0.0f);
        this.bipedLeftLeg.addBox(-2.5f, 0.0f, -2.5f, 5, 10, 5, 0.0f);
        this.setRotateAngle(this.bipedLeftLeg, -0.34906584f, 0.0f, 0.0f);
        this.bipedHead = new ModelRenderer((ModelBase)this, 0, 0);
        this.bipedHead.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedHead.addBox(-4.0f, -7.0f, -10.0f, 8, 8, 14, 0.0f);
        this.setRotateAngle(this.bipedHead, 0.87266463f, 0.0f, 0.0f);
        this.bipedRightLeg = new ModelRenderer((ModelBase)this, 34, 46);
        this.bipedRightLeg.mirror = true;
        this.bipedRightLeg.setRotationPoint(-3.0f, 16.0f, 0.0f);
        this.bipedRightLeg.addBox(-2.5f, 0.0f, -2.5f, 5, 10, 5, 0.0f);
        this.setRotateAngle(this.bipedLeftLeg, -0.34906584f, 0.0f, 0.0f);
        this.antlerRight = new ModelRenderer((ModelBase)this, 45, 0);
        this.antlerRight.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.antlerRight.addBox(-12.0f, -18.0f, 0.0f, 11, 13, 1, 0.0f);
        this.setRotateAngle(this.antlerRight, -0.5009095f, 0.0f, 0.0f);
        this.legRight2 = new ModelRenderer((ModelBase)this, 54, 41);
        this.legRight2.mirror = true;
        this.legRight2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legRight2.addBox(-2.5f, 7.0f, 2.5f, 5, 12, 5, 0.0f);
        this.antlerLeft = new ModelRenderer((ModelBase)this, 45, 0);
        this.antlerLeft.mirror = true;
        this.antlerLeft.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.antlerLeft.addBox(1.0f, -18.0f, 0.0f, 11, 13, 1, 0.0f);
        this.setRotateAngle(this.antlerLeft, -0.5009095f, 0.0f, 0.0f);
        this.legLeft2 = new ModelRenderer((ModelBase)this, 54, 41);
        this.legLeft2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.legLeft2.addBox(-2.5f, 7.0f, 2.5f, 5, 12, 5, 0.0f);
        this.moss = new ModelRenderer((ModelBase)this, 0, 43);
        this.moss.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.moss.addBox(-6.0f, 16.0f, -2.5f, 12, 5, 5, 0.0f);
        this.bipedLeftArm = new ModelRenderer((ModelBase)this, 34, 22);
        this.bipedLeftArm.mirror = true;
        this.bipedLeftArm.setRotationPoint(6.0f, 2.0f, 0.0f);
        this.bipedLeftArm.addBox(0.0f, -2.0f, -2.5f, 5, 19, 5, 0.0f);
        this.clawsRight = new ModelRenderer((ModelBase)this, 54, 22);
        this.clawsRight.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.clawsRight.addBox(-5.0f, 17.0f, -2.5f, 5, 4, 5, 0.0f);
        this.bipedBody = new ModelRenderer((ModelBase)this, 0, 22);
        this.bipedBody.setRotationPoint(0.0f, -11.0f, 0.0f);
        this.bipedBody.addBox(-6.0f, 0.0f, -2.5f, 12, 16, 5, 0.0f);
        this.bipedRightArm = new ModelRenderer((ModelBase)this, 34, 22);
        this.bipedRightArm.setRotationPoint(-6.0f, 2.0f, 0.0f);
        this.bipedRightArm.addBox(-5.0f, -2.0f, -2.5f, 5, 19, 5, 0.0f);
        this.bipedLeftArm.addChild(this.clawsLeft);
        this.bipedBody.addChild(this.neck);
        this.bipedBody.addChild(this.bipedLeftLeg);
        this.neck.addChild(this.bipedHead);
        this.bipedBody.addChild(this.bipedRightLeg);
        this.bipedHead.addChild(this.antlerRight);
        this.bipedRightLeg.addChild(this.legRight2);
        this.bipedHead.addChild(this.antlerLeft);
        this.bipedLeftLeg.addChild(this.legLeft2);
        this.bipedBody.addChild(this.moss);
        this.bipedBody.addChild(this.bipedLeftArm);
        this.bipedRightArm.addChild(this.clawsRight);
        this.bipedBody.addChild(this.bipedRightArm);
    }

    public void render(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.bipedBody.render(scale);
    }

    public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entity) {
        this.bipedHead.rotateAngleX = WitcheryUtils.toRadians(headPitch) + 0.4365f;
        this.bipedHead.rotateAngleY = WitcheryUtils.toRadians(netHeadYaw);
        this.neck.rotateAngleX = -0.2617994f;
        this.neck.rotateAngleY = 0.0f;
        this.bipedLeftLeg.rotateAngleX = this.triangleWave(limbSwing, 13.0f) * limbSwingAmount * -1.3f - 0.34906584f;
        this.bipedRightLeg.rotateAngleX = this.triangleWave(limbSwing, 13.0f) * limbSwingAmount * 1.3f - 0.34906584f;
    }

    public void setLivingAnimations(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float delta) {
        int attackTimer;
        EntityHornedHuntsman huntsman = (EntityHornedHuntsman)entity;
        this.bipedLeftArm.rotateAngleX = this.triangleWave(limbSwing, 13.0f) * limbSwingAmount * -0.3f;
        this.bipedRightArm.rotateAngleX = huntsman.isSwingingArms() ? (float)((double)((attackTimer = huntsman.getAttackTimer()) > 0 ? attackTimer : 10) / -10.0 * Math.PI) : -this.bipedLeftArm.rotateAngleX;
    }

    public void postRenderArm(float scale, EnumHandSide side) {
        ModelRenderer arm = this.getArmForSide(side);
        arm.postRender(scale);
        GlStateManager.translate((double)0.0, (double)(MathHelper.wrapDegrees((double)Math.toDegrees(arm.rotateAngleX)) / 128.571428571), (double)0.0);
    }

    private float triangleWave(float limbSwing, float wave) {
        return (Math.abs(limbSwing % wave - wave * 0.5f) - wave * 0.25f) / (wave * 0.25f);
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.rotateAngleX = x;
        modelRenderer.rotateAngleY = y;
        modelRenderer.rotateAngleZ = z;
    }
}

