/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.entity.monster.EntityHellhound;
import net.msrandom.witchery.util.WitcheryUtils;

public class ModelHellhound
extends ModelBase {
    public ModelRenderer chest;
    public ModelRenderer body;
    public ModelRenderer frontLeftLeg;
    public ModelRenderer frontRightLeg;
    public ModelRenderer head;
    public ModelRenderer fur1;
    public ModelRenderer backLeftLeg;
    public ModelRenderer tail;
    public ModelRenderer backRightLeg;
    public ModelRenderer fur2;
    public ModelRenderer rightEar;
    public ModelRenderer leftEar;
    public ModelRenderer mouth;

    public ModelHellhound() {
        this.textureWidth = 64;
        this.textureHeight = 32;
        this.fur2 = new ModelRenderer((ModelBase)this, 24, 20);
        this.fur2.setRotationPoint(-0.8f, 0.9f, 2.4f);
        this.fur2.addBox(0.0f, -2.0f, 0.0f, 0, 4, 4, 0.0f);
        this.setRotateAngle(this.fur2, -0.43633232f, -0.27925268f, -0.5235988f);
        this.backRightLeg = new ModelRenderer((ModelBase)this, 54, 0);
        this.backRightLeg.mirror = true;
        this.backRightLeg.setRotationPoint(-0.5f, 5.5f, -2.0f);
        this.backRightLeg.addBox(-2.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f);
        this.setRotateAngle(this.backRightLeg, -1.5707964f, 0.0f, 0.0f);
        this.tail = new ModelRenderer((ModelBase)this, 9, 18);
        this.tail.setRotationPoint(0.0f, 6.0f, 1.0f);
        this.tail.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f);
        this.frontRightLeg = new ModelRenderer((ModelBase)this, 54, 0);
        this.frontRightLeg.mirror = true;
        this.frontRightLeg.setRotationPoint(-2.0f, -1.0f, -2.0f);
        this.frontRightLeg.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f);
        this.setRotateAngle(this.frontRightLeg, -1.5707964f, 0.0f, 0.0f);
        this.mouth = new ModelRenderer((ModelBase)this, 0, 11);
        this.mouth.setRotationPoint(0.0f, 0.0f, -1.0f);
        this.mouth.addBox(-1.5f, 0.0f, -4.0f, 3, 3, 4, 0.0f);
        this.backLeftLeg = new ModelRenderer((ModelBase)this, 54, 0);
        this.backLeftLeg.setRotationPoint(0.5f, 5.5f, -2.0f);
        this.backLeftLeg.addBox(0.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f);
        this.setRotateAngle(this.backLeftLeg, -1.5707964f, 0.0f, 0.0f);
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.setRotationPoint(0.0f, -4.4f, 0.5f);
        this.head.addBox(-3.0f, -3.0f, -2.0f, 6, 6, 4, 0.0f);
        this.setRotateAngle(this.head, -1.5707964f, 0.0f, 0.0f);
        this.fur1 = new ModelRenderer((ModelBase)this, 24, 20);
        this.fur1.setRotationPoint(1.6f, -0.5f, 3.0f);
        this.fur1.addBox(0.0f, -1.5f, 0.0f, 0, 4, 4, 0.0f);
        this.setRotateAngle(this.fur1, 0.18203785f, 0.7853982f, 0.0f);
        this.leftEar = new ModelRenderer((ModelBase)this, 16, 14);
        this.leftEar.setRotationPoint(0.9f, -3.0f, -1.0f);
        this.leftEar.addBox(0.0f, -2.0f, 1.0f, 2, 2, 1, 0.0f);
        this.rightEar = new ModelRenderer((ModelBase)this, 16, 14);
        this.rightEar.mirror = true;
        this.rightEar.setRotationPoint(-0.9f, -3.0f, -1.0f);
        this.rightEar.addBox(-2.0f, -2.0f, 1.0f, 2, 2, 1, 0.0f);
        this.chest = new ModelRenderer((ModelBase)this, 23, 0);
        this.chest.setRotationPoint(0.0f, 11.5f, -5.0f);
        this.chest.addBox(-4.0f, -3.0f, -3.0f, 8, 6, 7, 0.0f);
        this.setRotateAngle(this.chest, 1.5707964f, 0.0f, 0.0f);
        this.body = new ModelRenderer((ModelBase)this, 40, 17);
        this.body.setRotationPoint(0.0f, 4.5f, 0.0f);
        this.body.addBox(-3.0f, -2.0f, -3.0f, 6, 9, 6, 0.0f);
        this.frontLeftLeg = new ModelRenderer((ModelBase)this, 54, 0);
        this.frontLeftLeg.setRotationPoint(2.0f, -1.0f, -2.0f);
        this.frontLeftLeg.addBox(-1.0f, 0.0f, -1.0f, 2, 8, 2, 0.0f);
        this.setRotateAngle(this.frontLeftLeg, -1.5707964f, 0.0f, 0.0f);
        this.body.addChild(this.fur2);
        this.body.addChild(this.backRightLeg);
        this.body.addChild(this.tail);
        this.chest.addChild(this.frontRightLeg);
        this.head.addChild(this.mouth);
        this.body.addChild(this.backLeftLeg);
        this.chest.addChild(this.head);
        this.chest.addChild(this.fur1);
        this.head.addChild(this.leftEar);
        this.head.addChild(this.rightEar);
        this.chest.addChild(this.body);
        this.chest.addChild(this.frontLeftLeg);
    }

    public void render(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushMatrix();
        GlStateManager.scale((double)1.1111111111111112, (double)1.1111111111111112, (double)1.1111111111111112);
        this.chest.render(scale);
        GlStateManager.popMatrix();
    }

    public void setLivingAnimations(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTickTime) {
        EntityHellhound hellhound = (EntityHellhound)entity;
        this.setRotateAngle(this.tail, hellhound.isConverting() ? 2.0f : 0.59184116f, 0.0f, 0.0f);
        if (limbSwingAmount > 0.1f) {
            this.tail.rotateAngleX += 1.5f * limbSwingAmount - 0.1f;
        }
        this.backRightLeg.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + -1.5707964f;
        this.frontRightLeg.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + -1.5707964f;
        this.backLeftLeg.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount + -1.5707964f;
        this.frontLeftLeg.rotateAngleX = MathHelper.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount + -1.5707964f;
        this.head.rotateAngleZ = hellhound.getInterestedAngle(partialTickTime) + hellhound.getShakeAngle(partialTickTime, 0.0f);
        this.chest.rotateAngleZ = hellhound.getShakeAngle(partialTickTime, -0.08f);
        this.body.rotateAngleZ = hellhound.getShakeAngle(partialTickTime, -0.16f);
        this.tail.rotateAngleZ = hellhound.getShakeAngle(partialTickTime, -0.2f);
    }

    public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        super.setRotationAngles(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        EntityHellhound hellhound = (EntityHellhound)entityIn;
        this.head.rotateAngleX = WitcheryUtils.toRadians(headPitch) + (hellhound.isConverting() ? 0.15f : 0.0f) - 1.5707964f;
        this.head.rotateAngleY = WitcheryUtils.toRadians(netHeadYaw);
        this.tail.rotateAngleX = ageInTicks;
    }

    public final void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.rotateAngleX = x;
        modelRenderer.rotateAngleY = y;
        modelRenderer.rotateAngleZ = z;
    }
}

