/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity.block;

import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockMirror;
import net.msrandom.witchery.block.entity.TileEntityMirror;
import net.msrandom.witchery.client.model.ModelMirror;

@SideOnly(value=Side.CLIENT)
public class RenderMirror
extends TileEntitySpecialRenderer<TileEntityMirror> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("witchery", "textures/block/mirror.png");
    private static final ResourceLocation TEXTURE2_URL = new ResourceLocation("witchery", "textures/block/mirror2.png");
    final ModelMirror model = new ModelMirror();

    public void render(TileEntityMirror tileEntity, double d, double d1, double d2, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)d), (float)((float)d1), (float)((float)d2));
        this.renderMirror(tileEntity, tileEntity.getWorld(), tileEntity.getPos());
        GlStateManager.popMatrix();
    }

    public void renderMirror(TileEntityMirror te, World world, BlockPos pos) {
        IBlockState meta;
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)0.5f, (float)0.5f, (float)0.5f);
        this.bindTexture(TEXTURE);
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (world != null && (meta = world.getBlockState(pos)).getBlock() != Blocks.AIR) {
            GlStateManager.rotate((float)((EnumFacing)meta.getValue((IProperty)BlockHorizontal.FACING)).getOpposite().getHorizontalAngle(), (float)0.0f, (float)1.0f, (float)0.0f);
            if (!BlockMirror.isBlockTopOfMirror(meta)) {
                GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.translate((float)0.0f, (float)0.1f, (float)0.42f);
        }
        GlStateManager.translate((float)0.0f, (float)-0.1f, (float)0.02f);
        this.model.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (te.men > 0) {
            this.bindTexture(TEXTURE2_URL);
            this.model.backMiddle.render(0.0625f);
        }
        GlStateManager.popMatrix();
    }
}

