/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity.block;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityLeechChest;
import net.msrandom.witchery.client.model.ModelLeechChest;

@SideOnly(value=Side.CLIENT)
public class RenderLeechChest
extends TileEntitySpecialRenderer<TileEntityLeechChest> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("witchery", "textures/block/leechchest.png");
    private final ModelLeechChest model = new ModelLeechChest();

    public void render(TileEntityLeechChest chestEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int i = 0;
        if (chestEntity.hasWorld()) {
            i = chestEntity.getBlockMetadata();
        }
        this.bindTexture(RESOURCE_LOCATION);
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translate((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GlStateManager.scale((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.translate((float)0.5f, (float)0.5f, (float)0.5f);
        float rotation = 0.0f;
        if (i == 2) {
            rotation = 180.0f;
        }
        if (i == 4) {
            rotation = 90.0f;
        }
        if (i == 5) {
            rotation = -90.0f;
        }
        GlStateManager.rotate((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translate((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float f1 = chestEntity.prevLidAngle + (chestEntity.lidAngle - chestEntity.prevLidAngle) * partialTicks;
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        this.model.chestLidBL.rotateAngleX = -(f1 * (float)Math.PI / 2.0f) / 1.5f;
        this.model.chestLidBL.rotateAngleY = f1 * (float)Math.PI / 2.0f / 3.0f;
        this.model.chestLidBL.rotateAngleZ = f1 * (float)Math.PI / 2.0f / 1.5f;
        this.model.chestLidBR.rotateAngleX = -(f1 * (float)Math.PI / 2.0f) / 1.5f;
        this.model.chestLidBR.rotateAngleY = -(f1 * (float)Math.PI / 2.0f) / 3.0f;
        this.model.chestLidBR.rotateAngleZ = -(f1 * (float)Math.PI / 2.0f) / 1.5f;
        this.model.chestLidFL.rotateAngleX = f1 * (float)Math.PI / 2.0f / 1.5f;
        this.model.chestLidFL.rotateAngleY = -(f1 * (float)Math.PI / 2.0f) / 3.0f;
        this.model.chestLidFL.rotateAngleZ = f1 * (float)Math.PI / 2.0f / 1.5f;
        this.model.chestLidFR.rotateAngleX = f1 * (float)Math.PI / 2.0f / 1.5f;
        this.model.chestLidFR.rotateAngleY = f1 * (float)Math.PI / 2.0f / 3.0f;
        this.model.chestLidFR.rotateAngleZ = -(f1 * (float)Math.PI / 2.0f) / 1.5f;
        this.model.renderAll(chestEntity.getPlayers().size());
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

