/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity.block;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrectedClient;
import net.msrandom.witchery.block.BlockGrassper;
import net.msrandom.witchery.block.entity.TileEntityGrassper;
import net.msrandom.witchery.client.model.ModelGrassper;
import net.msrandom.witchery.init.WitcheryBlocks;

@SideOnly(value=Side.CLIENT)
public class RenderGrassper
extends TileEntitySpecialRenderer<TileEntityGrassper> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("witchery", "textures/block/grassper.png");
    final ModelGrassper model = new ModelGrassper();
    private RenderItem renderItems;

    public void render(TileEntityGrassper te, double d, double d1, double d2, float partialTicks, int destroyStage, float alpha) {
        IBlockState state;
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)d), (float)((float)d1), (float)((float)d2));
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)0.5f, (float)0.5f, (float)0.5f);
        this.bindTexture(TEXTURE);
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translate((float)0.0f, (float)-1.0f, (float)0.0f);
        if (te.hasWorld() && (state = te.getWorld().getBlockState(te.getPos())).getBlock() == WitcheryBlocks.GRASSPER) {
            GlStateManager.rotate((float)((EnumFacing)state.getValue((IProperty)BlockGrassper.FACING)).getOpposite().getHorizontalAngle(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.model.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
        float rotational = (float)Minecraft.getSystemTime() / 3000.0f * 300.0f;
        if (te.hasWorld()) {
            EntityItem ei = new EntityItem(te.getWorld());
            ei.hoverStart = 0.0f;
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.pushMatrix();
            GlStateManager.enableRescaleNormal();
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)0.0f);
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)170.0f, (float)170.0f);
            GlStateManager.translate((float)0.0f, (float)0.6f, (float)0.0f);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.scale((float)0.75f, (float)0.75f, (float)0.75f);
            float yShift = -0.15f;
            float zShift = 0.65f;
            float xShift = 0.65f;
            boolean fancy = WitcheryResurrectedClient.INSTANCE.isFancyGraphics();
            for (int i = 0; i < te.getSizeInventory() && i <= 46; ++i) {
                if (te.getStackInSlot(i).isEmpty()) continue;
                ItemStack newStack = te.getStackInSlot(i).copy();
                newStack.setCount(1);
                ei.setItem(newStack);
                GlStateManager.pushMatrix();
                GlStateManager.translate((float)xShift, (float)yShift, (float)zShift);
                if (fancy) {
                    GlStateManager.rotate((float)(rotational / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.renderItems == null) {
                    this.renderItems = Minecraft.getMinecraft().getRenderItem();
                }
                this.renderItems.renderItem(ei.getItem(), ItemCameraTransforms.TransformType.GROUND);
                GlStateManager.popMatrix();
            }
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.popMatrix();
    }
}

