/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity.block;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.msrandom.witchery.block.entity.TileEntityCoffin;
import net.msrandom.witchery.client.renderer.entity.block.model.ModelCoffin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J@\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/msrandom/witchery/client/renderer/entity/block/RenderCoffin;", "Lnet/minecraft/client/renderer/tileentity/TileEntitySpecialRenderer;", "Lnet/msrandom/witchery/block/entity/TileEntityCoffin;", "()V", "bottom", "Lnet/msrandom/witchery/client/renderer/entity/block/model/ModelCoffin;", "head", "render", "", "tile", "x", "", "y", "z", "partialTicks", "", "destroyStage", "", "alpha", "Companion", "WitcheryResurrected"})
public final class RenderCoffin
extends TileEntitySpecialRenderer<TileEntityCoffin> {
    private final ModelCoffin head = new ModelCoffin.Head();
    private final ModelCoffin bottom = new ModelCoffin.Bottom();
    private static final ResourceLocation TEXTURE_HEAD;
    private static final ResourceLocation TEXTURE_HEAD_INSIDE;
    private static final ResourceLocation TEXTURE_BOTTOM;
    private static final ResourceLocation TEXTURE_BOTTOM_INSIDE;
    public static final Companion Companion;

    public void render(@NotNull TileEntityCoffin tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)tile), (String)"tile");
        super.render((TileEntity)tile, x, y, z, partialTicks, destroyStage, alpha);
        GlStateManager.pushMatrix();
        int i = tile.getColor().getColorValue();
        float r = (float)(i >>> 16 & 0xFF) / 255.0f;
        float g = (float)(i >>> 8 & 0xFF) / 255.0f;
        float b = (float)(i & 0xFF) / 255.0f;
        GlStateManager.translate((double)(x + (double)0.5f), (double)(y + (double)1.5f), (double)(z + (double)0.5f));
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (tile.hasWorld()) {
            GlStateManager.rotate((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
            EnumFacing enumFacing = EnumFacing.byHorizontalIndex((int)((tile.getBlockMetadata() & 3) + 1));
            Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"EnumFacing.byHorizontalI\u2026ockMetadata and 0x3) + 1)");
            GlStateManager.rotate((float)enumFacing.getHorizontalAngle(), (float)0.0f, (float)1.0f, (float)0.0f);
            float f2 = 1.0f - (tile.getPrevLidAngle() + (tile.getLidAngle() - tile.getPrevLidAngle()) * partialTicks);
            float angle = (1.0f - f2 * f2 * f2) * (float)Math.PI / 2.0f * -0.9444444f;
            if ((tile.getBlockMetadata() & 8) == 0) {
                this.bottom.lid.rotateAngleZ = angle;
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
                this.bindTexture(TEXTURE_BOTTOM);
                this.bottom.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
                this.bindTexture(TEXTURE_BOTTOM_INSIDE);
                GlStateManager.color((float)r, (float)g, (float)b);
                this.bottom.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            } else {
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
                this.bindTexture(TEXTURE_HEAD);
                this.head.lid.rotateAngleZ = angle;
                this.head.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.color((float)r, (float)g, (float)b);
                this.bindTexture(TEXTURE_HEAD_INSIDE);
                this.head.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
        } else {
            this.head.lid.rotateAngleZ = 2.3562f;
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
            this.bindTexture(TEXTURE_HEAD);
            this.head.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.color((float)r, (float)g, (float)b);
            this.bindTexture(TEXTURE_HEAD_INSIDE);
            this.head.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.translate((double)0.0, (double)0.0, (double)-1.0);
            this.bottom.lid.rotateAngleZ = 2.3562f;
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
            this.bindTexture(TEXTURE_BOTTOM);
            this.bottom.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.color((float)r, (float)g, (float)b);
            this.bindTexture(TEXTURE_BOTTOM_INSIDE);
            this.bottom.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GlStateManager.popMatrix();
    }

    static {
        Companion = new Companion(null);
        TEXTURE_HEAD = new ResourceLocation("witchery", "textures/block/coffin_head.png");
        TEXTURE_HEAD_INSIDE = new ResourceLocation("witchery", "textures/block/coffin_head_inside.png");
        TEXTURE_BOTTOM = new ResourceLocation("witchery", "textures/block/coffin_bottom.png");
        TEXTURE_BOTTOM_INSIDE = new ResourceLocation("witchery", "textures/block/coffin_bottom_inside.png");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lnet/msrandom/witchery/client/renderer/entity/block/RenderCoffin$Companion;", "", "()V", "TEXTURE_BOTTOM", "Lnet/minecraft/util/ResourceLocation;", "TEXTURE_BOTTOM_INSIDE", "TEXTURE_HEAD", "TEXTURE_HEAD_INSIDE", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

