/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity.block;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityBloodCrucible;
import net.msrandom.witchery.client.model.ModelBloodCrucible;

@SideOnly(value=Side.CLIENT)
public class RenderBloodCrucible
extends TileEntitySpecialRenderer<TileEntityBloodCrucible> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("witchery", "textures/block/bloodcrucible.png");
    final ModelBloodCrucible model = new ModelBloodCrucible();

    public void render(TileEntityBloodCrucible crucible, double d, double d1, double d2, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)d), (float)((float)d1), (float)((float)d2));
        GlStateManager.translate((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.translate((float)0.0f, (float)-0.5f, (float)0.0f);
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.bindTexture(TEXTURE);
        this.model.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        float percentFilled = crucible.getPercentFilled();
        if (percentFilled > 0.0f) {
            this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.disableAlpha();
            GlStateManager.color((float)1.0f, (float)0.0f, (float)0.0f, (float)0.9f);
            float w = -0.1875f;
            float depth = percentFilled - 0.3f;
            GlStateManager.translate((float)w, (float)depth, (float)(-w));
            GlStateManager.rotate((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float s = 0.0234375f;
            GlStateManager.scale((float)s, (float)s, (float)s);
            TextureAtlasSprite icon = Minecraft.getMinecraft().getTextureMapBlocks().getTextureExtry("textures/block/blood_still.png");
            if (icon != null) {
                boolean x = false;
                boolean y = false;
                int u = 16;
                int v = 16;
                Tessellator tessellator = Tessellator.getInstance();
                BufferBuilder buffer = tessellator.getBuffer();
                buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
                int j = 0;
                int k = 200;
                buffer.pos((double)x, (double)v, 0.0).tex((double)icon.getMinU(), (double)icon.getMaxV()).lightmap(j, k).endVertex();
                buffer.pos((double)u, (double)v, 0.0).tex((double)icon.getMaxU(), (double)icon.getMaxV()).lightmap(j, k).endVertex();
                buffer.pos((double)u, (double)y, 0.0).tex((double)icon.getMaxU(), (double)icon.getMinV()).lightmap(j, k).endVertex();
                buffer.pos((double)x, (double)y, 0.0).tex((double)icon.getMinU(), (double)icon.getMinV()).lightmap(j, k).endVertex();
                tessellator.draw();
            }
            GlStateManager.enableAlpha();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
    }
}

