/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity.block;

import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityAlluringSkull;

@SideOnly(value=Side.CLIENT)
public class RenderAlluringSkull
extends TileEntitySpecialRenderer<TileEntityAlluringSkull> {
    private static final ResourceLocation TEXTURE_OFF = new ResourceLocation("witchery", "textures/block/alluring_skull.png");
    private static final ResourceLocation TEXTURE_ON = new ResourceLocation("witchery", "textures/block/alluring_skull2.png");
    private final ModelSkeletonHead model = new ModelSkeletonHead(0, 0, 64, 32);

    public void render(TileEntityAlluringSkull te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.bindTexture(te.hasWorld() && (te.getBlockMetadata() & 8) > 0 ? TEXTURE_ON : TEXTURE_OFF);
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        float yaw = (float)(te.getSkullRotation() * 360) / 16.0f;
        if (te.hasWorld()) {
            IBlockState state = te.getWorld().getBlockState(te.getPos());
            EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockDirectional.FACING);
            if (facing != EnumFacing.UP) {
                switch (facing) {
                    case NORTH: {
                        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.25), (double)(z + (double)0.74f));
                        break;
                    }
                    case SOUTH: {
                        GlStateManager.translate((double)(x + 0.5), (double)(y + 0.25), (double)(z + (double)0.26f));
                        yaw = 180.0f;
                        break;
                    }
                    case WEST: {
                        GlStateManager.translate((double)(x + (double)0.74f), (double)(y + 0.25), (double)(z + 0.5));
                        yaw = 270.0f;
                        break;
                    }
                    default: {
                        GlStateManager.translate((double)(x + (double)0.26f), (double)(y + 0.25), (double)(z + 0.5));
                        yaw = 90.0f;
                        break;
                    }
                }
            } else {
                GlStateManager.translate((double)(x + 0.5), (double)y, (double)(z + 0.5));
            }
        }
        float f4 = 0.0625f;
        GlStateManager.enableRescaleNormal();
        GlStateManager.scale((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.enableAlpha();
        this.model.render(null, 0.0f, 0.0f, 0.0f, yaw, 0.0f, f4);
        GlStateManager.popMatrix();
    }
}

