/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntitySpellEffect;
import net.msrandom.witchery.infusion.symbol.ProjectileSymbolEffect;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.util.RenderUtil;
import net.msrandom.witchery.util.WitcheryUtils;

@SideOnly(value=Side.CLIENT)
public class RenderSpellEffect
extends Render<EntitySpellEffect> {
    public RenderSpellEffect(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntitySpellEffect effectEntity, double par2, double par4, double par6, float par8, float par9) {
        GlStateManager.pushMatrix();
        this.bindEntityTexture(effectEntity);
        GlStateManager.translate((float)((float)par2), (float)((float)par4), (float)((float)par6));
        RenderUtil.blend(true);
        ProjectileSymbolEffect effect = (ProjectileSymbolEffect)SymbolEffect.REGISTRY.get(effectEntity.getEffectID());
        int color2 = effect.getColor();
        float scale = effect.getSize() * 0.325f;
        ItemStack stack = new ItemStack(Items.SNOWBALL);
        GlStateManager.scale((float)scale, (float)scale, (float)scale);
        int red = color2 >>> 16 & 0xFF;
        int green = color2 >>> 8 & 0xFF;
        int blue = color2 & 0xFF;
        WitcheryUtils.getOrCreateTag(stack).setInteger("Color", RenderSpellEffect.modifyColor(red) << 16 | RenderSpellEffect.modifyColor(green) << 8 | RenderSpellEffect.modifyColor(blue));
        GlStateManager.rotate((float)(180.0f - this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)(-this.renderManager.playerViewX), (float)1.0f, (float)0.0f, (float)0.0f);
        Minecraft.getMinecraft().getRenderItem().renderItem(stack, ItemCameraTransforms.TransformType.GROUND);
        RenderUtil.blend(false);
        GlStateManager.popMatrix();
    }

    private static int modifyColor(int color2) {
        return (int)((float)color2 + (float)color2 * 0.55f) & 0xFF;
    }

    protected ResourceLocation getEntityTexture(EntitySpellEffect effect) {
        return TextureMap.LOCATION_BLOCKS_TEXTURE;
    }
}

