/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity;

import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.msrandom.witchery.entity.EntitySleepingBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014J8\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u0002H\u0014\u00a8\u0006\u0018"}, d2={"Lnet/msrandom/witchery/client/renderer/entity/RenderSleepingBody;", "Lnet/minecraft/client/renderer/entity/RenderBiped;", "Lnet/msrandom/witchery/entity/EntitySleepingBody;", "renderManager", "Lnet/minecraft/client/renderer/entity/RenderManager;", "(Lnet/minecraft/client/renderer/entity/RenderManager;)V", "applyRotations", "", "entityLiving", "ageInTicks", "", "rotationYaw", "delta", "doRender", "entity", "x", "", "y", "z", "entityYaw", "partialTicks", "getEntityTexture", "Lnet/minecraft/util/ResourceLocation;", "Companion", "WitcheryResurrected"})
public final class RenderSleepingBody
extends RenderBiped<EntitySleepingBody> {
    @NotNull
    private static final AtomicBoolean isRendering;
    public static final Companion Companion;

    public void doRender(@NotNull EntitySleepingBody entity, double x, double y, double z, float entityYaw, float partialTicks) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
        EntityPlayer reflected = entity.getOwner();
        if (reflected == null) {
            super.doRender((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
            return;
        }
        reflected.ticksExisted = entity.ticksExisted;
        reflected.posX = entity.posX;
        reflected.posY = entity.posY;
        reflected.posZ = entity.posZ;
        reflected.prevPosX = reflected.posX;
        reflected.prevPosY = reflected.posY;
        reflected.prevPosZ = reflected.posZ;
        reflected.prevRotationYaw = reflected.rotationYaw;
        reflected.prevRotationPitch = reflected.rotationPitch;
        reflected.prevRotationYawHead = reflected.rotationYawHead;
        reflected.prevRenderYawOffset = reflected.renderYawOffset;
        reflected.isSwingInProgress = false;
        reflected.swingingHand = null;
        reflected.hurtTime = 0;
        reflected.maxHurtTime = 0;
        reflected.deathTime = 0;
        reflected.prevSwingProgress = 0.0f;
        reflected.swingProgress = 0.0f;
        reflected.limbSwing = 0.0f;
        reflected.limbSwingAmount = 0.0f;
        reflected.prevLimbSwingAmount = 0.0f;
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        this.applyRotations(entity, 0.0f, entityYaw, partialTicks);
        GlStateManager.translate((double)(-x), (double)(-y), (double)(-z));
        isRendering.set(true);
        Render render2 = this.renderManager.getEntityRenderObject((Entity)reflected);
        if (render2 != null) {
            render2.doRender((Entity)reflected, x, y, z, entityYaw, partialTicks);
        }
        isRendering.set(false);
        GlStateManager.popMatrix();
    }

    protected void applyRotations(@NotNull EntitySleepingBody entityLiving, float ageInTicks, float rotationYaw, float delta) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entityLiving), (String)"entityLiving");
        GlStateManager.translate((float)0.9f, (float)0.25f, (float)0.0f);
        GlStateManager.rotate((float)this.getDeathMaxRotation((EntityLivingBase)entityLiving), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotate((float)this.getDeathMaxRotation((EntityLivingBase)entityLiving), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)142.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotate((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)180.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        if (entityLiving.deathTime > 0) {
            float f3 = ((float)entityLiving.deathTime + delta - 1.0f) / 20.0f * 1.6f;
            if ((f3 = MathHelper.sqrt((float)f3)) > 1.0f) {
                f3 = 1.0f;
            }
            GlStateManager.rotate((float)(f3 * this.getDeathMaxRotation((EntityLivingBase)entityLiving)), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            String s = TextFormatting.getTextWithoutFormattingCodes((String)entityLiving.getName());
            if (Intrinsics.areEqual((Object)s, (Object)"Dinnerbone") || Intrinsics.areEqual((Object)s, (Object)"Grumm")) {
                GlStateManager.translate((float)0.0f, (float)(entityLiving.height + 0.1f), (float)0.0f);
                GlStateManager.rotate((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@NotNull EntitySleepingBody entity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
        EntityPlayer entityPlayer = entity.getOwner();
        if (!(entityPlayer instanceof AbstractClientPlayer)) {
            entityPlayer = null;
        }
        AbstractClientPlayer abstractClientPlayer = (AbstractClientPlayer)entityPlayer;
        return abstractClientPlayer != null ? abstractClientPlayer.getLocationSkin() : null;
    }

    public RenderSleepingBody(@NotNull RenderManager renderManager) {
        Intrinsics.checkParameterIsNotNull((Object)renderManager, (String)"renderManager");
        super(renderManager, new ModelBiped(0.0f), 0.5f);
    }

    static {
        Companion = new Companion(null);
        isRendering = new AtomicBoolean();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lnet/msrandom/witchery/client/renderer/entity/RenderSleepingBody$Companion;", "", "()V", "isRendering", "Ljava/util/concurrent/atomic/AtomicBoolean;", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "WitcheryResurrected"})
    public static final class Companion {
        @NotNull
        public final AtomicBoolean isRendering() {
            return isRendering;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

