/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.item.EntityBrew;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

@SideOnly(value=Side.CLIENT)
public class RenderBrew
extends RenderSnowball<EntityBrew> {
    public RenderBrew(RenderManager manager) {
        this(manager, WitcheryGeneralItems.SPLASH_BREW_BOTTLE);
    }

    public RenderBrew(RenderManager manager, Item item) {
        super(manager, item, Minecraft.getMinecraft().getRenderItem());
    }

    public void doRender(EntityBrew brew, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.enableRescaleNormal();
        GlStateManager.rotate((float)(-this.renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)((float)(this.renderManager.options.thirdPersonView == 2 ? -1 : 1) * this.renderManager.playerViewX), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotate((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        if (this.renderOutlines) {
            GlStateManager.enableColorMaterial();
            GlStateManager.enableOutlineMode((int)this.getTeamColor((Entity)brew));
        }
        RenderItem itemRenderer = Minecraft.getMinecraft().getRenderItem();
        if (brew.isSpell()) {
            itemRenderer.renderItem(new ItemStack(WitcheryIngredientItems.QUARTZ_SPHERE), ItemCameraTransforms.TransformType.GROUND);
        } else {
            itemRenderer.renderItem(this.getStackToRender(brew), ItemCameraTransforms.TransformType.GROUND);
        }
        if (this.renderOutlines) {
            GlStateManager.disableOutlineMode();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
    }

    public ItemStack getStackToRender(EntityBrew entityIn) {
        return entityIn.getBrew();
    }
}

