/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer.entity;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.item.EntityCrossbowBolt;
import net.msrandom.witchery.init.items.WitcheryBoltItems;

@SideOnly(value=Side.CLIENT)
public class RenderBolt
extends Render<EntityCrossbowBolt> {
    private static final ResourceLocation WOODEN = new ResourceLocation("witchery", "textures/entity/bolt.png");
    private static final ResourceLocation NULLIFYING = new ResourceLocation("witchery", "textures/entity/bolt2.png");
    private static final ResourceLocation BONE = new ResourceLocation("witchery", "textures/entity/bolt3.png");
    private static final ResourceLocation SILVER = new ResourceLocation("witchery", "textures/entity/bolt4.png");

    public RenderBolt(RenderManager renderManager) {
        super(renderManager);
    }

    protected ResourceLocation getEntityTexture(EntityCrossbowBolt bolt) {
        Item item = bolt.getArrowStack().getItem();
        if (item == WitcheryBoltItems.BONE_BOLT) {
            return BONE;
        }
        if (item == WitcheryBoltItems.NULLIFYING_BOLT) {
            return NULLIFYING;
        }
        if (item == WitcheryBoltItems.SILVER_BOLT) {
            return SILVER;
        }
        return WOODEN;
    }

    public void doRender(EntityCrossbowBolt par1EntityArrow, double par2, double par4, double par6, float par8, float par9) {
        this.bindEntityTexture((Entity)par1EntityArrow);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)par2), (float)((float)par4), (float)((float)par6));
        GlStateManager.rotate((float)(par1EntityArrow.prevRotationYaw + (par1EntityArrow.rotationYaw - par1EntityArrow.prevRotationYaw) * par9 - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)(par1EntityArrow.prevRotationPitch + (par1EntityArrow.rotationPitch - par1EntityArrow.prevRotationPitch) * par9), (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        float f2 = 0.0f;
        float f3 = 0.3f;
        float f4 = 0.0f;
        float f5 = 0.15625f;
        float f6 = 0.0f;
        float f7 = 0.15625f;
        float f8 = 0.15625f;
        float f9 = 0.3125f;
        float f10 = 0.05625f;
        GlStateManager.enableRescaleNormal();
        float f11 = (float)par1EntityArrow.arrowShake - par9;
        if (f11 > 0.0f) {
            float f12 = -MathHelper.sin((float)(f11 * 3.0f)) * f11;
            GlStateManager.rotate((float)f12, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.rotate((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scale((float)f10, (float)f10, (float)f10);
        GlStateManager.translate((float)-3.0f, (float)0.0f, (float)0.0f);
        GlStateManager.glNormal3f((float)f10, (float)0.0f, (float)0.0f);
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos(-7.0, -2.0, -2.0).tex((double)f6, (double)f8).endVertex();
        buffer.pos(-7.0, -2.0, 2.0).tex((double)f7, (double)f8).endVertex();
        buffer.pos(-7.0, 2.0, 2.0).tex((double)f7, (double)f9).endVertex();
        buffer.pos(-7.0, 2.0, -2.0).tex((double)f6, (double)f9).endVertex();
        tessellator.draw();
        GlStateManager.glNormal3f((float)(-f10), (float)0.0f, (float)0.0f);
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos(-7.0, 2.0, -2.0).tex((double)f6, (double)f8).endVertex();
        buffer.pos(-7.0, 2.0, 2.0).tex((double)f7, (double)f8).endVertex();
        buffer.pos(-7.0, -2.0, 2.0).tex((double)f7, (double)f9).endVertex();
        buffer.pos(-7.0, -2.0, -2.0).tex((double)f6, (double)f9).endVertex();
        tessellator.draw();
        GlStateManager.translate((float)0.9f, (float)0.0f, (float)0.0f);
        for (int i = 0; i < 4; ++i) {
            GlStateManager.rotate((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.glNormal3f((float)0.0f, (float)0.0f, (float)f10);
            buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            buffer.pos(-8.0, -2.0, 0.0).tex((double)f2, (double)f4).endVertex();
            buffer.pos(8.0, -2.0, 0.0).tex((double)f3, (double)f4).endVertex();
            buffer.pos(8.0, 2.0, 0.0).tex((double)f3, (double)f5).endVertex();
            buffer.pos(-8.0, 2.0, 0.0).tex((double)f2, (double)f5).endVertex();
            tessellator.draw();
        }
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
    }
}

