/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.renderer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.potion.PotionResizing;
import net.msrandom.witchery.util.ReflectiveLambdaGenerator;

@SideOnly(value=Side.CLIENT)
public class ModelOverlayRenderer {
    private static final ReflectiveLambdaGenerator.RotationSetter applyRotations;
    private static final ReflectiveLambdaGenerator.RotationHandler handleRotationFloat;
    private static final ReflectiveLambdaGenerator.RendererCallback preRenderCallback;

    public static void render(EntityLivingBase entity, double x, double y, double z, RenderLivingBase<EntityLivingBase> originalRenderer) {
        ModelBase mainModel = originalRenderer.getMainModel();
        ModelOverlayRenderer.renderModel(entity, x, y, z, originalRenderer, mainModel);
    }

    public static void renderModel(EntityLivingBase entity, double x, double y, double z, RenderLivingBase<EntityLivingBase> originalRenderer, ModelBase model) {
        ModelOverlayRenderer.renderModelAsOverlay(entity, model, x, y, z, Minecraft.getMinecraft().getRenderPartialTicks(), originalRenderer);
    }

    private static void renderModelAsOverlay(EntityLivingBase entity, ModelBase mainModel, double x, double y, double z, float partialRenderTicks, RenderLivingBase<EntityLivingBase> originalRenderer) {
        GlStateManager.pushMatrix();
        mainModel.swingProgress = ModelOverlayRenderer.getSwingProgress(entity, partialRenderTicks);
        mainModel.isRiding = entity.isRiding();
        mainModel.isChild = entity.isChild();
        float f = ModelOverlayRenderer.interpolateRotation(entity.prevRenderYawOffset, entity.renderYawOffset, partialRenderTicks);
        float f1 = ModelOverlayRenderer.interpolateRotation(entity.prevRotationYawHead, entity.rotationYawHead, partialRenderTicks);
        float f2 = f1 - f;
        if (entity.isRiding() && entity.getRidingEntity() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase1 = (EntityLivingBase)entity.getRidingEntity();
            f = ModelOverlayRenderer.interpolateRotation(entitylivingbase1.prevRenderYawOffset, entitylivingbase1.renderYawOffset, partialRenderTicks);
            float f4 = MathHelper.wrapDegrees((float)(f1 - f));
            if (f4 < -85.0f) {
                f4 = -85.0f;
            }
            if (f4 >= 85.0f) {
                f4 = 85.0f;
            }
            f = f1 - f4;
            if (f4 * f4 > 2500.0f) {
                f += f4 * 0.2f;
            }
        }
        float f7 = entity.prevRotationPitch + (entity.rotationPitch - entity.prevRotationPitch) * partialRenderTicks;
        ModelOverlayRenderer.renderLivingAt(entity, x, y, z);
        float f8 = handleRotationFloat.invoke(originalRenderer, entity, partialRenderTicks);
        applyRotations.invoke(originalRenderer, entity, f8, f, partialRenderTicks);
        GlStateManager.enableRescaleNormal();
        GlStateManager.scale((float)-1.0f, (float)-1.0f, (float)1.0f);
        preRenderCallback.invoke(originalRenderer, entity, partialRenderTicks);
        GlStateManager.translate((double)0.0, (double)-1.5078125, (double)0.0);
        float f5 = entity.prevLimbSwingAmount + (entity.limbSwingAmount - entity.prevLimbSwingAmount) * partialRenderTicks;
        float f6 = entity.limbSwing - entity.limbSwingAmount * (1.0f - partialRenderTicks);
        if (entity.isChild()) {
            f6 *= 3.0f;
        }
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        GlStateManager.enableAlpha();
        mainModel.setLivingAnimations(entity, f6, f5, partialRenderTicks);
        mainModel.setRotationAngles(f6, f5, f8, f2, f7, 0.0625f, (Entity)entity);
        GlStateManager.scale((float)1.01f, (float)1.01f, (float)1.01f);
        ModelOverlayRenderer.renderModel(entity, f6, f5, f8, f2, f7, 0.0625f, mainModel);
        GlStateManager.popMatrix();
    }

    private static float interpolateRotation(float par1, float par2, float partialRenderTicks) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + partialRenderTicks * f3;
    }

    private static void renderLivingAt(EntityLivingBase entity, double p_77039_2_, double p_77039_4_, double p_77039_6_) {
        PotionEffect resizing;
        GlStateManager.translate((float)((float)p_77039_2_), (float)((float)p_77039_4_), (float)((float)p_77039_6_));
        if (entity != null && entity.isPotionActive(WitcheryPotionEffects.RESIZING) && (resizing = entity.getActivePotionEffect(WitcheryPotionEffects.RESIZING)) != null) {
            float scale = PotionResizing.getModifiedScaleFactor(entity, resizing.getAmplifier());
            GlStateManager.scale((float)scale, (float)scale, (float)scale);
        }
    }

    private static float getSwingProgress(EntityLivingBase entity, float partialRenderTicks) {
        return entity.getSwingProgress(partialRenderTicks);
    }

    private static void renderModel(EntityLivingBase entity, float p_77036_2_, float p_77036_3_, float p_77036_4_, float p_77036_5_, float p_77036_6_, float p_77036_7_, ModelBase mainModel) {
        if (!entity.isInvisible()) {
            mainModel.render((Entity)entity, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
        } else if (!entity.isInvisibleToPlayer((EntityPlayer)Minecraft.getMinecraft().player)) {
            GlStateManager.pushMatrix();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
            GlStateManager.depthMask((boolean)false);
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.alphaFunc((int)516, (float)0.003921569f);
            mainModel.render((Entity)entity, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
            GlStateManager.disableBlend();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.popMatrix();
            GlStateManager.depthMask((boolean)true);
        } else {
            mainModel.setRotationAngles(p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_, (Entity)entity);
        }
    }

    static {
        ReflectiveLambdaGenerator.RotationSetter applyRotationsMethod = null;
        ReflectiveLambdaGenerator.RotationHandler handleRotationFloatMethod = null;
        ReflectiveLambdaGenerator.RendererCallback preRenderCallbackMethod = null;
        try {
            applyRotationsMethod = ReflectiveLambdaGenerator.getApplyRotationsMethod();
            handleRotationFloatMethod = ReflectiveLambdaGenerator.getHandleRotationMethod();
            preRenderCallbackMethod = ReflectiveLambdaGenerator.getRenderCallbackMethod();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        applyRotations = applyRotationsMethod;
        handleRotationFloat = handleRotationFloatMethod;
        preRenderCallback = preRenderCallbackMethod;
    }
}

