/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.particle;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\r\u0018\u0000 12\u00020\u0001:\u00011B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016JH\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%H\u0016J\u000e\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020%J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u001cH\u0016J\u000e\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020%R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00062"}, d2={"Lnet/msrandom/witchery/client/particle/ParticleNaturePower;", "Lnet/minecraft/client/particle/Particle;", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "(Lnet/minecraft/world/World;DDD)V", "xSpeedIn", "ySpeedIn", "zSpeedIn", "(Lnet/minecraft/world/World;DDDDDD)V", "canMove", "", "getCanMove", "()Z", "setCanMove", "(Z)V", "circling", "getCircling", "setCircling", "speed", "getSpeed", "()D", "setSpeed", "(D)V", "getFXLayer", "", "onUpdate", "", "renderParticle", "buffer", "Lnet/minecraft/client/renderer/BufferBuilder;", "entity", "Lnet/minecraft/entity/Entity;", "partialTicks", "", "par3", "par4", "par5", "par6", "par7", "setGravity", "gravity", "setMaxAge", "maxAge", "setScale", "scale", "Companion", "WitcheryResurrected"})
public final class ParticleNaturePower
extends Particle {
    private boolean canMove;
    private boolean circling;
    private double speed;
    @NotNull
    private static final ResourceLocation TEXTURE;
    public static final Companion Companion;

    public final boolean getCanMove() {
        return this.canMove;
    }

    public final void setCanMove(boolean bl) {
        this.canMove = bl;
    }

    public final boolean getCircling() {
        return this.circling;
    }

    public final void setCircling(boolean bl) {
        this.circling = bl;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    public void renderParticle(@NotNull BufferBuilder buffer, @NotNull Entity entity, float partialTicks, float par3, float par4, float par5, float par6, float par7) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        Minecraft.getMinecraft().renderEngine.bindTexture(TEXTURE);
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.alphaFunc((int)516, (float)0.003921569f);
        int i = this.getBrightnessForRender(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        int typeIndex = 0;
        int par8 = typeIndex + this.particleAge * 8 / 20 % 16;
        par8 = par8 > 7 ? 15 - par8 : par8;
        int particleTextureIndexX = par8 % 16;
        float f6 = (float)particleTextureIndexX / 16.0f;
        float f7 = f6 + 0.0624375f;
        float f8 = 0.0f;
        float f9 = f8 + 0.0624375f;
        float scale = 0.1f * this.particleScale;
        float x = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks - Particle.interpPosX);
        float y = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks - Particle.interpPosY);
        float z = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)partialTicks - Particle.interpPosZ);
        buffer.begin(7, DefaultVertexFormats.PARTICLE_POSITION_TEX_COLOR_LMAP);
        buffer.pos((double)(x - par3 * scale) - (double)(par6 * scale), (double)y - (double)par4 * (double)scale, (double)(z - par5 * scale) - (double)(par7 * scale)).tex((double)f7, (double)f9).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(j, k).endVertex();
        buffer.pos((double)(x - par3 * scale) + (double)par6 * (double)scale, (double)y + (double)par4 * (double)scale, (double)(z - par5 * scale) + (double)par7 * (double)scale).tex((double)f7, 0.0).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(j, k).endVertex();
        buffer.pos((double)(x + par3 * scale) + (double)(par6 * scale), (double)y + (double)par4 * (double)scale, (double)(z + par5 * scale) + (double)(par7 * scale)).tex((double)f6, 0.0).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(j, k).endVertex();
        buffer.pos((double)(x + par3 * scale) - (double)par6 * (double)scale, (double)y - (double)par4 * (double)scale, (double)(z + par5 * scale) - (double)par7 * (double)scale).tex((double)f6, (double)f9).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(j, k).endVertex();
        Tessellator.getInstance().draw();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.alphaFunc((int)516, (float)0.1f);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        int n = this.particleAge;
        this.particleAge = n + 1;
        if (n >= RangesKt.coerceAtMost((int)this.particleMaxAge, (int)600) || this.particleAge < 0) {
            this.setExpired();
        }
        if (!this.isExpired && this.canMove) {
            if (this.circling) {
                Vec3d motion = new Vec3d(this.motionX, this.motionY, this.motionZ).rotateYaw(0.5f);
                this.motionX = motion.x * this.speed * 1.08;
                this.motionY = motion.y * this.speed * 0.85;
                this.motionZ = motion.z * this.speed * 1.08;
            } else {
                this.motionY -= 0.04 * (double)this.particleGravity;
            }
            this.move(this.motionX, this.motionY, this.motionZ);
            if (this.onGround) {
                this.motionX *= (double)0.7f;
                this.motionZ *= (double)0.7f;
            }
        }
    }

    public int getFXLayer() {
        return 3;
    }

    public void setMaxAge(int maxAge) {
        this.particleMaxAge = maxAge;
    }

    public final void setGravity(float gravity) {
        this.particleGravity = gravity;
    }

    public final void setScale(float scale) {
        this.particleScale = scale;
    }

    public ParticleNaturePower(@NotNull World world, double x, double y, double z) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world, x, y, z);
        this.speed = 1.0;
    }

    public ParticleNaturePower(@NotNull World world, double x, double y, double z, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world, x, y, z, xSpeedIn, ySpeedIn, zSpeedIn);
        this.speed = 1.0;
    }

    static {
        Companion = new Companion(null);
        TEXTURE = new ResourceLocation("witchery:textures/particle/power.png");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/msrandom/witchery/client/particle/ParticleNaturePower$Companion;", "", "()V", "TEXTURE", "Lnet/minecraft/util/ResourceLocation;", "getTEXTURE", "()Lnet/minecraft/util/ResourceLocation;", "WitcheryResurrected"})
    public static final class Companion {
        @NotNull
        public final ResourceLocation getTEXTURE() {
            return TEXTURE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

