/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.particle;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.msrandom.witchery.client.particle.ParticleNaturePower;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016JH\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0019J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0019R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lnet/msrandom/witchery/client/particle/ParticleCauldronBubble;", "Lnet/minecraft/client/particle/Particle;", "world", "Lnet/minecraft/world/World;", "x", "", "y", "z", "(Lnet/minecraft/world/World;DDD)V", "canMove", "", "getCanMove", "()Z", "setCanMove", "(Z)V", "getFXLayer", "", "onUpdate", "", "renderParticle", "buffer", "Lnet/minecraft/client/renderer/BufferBuilder;", "entityIn", "Lnet/minecraft/entity/Entity;", "partialTicks", "", "par3", "par4", "par5", "par6", "par7", "setGravity", "gravity", "setMaxAge", "maxAge", "setScale", "scale", "WitcheryResurrected"})
public final class ParticleCauldronBubble
extends Particle {
    private boolean canMove;

    public final boolean getCanMove() {
        return this.canMove;
    }

    public final void setCanMove(boolean bl) {
        this.canMove = bl;
    }

    public void renderParticle(@NotNull BufferBuilder buffer, @NotNull Entity entityIn, float partialTicks, float par3, float par4, float par5, float par6, float par7) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)entityIn, (String)"entityIn");
        Minecraft.getMinecraft().renderEngine.bindTexture(ParticleNaturePower.Companion.getTEXTURE());
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.alphaFunc((int)516, (float)0.003921569f);
        int i = this.getBrightnessForRender(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        int typeIndex = 16;
        int par8 = typeIndex + this.particleAge * 8 / 20 % 16;
        int particleTextureIndexX = par8 % 16;
        int particleTextureIndexY = par8 / 16;
        float f6 = (float)particleTextureIndexX / 16.0f;
        float f7 = f6 + 0.0624375f;
        float f8 = (float)particleTextureIndexY / 16.0f;
        float f9 = f8 + 0.0624375f;
        float scale = 0.1f * this.particleScale;
        float x = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks - Particle.interpPosX);
        float y = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks - Particle.interpPosY);
        float z = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)partialTicks - Particle.interpPosZ);
        buffer.begin(7, DefaultVertexFormats.PARTICLE_POSITION_TEX_COLOR_LMAP);
        buffer.pos((double)(x - par3 * scale) - (double)(par6 * scale), (double)y - (double)par4 * (double)scale, (double)(z - par5 * scale) - (double)(par7 * scale)).tex((double)f7, (double)f9).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(j, k).endVertex();
        buffer.pos((double)(x - par3 * scale) + (double)par6 * (double)scale, (double)y + (double)par4 * (double)scale, (double)(z - par5 * scale) + (double)par7 * (double)scale).tex((double)f7, (double)f8).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(j, k).endVertex();
        buffer.pos((double)(x + par3 * scale) + (double)(par6 * scale), (double)y + (double)par4 * (double)scale, (double)(z + par5 * scale) + (double)(par7 * scale)).tex((double)f6, (double)f8).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(j, k).endVertex();
        buffer.pos((double)(x + par3 * scale) - (double)par6 * (double)scale, (double)y - (double)par4 * (double)scale, (double)(z + par5 * scale) - (double)par7 * (double)scale).tex((double)f6, (double)f9).color(this.particleRed, this.particleGreen, this.particleBlue, 1.0f).lightmap(j, k).endVertex();
        Tessellator.getInstance().draw();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.alphaFunc((int)516, (float)0.1f);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        int n = this.particleAge;
        this.particleAge = n + 1;
        if (n >= RangesKt.coerceAtMost((int)this.particleMaxAge, (int)600) || this.particleAge < 0) {
            this.setExpired();
        }
        if (!this.isExpired && this.canMove) {
            this.motionY -= 0.04 * (double)this.particleGravity;
            this.move(this.motionX, this.motionY, this.motionZ);
            if (this.onGround) {
                this.motionX *= 0.7;
                this.motionZ *= 0.7;
            }
        }
    }

    public int getFXLayer() {
        return 3;
    }

    public void setMaxAge(int maxAge) {
        this.particleMaxAge = maxAge;
    }

    public final void setGravity(float gravity) {
        this.particleGravity = gravity;
    }

    public final void setScale(float scale) {
        this.particleScale = scale;
    }

    public ParticleCauldronBubble(@NotNull World world, double x, double y, double z) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        super(world, x, y, z);
    }
}

