/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.model;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityWingedMonkey;

@SideOnly(value=Side.CLIENT)
public class ModelMonkey
extends ModelBase {
    private final ModelRenderer tail;
    private final ModelRenderer armLeft;
    private final ModelRenderer legRight;
    private final ModelRenderer bodyShoulder;
    private final ModelRenderer body;
    private final ModelRenderer legLeft;
    private final ModelRenderer head;
    private final ModelRenderer armRight;
    private final ModelRenderer wingRight;
    private final ModelRenderer wingLeft;

    public ModelMonkey() {
        this.textureWidth = 64;
        this.textureHeight = 32;
        ModelRenderer headEarRight = new ModelRenderer((ModelBase)this, 18, 14);
        headEarRight.setRotationPoint(0.0f, 0.0f, 0.0f);
        headEarRight.addBox(-4.5f, -2.5f, -1.5f, 2, 3, 1, 0.0f);
        this.tail = new ModelRenderer((ModelBase)this, 18, 23);
        this.tail.addBox(-0.5f, -7.8f, -0.5f, 1, 8, 1, 0.0f);
        this.tail.setRotationPoint(0.0f, 18.5f, 5.3f);
        this.setRotateAngle(this.tail, -0.63739425f, 0.0f, 0.0f);
        this.armRight = new ModelRenderer((ModelBase)this, 0, 19);
        this.armRight.setRotationPoint(-3.5f, 14.0f, 0.0f);
        this.armRight.addBox(-2.0f, -1.1f, -1.0f, 2, 11, 2, 0.0f);
        this.setRotateAngle(this.armRight, -0.18203785f, 0.0f, 0.0f);
        this.legRight = new ModelRenderer((ModelBase)this, 9, 25);
        this.legRight.setRotationPoint(-1.4f, 19.0f, 4.7f);
        this.legRight.addBox(-1.0f, 0.0f, -1.0f, 2, 5, 2, 0.0f);
        this.bodyShoulder = new ModelRenderer((ModelBase)this, 32, 0);
        this.bodyShoulder.setRotationPoint(0.0f, 16.0f, 1.0f);
        this.bodyShoulder.addBox(-3.5f, -3.0f, -3.0f, 7, 5, 7, 0.0f);
        this.setRotateAngle(this.bodyShoulder, 1.5707964f, 0.0f, 0.0f);
        this.wingRight = new ModelRenderer((ModelBase)this, 28, 25);
        this.wingRight.setRotationPoint(-1.0f, 14.0f, 2.5f);
        this.wingRight.addBox(-12.0f, -0.5f, -3.0f, 12, 1, 6, 0.0f);
        this.setRotateAngle(this.wingRight, -0.68294734f, 0.3642502f, 0.5462881f);
        ModelRenderer headEarLeft = new ModelRenderer((ModelBase)this, 18, 14);
        headEarLeft.mirror = true;
        headEarLeft.setRotationPoint(0.0f, 0.0f, 0.0f);
        headEarLeft.addBox(2.5f, -2.5f, -1.5f, 2, 3, 1, 0.0f);
        ModelRenderer headFace = new ModelRenderer((ModelBase)this, 5, 12);
        headFace.setRotationPoint(0.0f, 0.0f, 0.0f);
        headFace.addBox(-2.5f, -3.5f, -3.5f, 5, 5, 1, 0.0f);
        this.body = new ModelRenderer((ModelBase)this, 36, 12);
        this.body.setRotationPoint(0.0f, 15.8f, 2.0f);
        this.body.addBox(-2.5f, -2.0f, -3.0f, 5, 7, 5, 0.0f);
        this.setRotateAngle(this.body, 0.59184116f, 0.0f, 0.0f);
        this.legLeft = new ModelRenderer((ModelBase)this, 9, 25);
        this.legLeft.mirror = true;
        this.legLeft.setRotationPoint(1.4f, 19.0f, 4.7f);
        this.legLeft.addBox(-1.0f, 0.0f, -1.0f, 2, 5, 2, 0.0f);
        this.armLeft = new ModelRenderer((ModelBase)this, 0, 19);
        this.armLeft.mirror = true;
        this.armLeft.setRotationPoint(4.0f, 14.0f, 0.0f);
        this.armLeft.addBox(-0.5f, -1.0f, -1.0f, 2, 11, 2, 0.0f);
        this.setRotateAngle(this.armLeft, -0.18203785f, 0.0f, 0.0f);
        this.wingLeft = new ModelRenderer((ModelBase)this, 28, 25);
        this.wingLeft.mirror = true;
        this.wingLeft.setRotationPoint(1.0f, 14.0f, 2.5f);
        this.wingLeft.addBox(0.0f, -0.5f, -3.0f, 12, 1, 6, 0.0f);
        this.setRotateAngle(this.wingLeft, -0.68294734f, -0.3642502f, -0.5462881f);
        this.head = new ModelRenderer((ModelBase)this, 0, 0);
        this.head.setRotationPoint(0.0f, 12.0f, -1.5f);
        this.head.addBox(-3.0f, -4.0f, -3.0f, 6, 6, 5, 0.0f);
        ModelRenderer headNose = new ModelRenderer((ModelBase)this, 9, 19);
        headNose.setRotationPoint(0.0f, 0.0f, 0.0f);
        headNose.addBox(-2.0f, -1.5f, -4.5f, 4, 3, 1, 0.0f);
        this.head.addChild(headEarRight);
        this.head.addChild(headEarLeft);
        this.head.addChild(headFace);
        this.head.addChild(headNose);
    }

    private void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.rotateAngleX = x;
        modelRenderer.rotateAngleY = y;
        modelRenderer.rotateAngleZ = z;
    }

    private static boolean isLanded(Entity entity) {
        IBlockState block = entity.world.getBlockState(new BlockPos(MathHelper.floor((double)entity.posX), (int)(entity.posY - 0.01), MathHelper.floor((double)entity.posZ)));
        Material material = block.getMaterial();
        return material == Material.LEAVES || material.isSolid();
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        boolean landed;
        EntityWingedMonkey entitybat = (EntityWingedMonkey)entity;
        this.armRight.rotateAngleZ = 0.0f;
        this.armLeft.rotateAngleZ = 0.0f;
        this.legRight.rotateAngleZ = 0.0f;
        this.legLeft.rotateAngleZ = 0.0f;
        boolean bl = landed = entity.motionY == 0.0 && entity.motionX == 0.0 && entity.motionZ == 0.0 && ModelMonkey.isLanded(entity);
        if (landed) {
            this.setRotateAngle(this.wingLeft, -0.68294734f, -0.3642502f, -0.5462881f);
            this.setRotateAngle(this.wingRight, -0.68294734f, 0.3642502f, 0.5462881f);
            this.armLeft.rotateAngleX = -0.18203785f;
            this.armRight.rotateAngleX = -0.18203785f;
            this.legLeft.rotateAngleX = 0.0f;
            this.legRight.rotateAngleX = 0.0f;
            this.wingLeft.rotationPointY = 14.0f;
            this.wingRight.rotationPointY = 14.0f;
        } else {
            this.wingRight.rotateAngleZ = MathHelper.cos((float)(f2 * 0.5f)) * (float)Math.PI * 0.2f * 2.0f + 0.2f;
            this.wingRight.rotateAngleX = 0.0f;
            this.wingRight.rotationPointY = 12.0f;
            this.wingLeft.rotateAngleZ = -this.wingRight.rotateAngleZ;
            this.wingLeft.rotateAngleX = 0.0f;
            this.wingLeft.rotationPointY = 12.0f;
            this.armLeft.rotateAngleX = 0.2f;
            this.armRight.rotateAngleX = 0.2f;
            this.legLeft.rotateAngleX = 0.1f;
            this.legRight.rotateAngleX = 0.1f;
            ModelRenderer armRight = this.armRight;
            armRight.rotateAngleZ += MathHelper.cos((float)(f2 * 0.09f)) * 0.05f + 0.05f;
            ModelRenderer armLeft = this.armLeft;
            armLeft.rotateAngleZ -= MathHelper.cos((float)(f2 * 0.09f)) * 0.05f + 0.05f;
            ModelRenderer armRight2 = this.armRight;
            armRight2.rotateAngleX += MathHelper.sin((float)(f2 * 0.067f)) * 0.05f;
            ModelRenderer armLeft2 = this.armLeft;
            armLeft2.rotateAngleX -= MathHelper.sin((float)(f2 * 0.067f)) * 0.05f;
            ModelRenderer legRight = this.legRight;
            legRight.rotateAngleX += MathHelper.sin((float)(f2 * 0.067f)) * 0.05f;
            ModelRenderer legLeft = this.legLeft;
            legLeft.rotateAngleX -= MathHelper.sin((float)(f2 * 0.067f)) * 0.05f;
        }
        if (entitybat.isSitting()) {
            this.legRight.rotateAngleX = -1.3f;
            this.legRight.rotationPointZ = 2.0f;
            this.legRight.rotationPointY = 21.0f;
            this.legLeft.rotateAngleX = -1.3f;
            this.legLeft.rotationPointZ = 2.0f;
            this.legLeft.rotationPointY = 21.0f;
            this.body.rotateAngleX = 0.1f;
            this.body.rotationPointY = 17.0f;
            this.tail.setRotationPoint(0.0f, 18.5f, 5.3f);
            this.tail.rotationPointZ = 4.0f;
            this.tail.rotationPointY = 20.0f;
            this.setRotateAngle(this.tail, -0.9f, 0.0f, 0.0f);
            this.armRight.rotateAngleZ += MathHelper.cos((float)(f2 * 0.09f)) * 0.05f + 0.05f;
            this.armLeft.rotateAngleZ -= MathHelper.cos((float)(f2 * 0.09f)) * 0.05f + 0.05f;
            this.armRight.rotateAngleX += MathHelper.sin((float)(f2 * 0.067f)) * 0.05f;
            this.armLeft.rotateAngleX -= MathHelper.sin((float)(f2 * 0.067f)) * 0.05f;
            if (!landed) {
                this.legRight.rotateAngleX = 0.0f;
                this.legLeft.rotateAngleX = 0.0f;
            }
        } else {
            this.body.rotateAngleX = 0.59184116f;
            this.body.setRotationPoint(0.0f, 15.8f, 2.0f);
            this.legRight.setRotationPoint(-1.4f, 19.0f, 4.7f);
            this.legLeft.setRotationPoint(1.4f, 19.0f, 4.7f);
            this.legRight.rotateAngleX = 0.0f;
            this.legLeft.rotateAngleX = 0.0f;
            this.tail.setRotationPoint(0.0f, 18.5f, 5.3f);
            this.setRotateAngle(this.tail, -0.63739425f, 0.0f, 0.0f);
        }
        if ((double)f1 > 0.1) {
            ModelRenderer tail = this.tail;
            tail.rotateAngleX += (float)((double)(-f1) - 0.1);
            ModelRenderer tail2 = this.tail;
            tail2.rotateAngleZ += 5.0f * MathHelper.cos((float)(f2 * 0.09f)) * 0.05f + 0.05f;
        } else {
            this.tail.rotateAngleZ += 3.0f * MathHelper.cos((float)(f2 * 0.09f)) * 0.05f + 0.05f;
        }
        this.head.rotateAngleY = f3 / 57.295776f;
        this.head.rotateAngleX = f4 / 57.295776f;
        int i = entitybat.getAttackTimer();
        if (i > 0) {
            float di = 10.0f;
            this.armRight.rotateAngleX = -2.0f + 1.5f * (Math.abs(((float)i - f3) % 10.0f - di * 0.5f) - di * 0.25f) / (di * 0.25f);
        }
        this.tail.render(f5);
        this.armRight.render(f5);
        this.legRight.render(f5);
        this.bodyShoulder.render(f5);
        this.wingRight.render(f5);
        this.body.render(f5);
        this.legLeft.render(f5);
        this.armLeft.render(f5);
        this.wingLeft.render(f5);
        this.head.render(f5);
    }
}

