/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityKettle;

@SideOnly(value=Side.CLIENT)
public class ModelKettle
extends ModelBase {
    final ModelRenderer sideFront;
    final ModelRenderer sideBack;
    final ModelRenderer sideLeft;
    final ModelRenderer sideRight;
    final ModelRenderer sideBottom;
    final ModelRenderer crossbar;
    final ModelRenderer[] liquid;
    final ModelRenderer chainLF;
    final ModelRenderer chainLB;
    final ModelRenderer chainRF;
    final ModelRenderer chainRB;
    final ModelRenderer bottle1;
    final ModelRenderer bottle2;
    private int ticks;

    public ModelKettle() {
        this.textureWidth = 64;
        this.textureHeight = 64;
        this.setTextureOffset("bottle1.bottle1Body", 52, 5);
        this.setTextureOffset("bottle1.bottle1Neck", 60, 3);
        this.setTextureOffset("bottle1.bottle1Top", 56, 0);
        this.setTextureOffset("bottle2.bottle2Body", 52, 5);
        this.setTextureOffset("bottle2.bottle2Neck", 60, 3);
        this.setTextureOffset("bottle2.bottle2Top", 56, 0);
        this.sideFront = new ModelRenderer((ModelBase)this, 0, 0);
        this.sideFront.addBox(0.0f, 0.0f, 0.0f, 9, 6, 1);
        this.sideFront.setRotationPoint(-5.0f, 18.0f, -5.0f);
        this.sideFront.setTextureSize(64, 64);
        this.sideFront.mirror = true;
        this.setRotation(this.sideFront, 0.0f, 0.0f);
        this.sideBack = new ModelRenderer((ModelBase)this, 0, 0);
        this.sideBack.addBox(0.0f, 0.0f, 0.0f, 9, 6, 1);
        this.sideBack.setRotationPoint(-4.0f, 18.0f, 4.0f);
        this.sideBack.setTextureSize(64, 64);
        this.sideBack.mirror = true;
        this.setRotation(this.sideBack, 0.0f, 0.0f);
        this.sideLeft = new ModelRenderer((ModelBase)this, 0, 0);
        this.sideLeft.addBox(0.0f, 0.0f, 0.0f, 9, 6, 1);
        this.sideLeft.setRotationPoint(-5.0f, 18.0f, 5.0f);
        this.sideLeft.setTextureSize(64, 64);
        this.sideLeft.mirror = true;
        this.setRotation(this.sideLeft, 1.570796f, 0.0f);
        this.sideRight = new ModelRenderer((ModelBase)this, 0, 0);
        this.sideRight.addBox(0.0f, 0.0f, 0.0f, 9, 6, 1);
        this.sideRight.setRotationPoint(4.0f, 18.0f, 4.0f);
        this.sideRight.setTextureSize(64, 64);
        this.sideRight.mirror = true;
        this.setRotation(this.sideRight, 1.570796f, 0.0f);
        this.sideBottom = new ModelRenderer((ModelBase)this, 13, 0);
        this.sideBottom.addBox(0.0f, 0.0f, 0.0f, 8, 1, 8);
        this.sideBottom.setRotationPoint(-4.0f, 23.0f, -4.0f);
        this.sideBottom.setTextureSize(64, 64);
        this.sideBottom.mirror = true;
        this.setRotation(this.sideBottom, 0.0f, 0.0f);
        this.crossbar = new ModelRenderer((ModelBase)this, 0, 10);
        this.crossbar.addBox(-4.0f, 0.0f, 0.0f, 24, 2, 2);
        this.crossbar.setRotationPoint(-8.0f, 8.05f, -1.0f);
        this.crossbar.setTextureSize(64, 64);
        this.crossbar.mirror = true;
        this.setRotation(this.crossbar, 0.0f, 0.0f);
        this.liquid = new ModelRenderer[8];
        for (int i = 0; i < this.liquid.length; ++i) {
            this.liquid[i] = new ModelRenderer((ModelBase)this, i < 4 ? i * 16 - 8 : (i - 4) * 16 - 8, i < 4 ? 16 : 32);
            this.liquid[i].addBox(0.0f, 0.0f, 0.0f, 8, 0, 8);
            this.liquid[i].setRotationPoint(-4.0f, 20.0f, -4.0f);
            this.liquid[i].setTextureSize(64, 64);
            this.liquid[i].mirror = true;
            this.setRotation(this.liquid[i], 0.0f, 0.0f);
        }
        this.chainLF = new ModelRenderer((ModelBase)this, 0, 15);
        this.chainLF.addBox(0.0f, -0.5f, 0.0f, 11, 1, 0);
        this.chainLF.setRotationPoint(0.0f, 9.0f, 0.0f);
        this.chainLF.setTextureSize(64, 64);
        this.chainLF.mirror = true;
        this.chainLB = new ModelRenderer((ModelBase)this, 0, 15);
        this.chainLB.addBox(0.0f, -0.5f, 0.0f, 11, 1, 0);
        this.chainLB.setRotationPoint(0.0f, 9.0f, 0.0f);
        this.chainLB.setTextureSize(64, 64);
        this.chainLB.mirror = true;
        this.chainRF = new ModelRenderer((ModelBase)this, 0, 15);
        this.chainRF.addBox(0.0f, -0.5f, 0.0f, 11, 1, 0);
        this.chainRF.setRotationPoint(0.0f, 9.0f, 0.0f);
        this.chainRF.setTextureSize(64, 64);
        this.chainRF.mirror = true;
        this.chainRB = new ModelRenderer((ModelBase)this, 0, 15);
        this.chainRB.addBox(0.0f, -0.5f, 0.0f, 11, 1, 0);
        this.chainRB.setRotationPoint(0.0f, 9.0f, 0.0f);
        this.chainRB.setTextureSize(64, 64);
        this.chainRB.mirror = true;
        this.chainRB.mirror = false;
        this.setRotation(this.chainRB, -0.4f, 1.1f);
        this.setRotation(this.chainLB, 0.4f, 1.1f);
        this.setRotation(this.chainRF, 0.4f, 2.05f);
        this.setRotation(this.chainLF, -2.75f, -1.1f);
        this.bottle1 = new ModelRenderer((ModelBase)this, "bottle1");
        this.bottle1.setRotationPoint(-4.0f, 13.0f, -6.0f);
        this.setRotation(this.bottle1, 0.0f, 0.0f);
        this.bottle1.mirror = true;
        this.bottle1.addBox("bottle1Body", 0.0f, 2.0f, 0.0f, 3, 3, 3);
        this.bottle1.addBox("bottle1Neck", 1.0f, 1.0f, 1.0f, 1, 1, 1);
        this.bottle1.addBox("bottle1Top", 0.5f, 0.0f, 0.5f, 2, 1, 2);
        this.bottle2 = new ModelRenderer((ModelBase)this, "bottle2");
        this.bottle2.setRotationPoint(0.0f, 13.0f, -6.0f);
        this.setRotation(this.bottle2, 0.0f, 0.0f);
        this.bottle2.mirror = true;
        this.bottle2.addBox("bottle2Body", 0.0f, 2.0f, 0.0f, 3, 3, 3);
        this.bottle2.addBox("bottle2Neck", 1.0f, 1.0f, 1.0f, 1, 1, 1);
        this.bottle2.addBox("bottle2Top", 0.5f, 0.0f, 0.5f, 2, 1, 2);
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5, TileEntityKettle kettleTileEntity) {
        super.render(entity, f, f1, f2, f3, f4, f5);
        this.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
        this.sideFront.render(f5);
        this.sideBack.render(f5);
        this.sideLeft.render(f5);
        this.sideRight.render(f5);
        this.sideBottom.render(f5);
        if (kettleTileEntity != null) {
            if (kettleTileEntity.hasWorld() && !kettleTileEntity.getWorld().getBlockState(kettleTileEntity.getPos().up()).getMaterial().isSolid()) {
                this.crossbar.render(f5);
            }
            this.chainLF.render(f5);
            this.chainLB.render(f5);
            this.chainRF.render(f5);
            this.chainRB.render(f5);
            int bottles = kettleTileEntity.bottleCount();
            if (bottles > 0) {
                this.bottle1.render(f5);
                if (bottles > 1) {
                    this.bottle2.render(f5);
                }
            }
            this.setRotation(this.chainRB, -0.4f, 1.1f);
            this.setRotation(this.chainLB, 0.4f, 1.1f);
            this.setRotation(this.chainRF, 0.4f, 2.05f);
            this.setRotation(this.chainLF, -2.75f, -1.1f);
            if (kettleTileEntity.isFilled()) {
                if (this.ticks >= 79) {
                    this.ticks = 0;
                }
                ++this.ticks;
                int color2 = 0;
                float factor = 1.0f;
                if (kettleTileEntity.isRuined()) {
                    color2 = 8347392;
                    GlStateManager.color((float)1.0f, (float)0.5f, (float)0.2f, (float)0.5f);
                } else if (kettleTileEntity.isReady()) {
                    color2 = kettleTileEntity.getLiquidColor();
                } else if (kettleTileEntity.isBrewing()) {
                    color2 = kettleTileEntity.getLiquidColor();
                    factor = 0.5f;
                }
                if (color2 == 0) {
                    color2 = -13148989;
                    factor = 1.0f;
                }
                float red = (float)(color2 >>> 16 & 0xFF) / 256.0f * factor;
                float green = (float)(color2 >>> 8 & 0xFF) / 256.0f * factor;
                float blue = (float)(color2 & 0xFF) / 256.0f * factor;
                GlStateManager.color((float)red, (float)green, (float)blue, (float)1.0f);
                this.liquid[(int)Math.floor((float)this.ticks / 20.0f)].render(f5);
            }
        }
    }

    private void setRotation(ModelRenderer model, float y, float z) {
        model.rotateAngleX = 0.0f;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
        super.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
    }
}

