/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.msrandom.witchery.entity.EntityGoblinGulg;

public class ModelGoblinGulg
extends ModelBase {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public final ModelRenderer bipedBody;
    public final ModelRenderer bipedRightArm;
    public final ModelRenderer bipedLeftArm;
    public final ModelRenderer bipedRightLeg;
    public final ModelRenderer bipedLeftLeg;
    public final ModelRenderer bipedHead;
    public final ModelRenderer bipedChest;
    public int heldItemLeft;
    public int heldItemRight;
    public boolean isSneak;
    public boolean aimedBow;

    public ModelGoblinGulg() {
        this.textureWidth = 64;
        this.textureHeight = 64;
        this.setTextureOffset("bipedHead.face", 0, 0);
        this.setTextureOffset("bipedHead.tuskright", 0, 4);
        this.setTextureOffset("bipedHead.tuskleft", 0, 4);
        this.setTextureOffset("bipedHead.nose", 25, 0);
        this.setTextureOffset("bipedHead.lip", 34, 0);
        this.bipedBody = new ModelRenderer((ModelBase)this, 16, 16);
        this.bipedBody.addBox(-4.0f, 0.0f, -2.0f, 8, 4, 4);
        this.bipedBody.setRotationPoint(0.0f, 8.0f, 0.0f);
        this.bipedBody.setTextureSize(64, 64);
        this.bipedBody.mirror = true;
        this.setRotation(this.bipedBody);
        this.bipedRightArm = new ModelRenderer((ModelBase)this, 40, 14);
        this.bipedRightArm.addBox(-3.0f, -2.0f, -2.0f, 4, 16, 4);
        this.bipedRightArm.setRotationPoint(-6.0f, 2.0f, 0.0f);
        this.bipedRightArm.setTextureSize(64, 64);
        this.bipedRightArm.mirror = true;
        this.setRotation(this.bipedRightArm);
        this.bipedLeftArm = new ModelRenderer((ModelBase)this, 40, 14);
        this.bipedLeftArm.addBox(0.0f, -2.0f, -2.0f, 4, 16, 4);
        this.bipedLeftArm.setRotationPoint(5.0f, 2.0f, 0.0f);
        this.bipedLeftArm.setTextureSize(64, 64);
        this.bipedLeftArm.mirror = true;
        this.setRotation(this.bipedLeftArm);
        this.bipedRightLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedRightLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.bipedRightLeg.setRotationPoint(-2.0f, 12.0f, 0.0f);
        this.bipedRightLeg.setTextureSize(64, 64);
        this.bipedRightLeg.mirror = true;
        this.setRotation(this.bipedRightLeg);
        this.bipedLeftLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedLeftLeg.addBox(-2.0f, 0.0f, -2.0f, 4, 12, 4);
        this.bipedLeftLeg.setRotationPoint(2.0f, 12.0f, 0.0f);
        this.bipedLeftLeg.setTextureSize(64, 64);
        this.bipedLeftLeg.mirror = true;
        this.setRotation(this.bipedLeftLeg);
        this.bipedHead = new ModelRenderer((ModelBase)this, "bipedHead");
        this.bipedHead.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.setRotation(this.bipedHead);
        this.bipedHead.mirror = true;
        this.bipedHead.addBox("face", -4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.bipedHead.addBox("tuskright", -2.0f, -4.0f, -5.0f, 1, 2, 1);
        this.bipedHead.addBox("tuskleft", 1.0f, -4.0f, -5.0f, 1, 2, 1);
        this.bipedHead.addBox("nose", -1.0f, -6.0f, -6.0f, 2, 3, 2);
        this.bipedHead.addBox("lip", -2.0f, -2.0f, -6.0f, 4, 1, 2);
        this.bipedChest = new ModelRenderer((ModelBase)this, 12, 35);
        this.bipedChest.addBox(-5.0f, 0.0f, -3.0f, 10, 8, 6);
        this.bipedChest.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bipedChest.setTextureSize(64, 64);
        this.bipedChest.mirror = true;
        this.setRotation(this.bipedChest);
    }

    private void setRotation(ModelRenderer model) {
        model.rotateAngleX = 0.0f;
        model.rotateAngleY = 0.0f;
        model.rotateAngleZ = 0.0f;
    }

    public void render(Entity entity, float par2, float par3, float par4, float par5, float par6, float par7) {
        this.setRotationAngles(par2, par3, par4, par5, par6, par7, entity);
        this.doRender(par7);
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.gameSettings.fancyGraphics) {
            float f9 = entity.ticksExisted;
            mc.renderEngine.bindTexture(RES_ITEM_GLINT);
            GlStateManager.enableBlend();
            float f10 = 0.5f;
            GlStateManager.color((float)f10, (float)f10, (float)f10, (float)1.0f);
            GlStateManager.depthFunc((int)514);
            GlStateManager.depthMask((boolean)false);
            for (int k = 0; k < 2; ++k) {
                GlStateManager.disableLighting();
                float f11 = 0.76f;
                GlStateManager.color((float)(0.2f * f11), (float)(0.7f * f11), (float)(0.7f * f11), (float)1.0f);
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                GlStateManager.matrixMode((int)5890);
                GlStateManager.loadIdentity();
                float f12 = f9 * (0.001f + (float)k * 0.003f) * 20.0f;
                float f13 = 0.33333334f;
                GlStateManager.scale((float)f13, (float)f13, (float)f13);
                GlStateManager.rotate((float)(30.0f - (float)k * 60.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.translate((float)0.0f, (float)f12, (float)0.0f);
                GlStateManager.matrixMode((int)5888);
                this.doRender(par7);
            }
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.depthMask((boolean)true);
            GlStateManager.loadIdentity();
            GlStateManager.matrixMode((int)5888);
            GlStateManager.enableLighting();
            GlStateManager.disableBlend();
            GlStateManager.depthFunc((int)515);
        }
    }

    private void doRender(float par7) {
        if (this.isChild) {
            float f6 = 2.0f;
            GlStateManager.pushMatrix();
            GlStateManager.scale((float)(1.5f / f6), (float)(1.5f / f6), (float)(1.5f / f6));
            GlStateManager.translate((float)0.0f, (float)(16.0f * par7), (float)0.0f);
            this.bipedHead.render(par7);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.scale((float)(1.0f / f6), (float)(1.0f / f6), (float)(1.0f / f6));
            GlStateManager.translate((float)0.0f, (float)(24.0f * par7), (float)0.0f);
            this.bipedBody.render(par7);
            this.bipedChest.render(par7);
            this.bipedRightArm.render(par7);
            this.bipedLeftArm.render(par7);
            this.bipedRightLeg.render(par7);
            this.bipedLeftLeg.render(par7);
            GlStateManager.popMatrix();
        } else {
            this.bipedHead.render(par7);
            this.bipedChest.render(par7);
            this.bipedBody.render(par7);
            this.bipedRightArm.render(par7);
            this.bipedLeftArm.render(par7);
            this.bipedRightLeg.render(par7);
            this.bipedLeftLeg.render(par7);
        }
    }

    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, Entity entity) {
        EntityGoblinGulg entityDemon;
        int i;
        this.bipedHead.rotateAngleY = par4 / 57.295776f;
        this.bipedHead.rotateAngleX = par5 / 57.295776f;
        this.bipedRightArm.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f + (float)Math.PI)) * 2.0f * par2 * 0.5f;
        this.bipedLeftArm.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f)) * 2.0f * par2 * 0.5f;
        this.bipedRightArm.rotateAngleZ = 0.0f;
        this.bipedLeftArm.rotateAngleZ = 0.0f;
        this.bipedRightLeg.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f)) * 1.4f * par2;
        this.bipedLeftLeg.rotateAngleX = MathHelper.cos((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
        this.bipedRightLeg.rotateAngleY = 0.0f;
        this.bipedLeftLeg.rotateAngleY = 0.0f;
        if (this.isRiding) {
            ModelRenderer bipedRightArm = this.bipedRightArm;
            bipedRightArm.rotateAngleX -= 0.62831855f;
            ModelRenderer bipedLeftArm = this.bipedLeftArm;
            bipedLeftArm.rotateAngleX -= 0.62831855f;
            this.bipedRightLeg.rotateAngleX = -1.2566371f;
            this.bipedLeftLeg.rotateAngleX = -1.2566371f;
            this.bipedRightLeg.rotateAngleY = 0.31415927f;
            this.bipedLeftLeg.rotateAngleY = -0.31415927f;
        }
        if (this.heldItemLeft != 0) {
            this.bipedLeftArm.rotateAngleX = this.bipedLeftArm.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemLeft;
        }
        if (this.heldItemRight != 0) {
            this.bipedRightArm.rotateAngleX = this.bipedRightArm.rotateAngleX * 0.5f - 0.31415927f * (float)this.heldItemRight;
        }
        this.bipedRightArm.rotateAngleY = 0.0f;
        this.bipedLeftArm.rotateAngleY = 0.0f;
        if (this.swingProgress > -9990.0f) {
            float f6 = this.swingProgress;
            this.bipedBody.rotateAngleY = MathHelper.sin((float)(MathHelper.sqrt((float)f6) * (float)Math.PI * 2.0f)) * 0.2f;
            this.bipedRightArm.rotationPointZ = MathHelper.sin((float)this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedRightArm.rotationPointX = -MathHelper.cos((float)this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedLeftArm.rotationPointZ = -MathHelper.sin((float)this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedLeftArm.rotationPointX = MathHelper.cos((float)this.bipedBody.rotateAngleY) * 5.0f;
            this.bipedRightArm.rotateAngleY += this.bipedBody.rotateAngleY;
            this.bipedLeftArm.rotateAngleY += this.bipedBody.rotateAngleY;
            this.bipedLeftArm.rotateAngleX += this.bipedBody.rotateAngleY;
            f6 = 1.0f - this.swingProgress;
            f6 *= f6;
            f6 *= f6;
            f6 = 1.0f - f6;
            float f7 = MathHelper.sin((float)(f6 * (float)Math.PI));
            float f8 = MathHelper.sin((float)(this.swingProgress * (float)Math.PI)) * -(this.bipedHead.rotateAngleX - 0.7f) * 0.75f;
            this.bipedRightArm.rotateAngleX -= (float)((double)f7 * 1.2 + (double)f8);
            this.bipedRightArm.rotateAngleY += this.bipedBody.rotateAngleY * 2.0f;
            this.bipedRightArm.rotateAngleZ = MathHelper.sin((float)(this.swingProgress * (float)Math.PI)) * -0.4f;
        }
        if (this.isSneak) {
            this.bipedBody.rotateAngleX = 0.5f;
            this.bipedRightArm.rotateAngleX += 0.4f;
            this.bipedLeftArm.rotateAngleX += 0.4f;
            this.bipedRightLeg.rotationPointZ = 4.0f;
            this.bipedLeftLeg.rotationPointZ = 4.0f;
            this.bipedRightLeg.rotationPointY = 9.0f;
            this.bipedLeftLeg.rotationPointY = 9.0f;
            this.bipedHead.rotationPointY = 1.0f;
        } else {
            this.bipedBody.rotateAngleX = 0.0f;
            this.bipedRightLeg.rotationPointZ = 0.1f;
            this.bipedLeftLeg.rotationPointZ = 0.1f;
            this.bipedRightLeg.rotationPointY = 12.0f;
            this.bipedLeftLeg.rotationPointY = 12.0f;
            this.bipedHead.rotationPointY = 0.0f;
        }
        this.bipedRightArm.rotateAngleZ += MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.rotateAngleZ -= MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.rotateAngleX += MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
        this.bipedLeftArm.rotateAngleX -= MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
        if (this.aimedBow) {
            float f6 = 0.0f;
            float f7 = 0.0f;
            this.bipedRightArm.rotateAngleZ = 0.0f;
            this.bipedLeftArm.rotateAngleZ = 0.0f;
            this.bipedRightArm.rotateAngleY = -(0.1f - f6 * 0.6f) + this.bipedHead.rotateAngleY;
            this.bipedLeftArm.rotateAngleY = 0.1f - f6 * 0.6f + this.bipedHead.rotateAngleY + 0.4f;
            this.bipedRightArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
            this.bipedLeftArm.rotateAngleX = -1.5707964f + this.bipedHead.rotateAngleX;
            this.bipedRightArm.rotateAngleX -= f6 * 1.2f - f7 * 0.4f;
            this.bipedLeftArm.rotateAngleX -= f6 * 1.2f - f7 * 0.4f;
            this.bipedRightArm.rotateAngleZ += MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
            this.bipedLeftArm.rotateAngleZ -= MathHelper.cos((float)(par3 * 0.09f)) * 0.05f + 0.05f;
            this.bipedRightArm.rotateAngleX += MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
            this.bipedLeftArm.rotateAngleX -= MathHelper.sin((float)(par3 * 0.067f)) * 0.05f;
        }
        if ((i = (entityDemon = (EntityGoblinGulg)entity).getAttackTimer()) > 0) {
            this.bipedRightArm.rotateAngleX = -2.0f + 1.5f * this.triangleWave((float)i - par4);
        }
    }

    private float triangleWave(float par1) {
        return (Math.abs(par1 % 10.0f - 5.0f) - 2.5f) / 2.5f;
    }
}

