/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.gui.inventory;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityWitchesOven;
import net.msrandom.witchery.inventory.ContainerWitchesOven;

@SideOnly(value=Side.CLIENT)
public class GuiWitchesOven
extends GuiContainer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("witchery", "textures/gui/witches_oven.png");
    private final TileEntityWitchesOven inventory;

    public GuiWitchesOven(ContainerWitchesOven container) {
        super((Container)container);
        this.inventory = container.oven;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        String s = this.inventory != null ? (this.inventory.hasCustomName() ? this.inventory.getName() : I18n.format((String)this.inventory.getName(), (Object[])new Object[0])) : "";
        this.fontRenderer.drawString(s, this.xSize / 2 - this.fontRenderer.getStringWidth(s) / 2, 6, 0x404040);
        this.fontRenderer.drawString(I18n.format((String)"container.inventory", (Object[])new Object[0]), 8, this.ySize - 96 + 2, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(TEXTURE);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        if (this.inventory != null) {
            int i1;
            if (this.inventory.isBurning()) {
                i1 = this.inventory.getBurnTimeRemainingScaled(12);
                this.drawTexturedModalRect(k + 56, l + 36 + 12 - i1, 176, 12 - i1, 14, i1 + 2);
            }
            i1 = this.inventory.getCookProgressScaled(24);
            this.drawTexturedModalRect(k + 79, l + 34, 176, 14, i1 + 1, 16);
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
    }
}

