/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.gui.inventory;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntitySpinningWheel;
import net.msrandom.witchery.inventory.ContainerSpinningWheel;

@SideOnly(value=Side.CLIENT)
public class GuiSpinningWheel
extends GuiContainer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("witchery", "textures/gui/spinning_wheel.png");
    private final TileEntitySpinningWheel spinningWheel;

    public GuiSpinningWheel(ContainerSpinningWheel container) {
        super((Container)container);
        this.spinningWheel = container.spinningWheel;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        String s = this.spinningWheel.hasCustomName() ? this.spinningWheel.getName() : I18n.format((String)this.spinningWheel.getName(), (Object[])new Object[0]);
        this.fontRenderer.drawString(s, this.xSize / 2 - this.fontRenderer.getStringWidth(s) / 2, 6, 0x404040);
        this.fontRenderer.drawString(I18n.format((String)"container.inventory", (Object[])new Object[0]), 8, this.ySize - 96 + 2, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(TEXTURE);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        if (this.spinningWheel.powerLevel <= 0) {
            this.drawTexturedModalRect(k + 79, l + 27, 176, 0, 24, 16);
        } else {
            int i1 = this.spinningWheel.getCookProgressScaled(24);
            this.drawTexturedModalRect(k + 79, l + 26, 176, 16, i1 + 1, 16);
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
    }
}

