/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.gui.inventory;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityDistillery;
import net.msrandom.witchery.inventory.ContainerDistillery;

@SideOnly(value=Side.CLIENT)
public class GuiDistillery
extends GuiContainer {
    public static final ResourceLocation TEXTURE = new ResourceLocation("witchery", "textures/gui/distillery.png");
    private final TileEntityDistillery inventory;

    public GuiDistillery(ContainerDistillery container) {
        super((Container)container);
        this.inventory = container.distillery;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        String s = this.inventory.hasCustomName() ? this.inventory.getName() : I18n.format((String)this.inventory.getName(), (Object[])new Object[0]);
        this.fontRenderer.drawString(s, this.xSize / 2 - this.fontRenderer.getStringWidth(s) / 2, 6, 0x404040);
        this.fontRenderer.drawString(I18n.format((String)"container.inventory", (Object[])new Object[0]), 8, this.ySize - 96 + 2, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float par1, int par2, int par3) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(TEXTURE);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        int brewTime = this.inventory.getCookProgressScaled(28);
        if (this.inventory.powerLevel <= 0) {
            this.drawTexturedModalRect(k + 77, l + 34, 197, 0, 28, 17);
        }
        if (brewTime > 0) {
            this.drawTexturedModalRect(k + 77, l + 37, 176, 29, brewTime, 9);
            int k2 = (800 - this.inventory.furnaceCookTime) / 2 % 7;
            switch (k2) {
                case 0: {
                    brewTime = 29;
                    break;
                }
                case 1: {
                    brewTime = 24;
                    break;
                }
                case 2: {
                    brewTime = 20;
                    break;
                }
                case 3: {
                    brewTime = 16;
                    break;
                }
                case 4: {
                    brewTime = 11;
                    break;
                }
                case 5: {
                    brewTime = 6;
                    break;
                }
                case 6: {
                    brewTime = 0;
                }
            }
            if (brewTime > 0) {
                this.drawTexturedModalRect(k + 40, l + 18 + 29 - brewTime, 185, 29 - brewTime, 12, brewTime);
            }
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
    }
}

