/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.gui.inventory;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.inventory.ContainerBrewBag;

@SideOnly(value=Side.CLIENT)
public class GuiBrewBag
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("witchery", "textures/gui/generic_48.png");
    private final ContainerBrewBag container;

    public GuiBrewBag(ContainerBrewBag container) {
        super((Container)container);
        this.container = container;
        this.ySize = 114 + container.numRows * 18;
    }

    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.fontRenderer.drawString(I18n.format((String)this.container.bagInventory.getName(), (Object[])new Object[0]), 8, 6, 0x404040);
        this.fontRenderer.drawString(I18n.format((String)this.container.player.inventory.getName(), (Object[])new Object[0]), 8, this.ySize - 96 + 2, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        int var4 = (this.width - this.xSize) / 2;
        int var5 = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(var4, var5, 0, 0, this.xSize, this.container.numRows * 18 + 17);
        this.drawTexturedModalRect(var4, var5 + this.container.numRows * 18 + 17, 0, 126, this.xSize, 96);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
    }
}

