/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client.gui;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityAltar;

@SideOnly(value=Side.CLIENT)
public class GuiAltar
extends GuiScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("witchery:textures/gui/altar.png");
    private static final int SIZE_OF_TEXTURE_X = 176;
    private static final int SIZE_OF_TEXTURE_Y = 88;
    private final TileEntityAltar tileEntity;

    public GuiAltar(TileEntityAltar tileEntity) {
        this.tileEntity = tileEntity;
    }

    public void drawScreen(int x, int y, float f) {
        this.drawDefaultBackground();
        this.mc.getTextureManager().bindTexture(TEXTURE);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = (this.width - 176) / 2;
        int posY = (this.height - 88) / 2;
        this.drawTexturedModalRect(posX, posY, 0, 0, 176, 88);
        this.drawCenteredString(this.fontRenderer, "Altar", this.width / 2, this.height / 2 - 20, 0xFFFFFF);
        String power = String.format("%.0f / %.0f (x%d)", Float.valueOf(this.tileEntity.getCorePower()), Float.valueOf(this.tileEntity.getCoreMaxPower()), this.tileEntity.getCoreSpeed());
        this.drawCenteredString(this.fontRenderer, power, this.width / 2, this.height / 2, 0xFFFFFF);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    protected void keyTyped(char par1, int par2) {
        if (par2 == 1 || par2 == this.mc.gameSettings.keyBindInventory.getKeyCode()) {
            this.mc.player.closeScreen();
        }
    }
}

