/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.client.resources.InfusionIconManager;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.util.RenderUtil;

@SideOnly(value=Side.CLIENT)
public class RenderInfusionEnergyBar {
    public static final ResourceLocation CREATURES = new ResourceLocation("witchery", "textures/gui/creatures.png");
    private static final ResourceLocation GLASS = new ResourceLocation("witchery", "textures/gui/glass.png");
    private static final ResourceLocation BLOCK_TEXTURES = new ResourceLocation("textures/atlas/blocks.png");
    final int xsize;
    final int ysize;
    final boolean primary;

    public RenderInfusionEnergyBar(boolean primary) {
        this.xsize = 8;
        this.ysize = 32;
        this.primary = primary;
    }

    public static void drawIconPartial(double x, double y, TextureAtlasSprite sprite, double left, double top, double right, double bottom) {
        if (sprite == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getMinecraft();
        GlStateManager.disableDepth();
        GlStateManager.disableCull();
        GlStateManager.disableLighting();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        minecraft.getTextureManager().bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        float u1 = sprite.getMinU();
        float v1 = sprite.getMinV();
        float u2 = sprite.getMaxU();
        float v2 = sprite.getMaxV();
        double xOffset1 = left * (double)(u2 - u1) / 16.0;
        double yOffset1 = top * (double)(v2 - v1) / 16.0;
        double xOffset2 = right * (double)(u2 - u1) / 16.0;
        double yOffset2 = bottom * (double)(v2 - v1) / 16.0;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuffer();
        bufferbuilder.begin(7, DefaultVertexFormats.POSITION_TEX);
        bufferbuilder.pos(x + left, y + top, 0.0).tex((double)u1 + xOffset1, (double)v1 + yOffset1).endVertex();
        bufferbuilder.pos(x + left, y + bottom, 0.0).tex((double)u1 + xOffset1, (double)v1 + yOffset2).endVertex();
        bufferbuilder.pos(x + right, y + bottom, 0.0).tex((double)u1 + xOffset2, (double)v1 + yOffset2).endVertex();
        bufferbuilder.pos(x + right, y + top, 0.0).tex((double)u1 + xOffset2, (double)v1 + yOffset1).endVertex();
        tessellator.draw();
        GlStateManager.enableDepth();
    }

    public void draw(float xpos, float ypos, double value, Infusion infusion, int iconOffsetId) {
        this.draw(xpos, ypos, value, infusion, CREATURES, iconOffsetId);
    }

    public void draw(float xpos, float ypos, double value, Infusion infusion, ResourceLocation icon) {
        this.draw(xpos, ypos, value, infusion, icon, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(float xpos, float ypos, double value, Infusion infusion, ResourceLocation icon, int iconOffsetId) {
        Minecraft mc = Minecraft.getMinecraft();
        mc.getTextureManager().bindTexture(BLOCK_TEXTURES);
        GlStateManager.pushMatrix();
        try {
            RenderUtil.blend(true);
            this.drawFluid(xpos, ypos, value, InfusionIconManager.INSTANCE.getIcon(this.primary ? infusion : Infusion.DEFUSED));
            int iconOffsetX = 0;
            int iconOffsetY = iconOffsetId * 8;
            if (this.primary) {
                this.drawGlass(xpos, ypos);
                iconOffsetX = 8;
            }
            int xPosition = MathHelper.floor((float)xpos);
            int yPosition = MathHelper.floor((float)ypos) + 33;
            mc.getTextureManager().bindTexture(icon);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(xPosition, yPosition, iconOffsetX, iconOffsetY, 8, 8);
        }
        finally {
            RenderUtil.blend(false);
            GlStateManager.popMatrix();
        }
    }

    public void drawFluid(double xpos, double ypos, double value, TextureAtlasSprite icon) {
        double bottomY = ypos + (double)this.ysize;
        double topY = ypos + (double)this.ysize * (1.0 - value);
        GlStateManager.scale((double)0.5, (double)0.5, (double)0.5);
        if (this.primary) {
            while (bottomY - 8.0 > topY) {
                RenderInfusionEnergyBar.drawIconPartial(xpos * 2.0, (bottomY - 8.0) * 2.0, icon, 0.0, 0.0, 16.0, 16.0);
                bottomY -= 8.0;
            }
            RenderInfusionEnergyBar.drawIconPartial(xpos * 2.0, (bottomY - 8.0) * 2.0, icon, 0.0, (topY - bottomY + 8.0) * 2.0, 16.0, 16.0);
        } else {
            int i = 0;
            while ((double)i < value) {
                RenderInfusionEnergyBar.drawIconPartial(xpos * 2.0, (bottomY - (double)(i * 2)) * 2.0 - 2.0, icon, 0.0, 0.0, 16.0, 2.0);
                ++i;
            }
        }
        GlStateManager.scale((double)2.0, (double)2.0, (double)2.0);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height2) {
        double f = this.primary ? 0.00390625 : 0.125;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos((double)x, (double)(y + height2), 0.0).tex((double)u * f, (double)(v + height2) * f).endVertex();
        buffer.pos((double)(x + width), (double)(y + height2), 0.0).tex((double)(u + width) * f, (double)(v + height2) * f).endVertex();
        buffer.pos((double)(x + width), (double)y, 0.0).tex((double)(u + width) * f, (double)v * f).endVertex();
        buffer.pos((double)x, (double)y, 0.0).tex((double)u * f, (double)v * f).endVertex();
        tessellator.draw();
    }

    public void drawGlass(float xpos, float ypos) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(GLASS);
        GlStateManager.glBegin((int)7);
        GlStateManager.glTexCoord2f((float)0.0f, (float)0.0f);
        GlStateManager.glVertex3f((float)xpos, (float)ypos, (float)0.0f);
        GlStateManager.glTexCoord2f((float)0.0f, (float)1.0f);
        GlStateManager.glVertex3f((float)xpos, (float)(ypos + (float)this.ysize), (float)0.0f);
        GlStateManager.glTexCoord2f((float)1.0f, (float)1.0f);
        GlStateManager.glVertex3f((float)(xpos + (float)this.xsize), (float)(ypos + (float)this.ysize), (float)0.0f);
        GlStateManager.glTexCoord2f((float)1.0f, (float)0.0f);
        GlStateManager.glVertex3f((float)(xpos + (float)this.xsize), (float)ypos, (float)0.0f);
        GlStateManager.glEnd();
    }
}

