/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.client;

import java.util.List;
import java.util.Objects;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Dyeable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.WitcheryResurrectedClient;
import net.msrandom.witchery.block.BlockBeartrap;
import net.msrandom.witchery.block.entity.TileEntityCauldron;
import net.msrandom.witchery.block.entity.TileEntityMovingBrew;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.client.ClientEventHandler;
import net.msrandom.witchery.client.RenderInfusionEnergyBar;
import net.msrandom.witchery.client.renderer.ModelOverlayRenderer;
import net.msrandom.witchery.client.renderer.entity.RenderOtherPlayer;
import net.msrandom.witchery.client.renderer.entity.RenderSleepingBody;
import net.msrandom.witchery.client.renderer.entity.RenderVillagerBed;
import net.msrandom.witchery.client.renderer.entity.model.ModelDemon;
import net.msrandom.witchery.client.shaders.WitcheryPostShaders;
import net.msrandom.witchery.client.transformation.AlternateFormRenderer;
import net.msrandom.witchery.client.transformation.AlternateFormRenderingRegistry;
import net.msrandom.witchery.common.InfusionPower;
import net.msrandom.witchery.common.ShapeShift;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.extensions.LivingExtendedData;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.extensions.VillagerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.OtherwhereInfusion;
import net.msrandom.witchery.infusion.brew.InfusedBrewEffect;
import net.msrandom.witchery.infusion.creature.CreatureAbility;
import net.msrandom.witchery.infusion.creature.CreaturePowerData;
import net.msrandom.witchery.infusion.symbol.BranchStroke;
import net.msrandom.witchery.infusion.symbol.StrokeArray;
import net.msrandom.witchery.infusion.symbol.StrokeSet;
import net.msrandom.witchery.infusion.symbol.SymbolEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.init.data.rites.WitcheryCurses;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.inventory.InventoryBrewBag;
import net.msrandom.witchery.item.ItemCombustionBrew;
import net.msrandom.witchery.item.ItemEarmuffs;
import net.msrandom.witchery.item.ItemWitchesClothes;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.network.resources.PacketCheckCompatibilityMode;
import net.msrandom.witchery.potion.IHandlePreRenderLiving;
import net.msrandom.witchery.potion.IHandleRenderLiving;
import net.msrandom.witchery.potion.PotionResizing;
import net.msrandom.witchery.resources.SymbolEffectManager;
import net.msrandom.witchery.rite.curse.SinkingCurse;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.transformation.VampireTransformation;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.KeyBindHelper;
import net.msrandom.witchery.util.RenderUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.lwjgl.opengl.GLContext;

public class ClientEvents {
    static final RenderVillagerBed renderBed = new RenderVillagerBed();
    private static final ResourceLocation RADIAL_LOCATION = new ResourceLocation("witchery", "textures/gui/brew_bag.png");
    private static final ResourceLocation BARK_TEXTURES = new ResourceLocation("witchery", "textures/gui/creatures.png");
    private static final ResourceLocation EMPTY_BLOOD_DROP = new ResourceLocation("witchery", "textures/gui/empty_blood_drop.png");
    private static final ResourceLocation BLOOD_DROP = new ResourceLocation("witchery", "textures/gui/blood_drop.png");
    public static final ModelDemon GROTESQUE_MODEL = new ModelDemon(true);
    public static final ResourceLocation DEMON_TEXTURE = new ResourceLocation("witchery", "textures/entity/demon.png");
    public static long eyeStartTime;
    public static long eyeRenderStartTime;
    public static boolean usingEye;
    public static boolean resetEye;
    public static Entity eye;
    protected static RenderInfusionEnergyBar infusionEnergyBar;
    protected static RenderInfusionEnergyBar creatureEnergyBar;
    private static RenderItem drawItems;
    private static boolean scrollingVampireAbilities1;
    private static boolean scrollingVampireAbilities8;
    public static boolean fog;
    public static int ticks;

    private static void drawTexturedRect(float p_146110_0_, float p_146110_1_, float p_146110_3_, float p_146110_5_) {
        float f4 = 0.125f;
        float f5 = 0.125f;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos((double)p_146110_0_, (double)(p_146110_1_ + p_146110_5_), 0.0).tex((double)(0.0f * f4), (double)((p_146110_3_ + p_146110_5_) * f5)).endVertex();
        buffer.pos((double)(p_146110_0_ + 8.0f), (double)(p_146110_1_ + p_146110_5_), 0.0).tex((double)(8.0f * f4), (double)((p_146110_3_ + p_146110_5_) * f5)).endVertex();
        buffer.pos((double)(p_146110_0_ + 8.0f), (double)p_146110_1_, 0.0).tex((double)(8.0f * f4), (double)(p_146110_3_ * f5)).endVertex();
        buffer.pos((double)p_146110_0_, (double)p_146110_1_, 0.0).tex((double)(0.0f * f4), (double)(p_146110_3_ * f5)).endVertex();
        tessellator.draw();
    }

    @SubscribeEvent
    public static void onMoueEvent(MouseEvent event) {
        Minecraft mc = Minecraft.getMinecraft();
        EntityPlayerSP player = mc.player;
        PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)player);
        VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
        if (transformation.getLevel() > 0 && event.getDwheel() != 0) {
            VampireTransformation.Power power = transformation.getSelectedPower();
            VampireTransformation.Power max = VampireTransformation.Power.getMax(transformation.getLevel());
            if (power == VampireTransformation.Power.NONE) {
                VampireTransformation.Power first = VampireTransformation.Power.DRINK;
                if (player.getPrimaryHand() == EnumHandSide.LEFT) {
                    first = max;
                    max = VampireTransformation.Power.DRINK;
                }
                if (player.inventory.currentItem == 0) {
                    if (event.getDwheel() > 0) {
                        transformation.setSelectedPower(first);
                        event.setCanceled(true);
                    }
                } else if (player.inventory.currentItem == 8 && event.getDwheel() < 0) {
                    transformation.setSelectedPower(max);
                    event.setCanceled(true);
                }
            } else {
                int i = power.ordinal() + RangesKt.coerceIn((int)(event.getDwheel() * (player.getPrimaryHand() == EnumHandSide.RIGHT ? 1 : -1)), (int)-1, (int)1);
                if (i == 0 || i > max.ordinal()) {
                    transformation.setSelectedPower(VampireTransformation.Power.NONE);
                    event.setCanceled(true);
                } else if (i < 0) {
                    transformation.setSelectedPower(max);
                } else {
                    transformation.setSelectedPower(VampireTransformation.Power.VALUES[i]);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ShapeShift.INSTANCE.updateJump(player);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() == Minecraft.getMinecraft().player) {
            WitcheryNetworkChannel.sendToServer(new PacketCheckCompatibilityMode(WitcheryResurrected.Companion.isInCompatibilityMode()));
        }
    }

    @SubscribeEvent
    public static void onVillagerPostRender(RenderLivingEvent.Post<EntityVillager> event) {
        if (event.getEntity() instanceof EntityVillager) {
            GlStateManager.popMatrix();
        }
    }

    @SubscribeEvent
    public static void onPlayerPostRender(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        if (WitcheryUtils.getExtension(player).getSpiritData().isGhost()) {
            RenderUtil.blend(false);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingSpecialsPre(RenderLivingEvent.Specials.Pre<EntityPlayer> event) {
        EntityPlayer player;
        PlayerExtendedData playerEx;
        if (!event.isCanceled() && WitcheryConfigOptions.allowNameplateMasquerading && event.getEntity() instanceof EntityPlayer && (playerEx = WitcheryUtils.getExtension(player = (EntityPlayer)event.getEntity())).getCurrentForm() == WitcheryAlternateForms.PLAYER) {
            event.setCanceled(true);
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            EntityLivingBase p_77033_1_ = event.getEntity();
            double p_77033_2_ = event.getX();
            double p_77033_4_ = event.getY();
            double p_77033_6_ = event.getZ();
            RenderManager renderManager = Minecraft.getMinecraft().getRenderManager();
            if (Minecraft.isGuiEnabled() && p_77033_1_ != renderManager.renderViewEntity && !p_77033_1_.isInvisibleToPlayer((EntityPlayer)Minecraft.getMinecraft().player) && p_77033_1_.getPassengers().isEmpty()) {
                float f3;
                float f = 1.6f;
                float f2 = 0.016666668f * f;
                double d3 = p_77033_1_.getDistanceSq(renderManager.renderViewEntity);
                float f4 = f3 = p_77033_1_.isSneaking() ? 32.0f : 64.0f;
                if (d3 < (double)(f3 * f3)) {
                    String skin = playerEx.getOtherPlayerSkin();
                    if (skin == null || skin.isEmpty()) {
                        return;
                    }
                    String s = new TextComponentString(skin).getFormattedText();
                    if (p_77033_1_.isSneaking()) {
                        FontRenderer fontrenderer = renderManager.getFontRenderer();
                        GlStateManager.pushMatrix();
                        GlStateManager.translate((float)((float)p_77033_2_ + 0.0f), (float)((float)p_77033_4_ + p_77033_1_.height + 0.5f), (float)((float)p_77033_6_));
                        GlStateManager.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.rotate((float)(-renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.rotate((float)renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.scale((float)(-f2), (float)(-f2), (float)f2);
                        GlStateManager.disableLighting();
                        GlStateManager.translate((float)0.0f, (float)(0.25f / f2), (float)0.0f);
                        GlStateManager.depthMask((boolean)false);
                        GlStateManager.enableBlend();
                        GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                        Tessellator tessellator = Tessellator.getInstance();
                        BufferBuilder buffer = tessellator.getBuffer();
                        GlStateManager.disableTexture2D();
                        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
                        int i = fontrenderer.getStringWidth(s) / 2;
                        buffer.pos((double)(-i - 1), -1.0, 0.0).color(0.0f, 0.0f, 0.0f, 0.25f).endVertex();
                        buffer.pos((double)(-i - 1), 8.0, 0.0).color(0.0f, 0.0f, 0.0f, 0.25f).endVertex();
                        buffer.pos((double)(i + 1), 8.0, 0.0).color(0.0f, 0.0f, 0.0f, 0.25f).endVertex();
                        buffer.pos((double)(i + 1), -1.0, 0.0).color(0.0f, 0.0f, 0.0f, 0.25f).endVertex();
                        tessellator.draw();
                        GlStateManager.enableTexture2D();
                        GlStateManager.depthMask((boolean)true);
                        fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, 0, 0x20FFFFFF);
                        GlStateManager.enableLighting();
                        GlStateManager.disableBlend();
                        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.popMatrix();
                    } else {
                        ClientEvents.renderEntityName(p_77033_1_, p_77033_2_, p_77033_4_, p_77033_6_, s);
                    }
                }
            }
        }
    }

    protected static void renderEntityName(EntityLivingBase p_96449_1_, double p_96449_2_, double p_96449_4_, double p_96449_6_, String p_96449_8_) {
        if (!p_96449_1_.isPlayerSleeping()) {
            ClientEvents.renderName((Entity)p_96449_1_, p_96449_8_, p_96449_2_, p_96449_4_, p_96449_6_);
        }
    }

    protected static void renderName(Entity p_147906_1_, String p_147906_2_, double p_147906_3_, double p_147906_5_, double p_147906_7_) {
        RenderManager renderManager = Minecraft.getMinecraft().getRenderManager();
        double d3 = p_147906_1_.getDistanceSq(renderManager.renderViewEntity);
        if (d3 <= 4096.0) {
            FontRenderer fontrenderer = renderManager.getFontRenderer();
            float f = 1.6f;
            float f2 = 0.016666668f * f;
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)((float)p_147906_3_ + 0.0f), (float)((float)p_147906_5_ + p_147906_1_.height + 0.5f), (float)((float)p_147906_7_));
            GlStateManager.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotate((float)(-renderManager.playerViewY), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotate((float)renderManager.playerViewX, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.scale((float)(-f2), (float)(-f2), (float)f2);
            GlStateManager.disableLighting();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.disableDepth();
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Tessellator tessellator = Tessellator.getInstance();
            BufferBuilder buffer = tessellator.getBuffer();
            int b0 = 0;
            if (p_147906_2_.equals("deadmau5")) {
                b0 = -10;
            }
            GlStateManager.disableTexture2D();
            buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
            int j = fontrenderer.getStringWidth(p_147906_2_) / 2;
            buffer.pos((double)(-j - 1), (double)(-1 + b0), 0.0).color(0.0f, 0.0f, 0.0f, 0.25f).endVertex();
            buffer.pos((double)(-j - 1), (double)(8 + b0), 0.0).color(0.0f, 0.0f, 0.0f, 0.25f).endVertex();
            buffer.pos((double)(j + 1), (double)(8 + b0), 0.0).color(0.0f, 0.0f, 0.0f, 0.25f).endVertex();
            buffer.pos((double)(j + 1), (double)(-1 + b0), 0.0).color(0.0f, 0.0f, 0.0f, 0.25f).endVertex();
            tessellator.draw();
            GlStateManager.enableTexture2D();
            fontrenderer.drawString(p_147906_2_, -fontrenderer.getStringWidth(p_147906_2_) / 2, b0, 0x20FFFFFF);
            GlStateManager.enableDepth();
            GlStateManager.depthMask((boolean)true);
            fontrenderer.drawString(p_147906_2_, -fontrenderer.getStringWidth(p_147906_2_) / 2, b0, -1);
            GlStateManager.enableLighting();
            GlStateManager.disableBlend();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.popMatrix();
        }
    }

    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (event != null && !event.isCanceled() && event.getPlayer() != null && BlockBeartrap.checkForHiddenTrap(event.getPlayer(), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderSpecificHandEvent event) {
        if (eye != null) {
            event.setCanceled(true);
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        EntityPlayerSP player = mc.player;
        PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)player);
        AlternateForm creatureType = playerEx.getCurrentForm();
        if (creatureType != null) {
            AlternateFormRenderer renderer = AlternateFormRenderingRegistry.get(creatureType);
            if (!renderer.shouldRenderArm()) {
                event.setCanceled(true);
            }
            if (!event.isCanceled() && event.getHand() == EnumHand.MAIN_HAND && player.getHeldItem(EnumHand.MAIN_HAND).isEmpty()) {
                event.setCanceled(true);
                ClientEvents.renderArm(renderer, playerEx, player.getPrimaryHand(), event.getEquipProgress(), event.getSwingProgress(), event.getPartialTicks());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockColorsInit(ColorHandlerEvent.Block event) {
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColorHelper.getFoliageColorAtPos((IBlockAccess)world, (BlockPos)pos) : 4764952, new Block[]{WitcheryWoodTypes.ROWAN.getLeaves()});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> 0x399933, new Block[]{WitcheryWoodTypes.ALDER.getLeaves()});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> 65382, new Block[]{WitcheryBlocks.SPIRIT_PORTAL});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> 0xFF0022, new Block[]{WitcheryBlocks.TORMENT_PORTAL});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> 0xCCDDFF, new Block[]{WitcheryBlocks.MIRROR_WALL});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> {
            TileEntityMovingBrew gas;
            if (world != null && pos != null && (gas = WitcheryTileEntities.MOVING_BREW.getAt(world, pos)) != null && gas.actionList != null) {
                return WitcheryUtils.getBrewColor(gas.actionList.items);
            }
            return 0x33AA33;
        }, new Block[]{WitcheryBlocks.BREW_GAS});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> {
            TileEntityMovingBrew fluid;
            if (world != null && pos != null && (fluid = WitcheryTileEntities.MOVING_BREW.getAt(world, pos)) != null && fluid.actionList != null) {
                return WitcheryUtils.getBrewColor(fluid.actionList.items);
            }
            return 68;
        }, new Block[]{WitcheryBlocks.BREW_LIQUID});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> {
            TileEntityCauldron cauldron;
            if (world != null && pos != null && (cauldron = WitcheryTileEntities.CAULDRON.getAt(world, pos)) != null) {
                return cauldron.getColor();
            }
            return -1;
        }, new Block[]{WitcheryBlocks.CAULDRON});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> ColorizerFoliage.getFoliageColorBirch(), new Block[]{WitcheryBlocks.SPANISH_MOSS});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> world != null && pos != null ? 2129968 : 7455580, new Block[]{WitcheryBlocks.LEAPING_LILY, WitcheryBlocks.LILY});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColorHelper.getGrassColorAtPos((IBlockAccess)world, (BlockPos)pos) : ColorizerGrass.getGrassColor((double)0.5, (double)1.0), new Block[]{WitcheryBlocks.PIT_GRASS});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> 9250728, new Block[]{WitcheryBlocks.GLYPH_OTHERWHERE});
        event.getBlockColors().registerBlockColorHandler((state, world, pos, tintIndex) -> 10037248, new Block[]{WitcheryBlocks.GLYPH_INFERNAL});
    }

    @SubscribeEvent
    public static void onItemColorsInit(ColorHandlerEvent.Item event) {
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> tintIndex == 0 ? WitcheryIngredientItems.ENCHANTED_BROOM.getColor(stack).getColorValue() : -1, new Item[]{WitcheryIngredientItems.ENCHANTED_BROOM});
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> tintIndex == 0 ? ItemCombustionBrew.COLORS[ItemCombustionBrew.getLevel(stack)] : -1, new Item[]{WitcheryGeneralItems.COMBUSTION_BREW});
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> tintIndex == 1 ? 255 : -1, new Item[]{WitcheryGeneralItems.ENDLESS_WATER_BREW});
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> 7455580, new Item[]{Item.getItemFromBlock((Block)WitcheryBlocks.LEAPING_LILY)});
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> tintIndex == 0 ? ((ItemArmor)stack.getItem()).getColor(stack) : -1, new Item[]{WitcheryEquipmentItems.WITCH_HAT, WitcheryEquipmentItems.BABAS_HAT, WitcheryEquipmentItems.WITCH_ROBES, WitcheryEquipmentItems.NECROMANCERS_ROBES, WitcheryEquipmentItems.BITING_BELT, WitcheryEquipmentItems.BARK_BELT, WitcheryEquipmentItems.ICY_SLIPPERS, WitcheryEquipmentItems.RUBY_SLIPPERS, WitcheryEquipmentItems.SEEPING_SHOES, WitcheryEquipmentItems.HUNTER_HAT, WitcheryEquipmentItems.HUNTER_COAT, WitcheryEquipmentItems.HUNTER_LEGS, WitcheryEquipmentItems.HUNTER_BOOTS, WitcheryEquipmentItems.HUNTER_HAT_SILVERED, WitcheryEquipmentItems.HUNTER_COAT_SILVERED, WitcheryEquipmentItems.HUNTER_LEGS_SILVERED, WitcheryEquipmentItems.HUNTER_BOOTS_SILVERED, WitcheryEquipmentItems.HUNTER_HAT_GARLICKED, WitcheryEquipmentItems.HUNTER_COAT_GARLICKED, WitcheryEquipmentItems.HUNTER_LEGS_GARLICKED, WitcheryEquipmentItems.HUNTER_BOOTS_GARLICKED, WitcheryEquipmentItems.MOGS_QUIVER, WitcheryEquipmentItems.GULGS_GURDLE, WitcheryEquipmentItems.KOBOLDITE_HELM, WitcheryEquipmentItems.EARMUFFS, WitcheryEquipmentItems.VAMPIRE_TOP_HAT, WitcheryEquipmentItems.VAMPIRE_HELMET, WitcheryEquipmentItems.VAMPIRE_WAIST_COAT, WitcheryEquipmentItems.VAMPIRE_CORSET, WitcheryEquipmentItems.VAMPIRE_CHESTPLATE, WitcheryEquipmentItems.VAMPIRE_TROUSERS, WitcheryEquipmentItems.VAMPIRE_SKIRT, WitcheryEquipmentItems.VAMPIRE_SHOES});
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> event.getBlockColors().colorMultiplier(((ItemBlock)stack.getItem()).getBlock().getStateFromMeta(stack.getMetadata()), null, null, tintIndex), new Block[]{WitcheryWoodTypes.ROWAN.getLeaves(), WitcheryWoodTypes.ALDER.getLeaves(), WitcheryWoodTypes.HAWTHORN.getLeaves(), WitcheryBlocks.SPIRIT_PORTAL, WitcheryBlocks.TORMENT_PORTAL, WitcheryBlocks.MIRROR_WALL, WitcheryBlocks.SPANISH_MOSS, WitcheryBlocks.PIT_GRASS, WitcheryBlocks.LEAPING_LILY});
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> tintIndex == 0 ? WitcheryUtils.getBrewColor(new BrewActionList((NBTTagCompound)stack.getTagCompound()).items) : -1, new Item[]{WitcheryGeneralItems.BREW_BOTTLE, WitcheryGeneralItems.SPLASH_BREW_BOTTLE, WitcheryGeneralItems.LINGERING_BREW_BOTTLE});
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> stack.hasTagCompound() ? WitcheryUtils.getOrCreateTag(stack).getInteger("Color") : -1, new Item[]{WitcheryIngredientItems.QUARTZ_SPHERE});
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> ((Dyeable)stack.getItem()).getColor(stack), new Item[]{WitcheryGeneralItems.BREW_BAG});
        event.getItemColors().registerItemColorHandler((stack, tintIndex) -> stack.hasTagCompound() ? WitcheryUtils.getOrCreateTag(stack).getInteger("Color") : -1, new Item[]{Items.SNOWBALL});
    }

    @SubscribeEvent
    public static void inputEvent(InputEvent.KeyInputEvent event) {
        KeyBinding[] keyBindsHotbar = Minecraft.getMinecraft().gameSettings.keyBindsHotbar;
        for (int i = 0; i < keyBindsHotbar.length; ++i) {
            boolean pressed = keyBindsHotbar[i].isKeyDown();
            if (i == 0) {
                if (pressed) {
                    if (scrollingVampireAbilities1) continue;
                    scrollingVampireAbilities1 = true;
                } else {
                    scrollingVampireAbilities1 = false;
                }
            } else if (i == keyBindsHotbar.length - 1) {
                if (pressed) {
                    if (scrollingVampireAbilities8) continue;
                    scrollingVampireAbilities8 = true;
                } else {
                    scrollingVampireAbilities8 = false;
                }
            }
            if (!pressed) continue;
            ClientEventHandler.handleHotbarKeyPress(i);
            break;
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++ticks;
        }
        if (event.phase == TickEvent.Phase.END) {
            ClientEventHandler.handleJump();
        }
    }

    private static FontRenderer getFontRenderer(ItemStack stack) {
        FontRenderer f;
        if (!stack.isEmpty() && (f = stack.getItem().getFontRenderer(stack)) != null) {
            return f;
        }
        return Minecraft.getMinecraft().fontRenderer;
    }

    private static void drawItem(int i, int j, ItemStack itemstack) {
        ClientEvents.drawItem(i, j, itemstack, ClientEvents.getFontRenderer(itemstack));
    }

    private static void drawItem(int i, int j, ItemStack itemstack, FontRenderer fontRenderer) {
        Minecraft mc = Minecraft.getMinecraft();
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        if (drawItems == null) {
            drawItems = mc.getRenderItem();
        }
        ClientEvents.drawItems.zLevel += 100.0f;
        drawItems.renderItemAndEffectIntoGUI(itemstack, i, j);
        drawItems.renderItemOverlayIntoGUI(fontRenderer, itemstack, i, j, null);
        ClientEvents.drawItems.zLevel -= 100.0f;
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
    }

    public static void drawString(String s, double x, double y, int color2) {
        Minecraft.getMinecraft().fontRenderer.drawStringWithShadow(s, (float)((int)x), (float)((int)y), color2);
    }

    public static double getStringWidth(String s) {
        return Minecraft.getMinecraft().fontRenderer.getStringWidth(s);
    }

    private static void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        double zLevel = 0.0;
        float f = 0.00390625f;
        float f2 = 0.00390625f;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos((double)par1, (double)(par2 + par6), zLevel).tex((double)((float)par3 * f), (double)((float)(par4 + par6) * f2)).endVertex();
        buffer.pos((double)(par1 + par5), (double)(par2 + par6), zLevel).tex((double)((float)(par3 + par5) * f), (double)((float)(par4 + par6) * f2)).endVertex();
        buffer.pos((double)(par1 + par5), (double)par2, zLevel).tex((double)((float)(par3 + par5) * f), (double)((float)par4 * f2)).endVertex();
        buffer.pos((double)par1, (double)par2, zLevel).tex((double)((float)par3 * f), (double)((float)par4 * f2)).endVertex();
        tessellator.draw();
    }

    private static void drawInfusedBrews(EntityPlayerSP player, ScaledResolution screen) {
        String remainingTime;
        NBTTagCompound nbtPlayer = player.getEntityData();
        InfusedBrewEffect effect = InfusedBrewEffect.getActiveBrew(nbtPlayer);
        if (effect != null && (remainingTime = InfusedBrewEffect.getMinutesRemaining(nbtPlayer)) != null && !remainingTime.isEmpty()) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.getTextureManager().bindTexture(BARK_TEXTURES);
            int top = screen.getScaledHeight() / 2 + 26;
            int left = player.getPrimaryHand() == EnumHandSide.RIGHT ? 17 : screen.getScaledWidth() - 23;
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int ICON_WIDTH = 16;
            int ICON_HEIGHT = 16;
            ClientEvents.drawTexturedModalRect(left, top, effect.imageMapX, effect.imageMapY, ICON_WIDTH, ICON_HEIGHT);
            double width = ClientEvents.getStringWidth(remainingTime) / 2.0;
            ClientEvents.drawString(remainingTime, (double)(left + 8) - width, top + 10, -285212673);
        }
    }

    private static void drawBarkBeltCharges(EntityPlayerSP player, int beltCharges, ScaledResolution screen) {
        if (beltCharges > 0 && !player.capabilities.isCreativeMode) {
            Minecraft mc = Minecraft.getMinecraft();
            mc.getTextureManager().bindTexture(BARK_TEXTURES);
            int tx = screen.getScaledWidth() / 2 - 91;
            int par2 = screen.getScaledHeight();
            int ty = par2 / 2;
            IAttributeInstance attributeinstance = mc.player.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
            int i2 = par2 - 39;
            float f = (float)attributeinstance.getAttributeValue();
            float f2 = mc.player.getAbsorptionAmount();
            int j2 = MathHelper.ceil((float)((f + f2) / 2.0f / 10.0f));
            int k2 = Math.max(10 - (j2 - 2), 3);
            int l2 = WitcheryResurrected.Companion.isTinkersPresent() ? i2 - 10 : i2 - (j2 - 1) * k2 - 10;
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int iconOffsetX = 0;
            int ICON_WIDTH = 8;
            int ICON_HEIGHT = 8;
            int iconOffsetY = 248;
            for (int m = 0; m < beltCharges; ++m) {
                ClientEvents.drawTexturedModalRect(tx + m * ICON_HEIGHT, l2, iconOffsetX, iconOffsetY, ICON_WIDTH, ICON_HEIGHT);
            }
        }
    }

    private static void drawBrewInSlot(InventoryBrewBag inv, int slot, StrokeArray strokes, int x, int y, int fx, int fy, int align) {
        ItemStack brew = inv.getStackInSlot(slot);
        if (strokes.isEmpty() || strokes.getRaw().get(0) == BranchStroke.get(slot)) {
            ClientEvents.drawItem(x, y, brew);
            if (!brew.isEmpty()) {
                String s = brew.getDisplayName().trim();
                double fontX = x + fx;
                double fontY = y + fy;
                if (align != 0) {
                    double width = ClientEvents.getStringWidth(s);
                    if (align == 1) {
                        fontX -= width / 2.0;
                    } else if (align == 2) {
                        fontX -= width;
                    }
                }
                ClientEvents.drawString(s, fontX, fontY, 0x77FFFFFF);
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft minecraft = Minecraft.getMinecraft();
            EntityPlayerSP player = minecraft.player;
            if (player != null) {
                int z;
                int y;
                int x;
                PotionEffect effect;
                boolean allowSpeedUp = true;
                LivingExtendedData livingEx = WitcheryDataExtensions.LIVING.get((EntityLivingBase)player);
                PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)player);
                if (playerEx.creaturePower != null) {
                    for (CreatureAbility ability : playerEx.creaturePower.getPower().getAbilities()) {
                        ability.onUpdate(player.world, (EntityPlayer)player);
                        if (ability.allowSpeedUp()) continue;
                        allowSpeedUp = false;
                    }
                }
                if (allowSpeedUp && player.isHandActive() && (player.getHeldItem(player.getActiveHand()).getItem() == WitcheryGeneralItems.MYSTIC_BRANCH || player.getHeldItem(player.getActiveHand()).getItem() == WitcheryGeneralItems.BREW_BAG)) {
                    boolean canGo;
                    boolean bl = canGo = Math.abs(player.motionX) <= 0.1 && Math.abs(player.motionZ) <= 0.1;
                    if (player.world.getBlockState(new BlockPos(MathHelper.floor((double)player.posX), MathHelper.floor((double)player.posY) - 2, MathHelper.floor((double)player.posZ))).getBlock() != Blocks.ICE) {
                        if (player.onGround) {
                            if (!player.isInWater()) {
                                if (canGo) {
                                    player.motionX *= 1.6500000476837158;
                                    player.motionZ *= 1.6500000476837158;
                                }
                            } else if (canGo) {
                                player.motionX *= (double)1.1f;
                                player.motionZ *= (double)1.1f;
                            }
                        }
                    } else if (canGo) {
                        player.motionX *= (double)1.1f;
                        player.motionZ *= (double)1.1f;
                    }
                }
                SinkingCurse sinking2 = WitcheryCurses.getSinking();
                int sinkingCurseLevel = livingEx.getCurses().getInt((Object)sinking2);
                if (sinkingCurseLevel > 0 && player.isInWater()) {
                    if (player.motionY < -0.03 && !player.onGround) {
                        player.motionY *= 1.5 + Math.min(0.05 * (double)(sinkingCurseLevel - 1), 0.2);
                    }
                } else if (sinkingCurseLevel > 0) {
                    if (!player.capabilities.isCreativeMode && player.capabilities.allowFlying && player.capabilities.isFlying) {
                        player.motionY = -0.2f;
                    }
                } else if (player.isPotionActive(MobEffects.SLOWNESS) && !player.capabilities.isCreativeMode && player.capabilities.allowFlying && player.capabilities.isFlying && (effect = player.getActivePotionEffect(MobEffects.SLOWNESS)) != null && effect.getAmplifier() > 4) {
                    player.motionY = -0.2f;
                }
                if (sinkingCurseLevel == 0 && BlockUtil.getBlockMaterial((EntityPlayer)player).isLiquid() && ((ItemStack)player.inventory.armorInventory.get(0)).getItem() == WitcheryEquipmentItems.DEATH_FEET && player.motionY < 0.0) {
                    player.motionY += 0.1;
                }
                if (player.onGround && KeyBindHelper.isKeyBindDown(minecraft.gameSettings.keyBindJump) && player.world.getBlockState(new BlockPos(x = MathHelper.floor((double)player.posX), (y = MathHelper.floor((double)player.posY)) - 1, z = MathHelper.floor((double)player.posZ))).getBlock() == WitcheryBlocks.LEAPING_LILY) {
                    player.playSound(SoundEvents.ENTITY_ARROW_HIT, 1.0f, 0.4f / ((float)player.world.rand.nextDouble() * 0.4f + 0.8f));
                }
            }
        } else if (event.phase == TickEvent.Phase.END) {
            Minecraft minecraft = Minecraft.getMinecraft();
            EntityPlayerSP player = minecraft.player;
            if (player != null && minecraft.currentScreen instanceof InventoryEffectRenderer && WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && !player.capabilities.isCreativeMode) {
                minecraft.currentScreen.buttonList.clear();
            }
        }
    }

    @SubscribeEvent
    public static void onSound(PlaySoundEvent event) {
        Minecraft MC = Minecraft.getMinecraft();
        EntityPlayerSP player = MC.player;
        if (player != null && ItemEarmuffs.isHelmWorn((EntityPlayer)player)) {
            event.setResultSound(null);
        }
    }

    public static void renderArm(AlternateFormRenderer renderer, PlayerExtendedData playerEx, EnumHandSide hand, float equipProgress, float swingProgress, float delta) {
        boolean flag = hand != EnumHandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.sqrt((float)swingProgress);
        float f2 = -0.3f * MathHelper.sin((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.sin((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.sin((float)(swingProgress * (float)Math.PI));
        GlStateManager.translate((float)(f * (f2 + 0.64000005f)), (float)(f3 + -0.6f + equipProgress * -0.6f), (float)(f4 + -0.71999997f));
        GlStateManager.rotate((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.sin((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = MathHelper.sin((float)(f1 * (float)Math.PI));
        GlStateManager.rotate((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translate((float)(f * -1.0f), (float)3.6f, (float)3.5f);
        GlStateManager.rotate((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotate((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotate((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translate((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        GlStateManager.disableCull();
        Render entityRenderer = Objects.requireNonNull(Minecraft.getMinecraft().getRenderManager().getEntityRenderObject(playerEx.entity));
        renderer.renderArm((RenderPlayer)entityRenderer, playerEx, hand, equipProgress, swingProgress, delta);
        GlStateManager.enableCull();
    }

    public static float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        switch (event.getType()) {
            case HOTBAR: {
                GUIOverlay.INSTANCE.renderHotbar(event);
                break;
            }
            case TEXT: {
                int i;
                EntityPlayer targetPlayer;
                PlayerExtendedData targetPlayerEx;
                RayTraceResult movingPosition;
                int j;
                EntityPlayerSP player = Minecraft.getMinecraft().player;
                PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)player);
                VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
                if (transformation.getLevel() <= 0) break;
                float left = player.getPrimaryHand() == EnumHandSide.RIGHT ? 10.0f : (float)(event.getResolution().getScaledWidth() - 10);
                float top = (float)event.getResolution().getScaledHeight() * 0.5f + 16.0f;
                int maxBlood = transformation.getMaxBloodPower();
                int pscale = 250;
                Minecraft.getMinecraft().renderEngine.bindTexture(EMPTY_BLOOD_DROP);
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (j = 0; j < maxBlood / pscale; ++j) {
                    ClientEvents.drawTexturedRect(left, top - (float)(j * 8), 0.0f, 8.0f);
                }
                Minecraft.getMinecraft().renderEngine.bindTexture(BLOOD_DROP);
                int pblood = transformation.getBloodPower();
                for (j = 0; j < pblood / pscale; ++j) {
                    ClientEvents.drawTexturedRect(left, top - (float)(j * 8), 0.0f, 8.0f);
                }
                if (pblood % pscale > 0) {
                    float remainder = 8.0f * (float)(pblood % pscale) / (float)pscale;
                    ClientEvents.drawTexturedRect(left, top - (float)(j * 8) + 8.0f - remainder, 8.0f - remainder, remainder);
                }
                if ((movingPosition = OtherwhereInfusion.raytraceEntities((World)Minecraft.getMinecraft().world, (EntityPlayer)Minecraft.getMinecraft().player, 5.0)) == null || movingPosition.entityHit == null) break;
                int blood = -1;
                if (movingPosition.entityHit instanceof EntityVillager) {
                    blood = WitcheryDataExtensions.VILLAGER.get((EntityVillager)movingPosition.entityHit).getBlood();
                } else if (movingPosition.entityHit instanceof EntityVillageGuard) {
                    EntityVillageGuard guard = (EntityVillageGuard)movingPosition.entityHit;
                    blood = guard.getBlood();
                } else if (movingPosition.entityHit instanceof EntityPlayer && !(targetPlayerEx = WitcheryUtils.getExtension(targetPlayer = (EntityPlayer)movingPosition.entityHit)).isTransformation(WitcheryTransformations.VAMPIRE)) {
                    blood = targetPlayerEx.getHumanBlood();
                }
                if (blood < 0) break;
                int tscale = 25;
                int percent = (int)((float)blood / 500.0f * 100.0f);
                float midX = event.getResolution().getScaledWidth() / 2;
                float midY = event.getResolution().getScaledHeight() / 2;
                Minecraft.getMinecraft().renderEngine.bindTexture(EMPTY_BLOOD_DROP);
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (i = 0; i < 4; ++i) {
                    ClientEvents.drawTexturedRect(midX - 16.0f + (float)(i * 8), midY + 10.0f, 0.0f, 8.0f);
                }
                Minecraft.getMinecraft().renderEngine.bindTexture(BLOOD_DROP);
                for (i = 0; i < percent / tscale; ++i) {
                    ClientEvents.drawTexturedRect(midX - 16.0f + (float)(i * 8), midY + 10.0f, 0.0f, 8.0f);
                }
                if (percent % tscale > 0) {
                    float remainder2 = 8.0f * (float)(percent % tscale) / (float)tscale;
                    float offset = 8.0f - remainder2;
                    ClientEvents.drawTexturedRect(midX - 16.0f + (float)(i * 8), midY + 10.0f + offset, offset, remainder2);
                }
                if (!WitcheryConfigOptions.hudShowVampireTargetBloodText) break;
                RenderManager renderManager = Minecraft.getMinecraft().getRenderManager();
                float scale2 = 0.5f;
                GlStateManager.scale((float)scale2, (float)scale2, (float)scale2);
                String text2 = String.format("%d/%d", blood, 500);
                int width = renderManager.getFontRenderer().getStringWidth(text2);
                renderManager.getFontRenderer().drawString(text2, (int)((float)(event.getResolution().getScaledWidth() / 2 - width / 4) / scale2), (int)((float)(event.getResolution().getScaledHeight() / 2 + 22) / scale2), 0xCC0000);
                GlStateManager.scale((float)(1.0f / scale2), (float)(1.0f / scale2), (float)(1.0f / scale2));
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onVillagerPreRender(RenderLivingEvent.Pre<EntityVillager> event) {
        if (event.getEntity() instanceof EntityVillager) {
            VillagerExtendedData ext = WitcheryDataExtensions.VILLAGER.get((EntityVillager)event.getEntity());
            GlStateManager.pushMatrix();
            if (ext.isSleeping()) {
                GlStateManager.translate((double)event.getX(), (double)event.getY(), (double)event.getZ());
                renderBed.render();
                GlStateManager.rotate((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotate((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.translate((double)0.5, (double)-1.25, (double)0.0);
                event.getEntity().setRotationYawHead(90.0f);
                GlStateManager.translate((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
            }
        }
    }

    public static void renderGrotesque(EntityLivingBase entity, double x, double y, double z, RenderLivingBase<EntityLivingBase> renderer) {
        GlStateManager.pushMatrix();
        Minecraft.getMinecraft().getTextureManager().bindTexture(DEMON_TEXTURE);
        GROTESQUE_MODEL.setModelAttributes(renderer.getMainModel());
        ModelOverlayRenderer.renderModel(entity, x, y, z, renderer, (ModelBase)GROTESQUE_MODEL);
        GlStateManager.popMatrix();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerPreRender(RenderPlayerEvent.Pre event) {
        AlternateForm creatureType;
        EntityPlayer player = event.getEntityPlayer();
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        if (!player.isInvisible() && playerEx.grotesqueTicks > 0 && !player.isPotionActive(WitcheryPotionEffects.GROTESQUE)) {
            ClientEvents.renderGrotesque((EntityLivingBase)event.getEntityPlayer(), event.getX(), event.getY(), event.getZ(), (RenderLivingBase<EntityLivingBase>)event.getRenderer());
        }
        if (playerEx.getSpiritData().isGhost()) {
            RenderUtil.blend(true);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.51f);
        }
        if ((creatureType = playerEx.getCurrentForm()) != null && !(event.getRenderer() instanceof RenderOtherPlayer)) {
            event.setCanceled(true);
            PotionEffect pe = player.getActivePotionEffect(WitcheryPotionEffects.RESIZING);
            if (pe != null) {
                GlStateManager.pushMatrix();
                GlStateManager.translate((double)event.getX(), (double)event.getY(), (double)event.getZ());
                float scale = PotionResizing.getModifiedScaleFactor((EntityLivingBase)player, pe.getAmplifier());
                GlStateManager.scale((float)scale, (float)scale, (float)scale);
                GlStateManager.translate((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
            }
            boolean gui = player.rotationYawHead == player.rotationYaw && player.prevRotationYawHead == player.rotationYaw && event.getRenderer().getRenderManager().playerViewY == 180.0f && Minecraft.getMinecraft().currentScreen != null;
            float partialTicks = gui ? 0.0f : Minecraft.getMinecraft().getRenderPartialTicks();
            AlternateFormRenderer renderer = AlternateFormRenderingRegistry.get(creatureType);
            GlStateManager.translate((double)event.getX(), (double)event.getY(), (double)event.getZ());
            if (renderer.shouldRender(playerEx)) {
                renderer.render((AbstractClientPlayer)player, event.getRenderer(), partialTicks, gui, false);
            }
            GlStateManager.translate((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
            if (pe != null) {
                GlStateManager.popMatrix();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderLiving(RenderLivingEvent.Pre<EntityLivingBase> event) {
        if (event.getEntity() != null && event.getEntity().world != null && event.getEntity().world.isRemote) {
            for (IHandlePreRenderLiving handler : WitcheryPotionEffects.RENDER_LIVING_PRES) {
                if (event.isCanceled()) break;
                if (!event.getEntity().isPotionActive((Potion)handler.getPotion())) continue;
                PotionEffect effect = event.getEntity().getActivePotionEffect((Potion)handler.getPotion());
                handler.onLivingRender(event.getEntity(), event, effect.getAmplifier());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderLiving(RenderLivingEvent.Post<EntityLivingBase> event) {
        if (event.getEntity() != null && event.getEntity().world != null && event.getEntity().world.isRemote) {
            for (IHandleRenderLiving handler : WitcheryPotionEffects.RENDER_LIVINGS) {
                if (event.isCanceled()) break;
                if (!event.getEntity().isPotionActive((Potion)handler.getPotion())) continue;
                handler.onLivingRender(event.getEntity(), event);
            }
        }
    }

    @SubscribeEvent
    public static void onFogColor(EntityViewRenderEvent.FogColors event) {
        if (fog) {
            event.setRed(34.0f);
            event.setGreen(34.0f);
            event.setBlue(34.0f);
        }
    }

    @SubscribeEvent
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (fog) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onFogRendering(EntityViewRenderEvent.RenderFogEvent event) {
        if (fog) {
            GlStateManager.setFog((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
            GlStateManager.setFogStart((float)1.25f);
            GlStateManager.setFogEnd((float)5.0f);
            if (GLContext.getCapabilities().GL_NV_fog_distance) {
                GlStateManager.glFogi((int)34138, (int)34139);
            }
        }
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        WitcheryResurrectedClient.INSTANCE.registerRenderers();
    }

    @SubscribeEvent
    public static void onRenderSpecials(RenderLivingEvent.Specials.Pre<EntityPlayer> event) {
        if (RenderSleepingBody.Companion.isRendering().get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft client = Minecraft.getMinecraft();
        ShaderGroup post = client.entityRenderer.getShaderGroup();
        if (post != null) {
            for (Shader shader : post.listShaders) {
                float ticks = client.world.getTotalWorldTime() - eyeRenderStartTime;
                if (usingEye) {
                    ticks = Math.min(ticks, 20.0f);
                } else {
                    ticks += 20.0f;
                    ticks = (float)((double)ticks * 1.5);
                }
                shader.getShaderManager().getShaderUniformOrDefault("Ticks").set(20.0f - Math.abs(ticks - 20.0f));
            }
        }
        if (eye != null && !resetEye) {
            if (client.world == null) {
                usingEye = false;
                resetEye = true;
            } else {
                long time = client.world.getTotalWorldTime() - eyeStartTime;
                if (usingEye) {
                    if (time > 60L || ClientEvents.eye.isDead) {
                        eyeRenderStartTime = time + eyeRenderStartTime;
                        usingEye = false;
                    }
                } else if (time > 20L) {
                    resetEye = true;
                }
            }
            if (client.getRenderViewEntity() != eye) {
                client.setRenderViewEntity(eye);
                WitcheryPostShaders.CRYSTAL_BALL.load();
            }
        } else {
            if (client.getRenderViewEntity() != client.player) {
                client.setRenderViewEntity((Entity)client.player);
            }
            eye = null;
            resetEye = false;
        }
    }

    static {
        scrollingVampireAbilities1 = false;
        scrollingVampireAbilities8 = false;
        fog = false;
    }

    public static class GUIOverlay
    extends GuiIngame {
        public static final GUIOverlay INSTANCE = new GUIOverlay();
        private static final ResourceLocation TEETH = new ResourceLocation("witchery", "textures/item/vteeth.png");
        private static final ResourceLocation EYE = new ResourceLocation("witchery", "textures/item/veye.png");
        private static final ResourceLocation BAT = new ResourceLocation("witchery", "textures/item/vbat.png");
        private static final ResourceLocation RUN = new ResourceLocation("witchery", "textures/item/vspeed.png");
        private static final ResourceLocation FIST = new ResourceLocation("witchery", "textures/item/vfist.png");
        private static final ResourceLocation STORM = new ResourceLocation("witchery", "textures/item/vstorm.png");
        private static final ResourceLocation COFFIN = new ResourceLocation("witchery", "textures/item/vcoffin.png");
        private static final int WHITE = 0xFFFFFF;

        public GUIOverlay() {
            super(Minecraft.getMinecraft());
        }

        public void renderHotbar(RenderGameOverlayEvent.Pre event) {
            if (!this.mc.playerController.isSpectator()) {
                int x;
                if (this.mc.player != null) {
                    ItemStack belt;
                    EntityPlayerSP player = this.mc.player;
                    ScaledResolution screen = new ScaledResolution(this.mc);
                    InfusionPower infusionPower = WitcheryUtils.getExtension((EntityPlayer)player).infusionPower;
                    if (infusionPower.getCurrentPower() > 0) {
                        if (infusionEnergyBar == null) {
                            infusionEnergyBar = new RenderInfusionEnergyBar(true);
                        }
                        float left = player.getPrimaryHand() == EnumHandSide.RIGHT ? 20.0f : (float)(screen.getScaledWidth() - 20);
                        float top = (float)screen.getScaledHeight() / 2.0f - 16.0f;
                        infusionEnergyBar.draw(left, top, (double)infusionPower.getCurrentPower() / (double)infusionPower.getMaxPower(), infusionPower.getInfusionType(), Infusion.REGISTRY.getId(infusionPower.getInfusionType()));
                    }
                    PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)player);
                    CreaturePowerData creaturePower = playerEx.creaturePower;
                    if (creaturePower != null) {
                        if (creatureEnergyBar == null) {
                            creatureEnergyBar = new RenderInfusionEnergyBar(false);
                        }
                        float left2 = player.getPrimaryHand() == EnumHandSide.RIGHT ? 30.0f : (float)(screen.getScaledWidth() - 30);
                        float top2 = (float)screen.getScaledHeight() / 2.0f - 16.0f;
                        ResourceLocation key = EntityList.getKey(creaturePower.getEntityType());
                        if (key != null) {
                            key = new ResourceLocation(key.getNamespace(), "textures/creature_powers/" + key.getPath() + ".png");
                        }
                        creatureEnergyBar.draw(left2, top2, (double)creaturePower.getCharges(), null, key);
                    }
                    if ((belt = player.getItemStackFromSlot(EntityEquipmentSlot.LEGS)).getItem() == WitcheryEquipmentItems.BARK_BELT) {
                        int beltCharges = Math.min(ItemWitchesClothes.getChargeLevel(belt), ItemWitchesClothes.getMaxChargeLevel((EntityLivingBase)player));
                        ClientEvents.drawBarkBeltCharges(player, beltCharges, screen);
                    }
                    ClientEvents.drawInfusedBrews(player, screen);
                    ItemStack stack = player.getActiveItemStack();
                    if (stack.getItem() == WitcheryGeneralItems.MYSTIC_BRANCH) {
                        NBTTagCompound playerData = player.getEntityData();
                        StrokeArray strokes = new StrokeArray(playerData.getByteArray("Strokes"));
                        StrokeSet effect = SymbolEffectManager.INSTANCE.getEffect(strokes);
                        GlStateManager.pushMatrix();
                        x = screen.getScaledWidth() / 2;
                        int y = screen.getScaledHeight() / 2;
                        Tessellator tessellator = Tessellator.getInstance();
                        BufferBuilder buffer = tessellator.getBuffer();
                        buffer.begin(4, DefaultVertexFormats.POSITION_COLOR);
                        int initialX = x;
                        int initialY = y;
                        List<BranchStroke> strokeList = strokes.getRaw();
                        double yawDiff = ((double)playerData.getFloat("StartYaw") - MathHelper.clampedLerp((double)player.prevRotationYawHead, (double)player.rotationYawHead, (double)event.getPartialTicks())) * 3.0;
                        double pitchDiff = ((double)playerData.getFloat("StartPitch") - MathHelper.clampedLerp((double)player.prevRotationPitch, (double)player.rotationPitch, (double)event.getPartialTicks())) * 3.0;
                        if (effect == null) {
                            for (int i = strokeList.size() - 1; i >= 0; --i) {
                                float arrowOffset = 0.16666667f;
                                BranchStroke stroke = strokeList.get(i);
                                int xOffset = stroke.getX();
                                int yOffset = stroke.getY();
                                this.renderRectangle(buffer, (double)x + yawDiff, (double)y + pitchDiff, (double)(x + xOffset) + yawDiff, (double)(y + yOffset) + pitchDiff, false);
                                double xStart = (double)x + yawDiff;
                                double yStart = (double)y + pitchDiff;
                                double xEnd = (double)x + yawDiff + (double)((float)xOffset * arrowOffset);
                                double yEnd = (double)y + pitchDiff + (double)((float)yOffset * arrowOffset);
                                double perpendicularX = yEnd - yStart;
                                double perpendicularY = xStart - xEnd;
                                double factor = MathHelper.fastInvSqrt((double)(perpendicularX * perpendicularX + perpendicularY * perpendicularY)) * 4.0;
                                buffer.pos(xStart, yStart, (double)this.zLevel).color(1, 1, 128, 120).endVertex();
                                buffer.pos(xEnd - (perpendicularX *= factor), yEnd - (perpendicularY *= factor), (double)this.zLevel).color(1, 1, 128, 120).endVertex();
                                buffer.pos(xEnd + perpendicularX, yEnd + perpendicularY, (double)this.zLevel).color(1, 1, 128, 120).endVertex();
                                x += xOffset;
                                y += yOffset;
                            }
                            this.renderRectangle(buffer, initialX, initialY, (double)initialX + yawDiff, (double)initialY + pitchDiff, false);
                            tessellator.draw();
                        } else {
                            int xOffset = 0;
                            int yOffset = 0;
                            for (int i = strokeList.size() - 1; i >= 0; --i) {
                                BranchStroke stroke = strokeList.get(i);
                                int count = i == strokeList.size() - 1 && !effect.getResult().fallsToEarth() ? 2 : 1;
                                for (int j = 0; j < count; ++j) {
                                    xOffset += stroke.getX();
                                    yOffset += stroke.getY();
                                }
                                if (i != 0 && stroke == strokeList.get(i - 1)) continue;
                                this.renderRectangle(buffer, x, y, x + xOffset, y + yOffset, true);
                                x += xOffset;
                                y += yOffset;
                                xOffset = 0;
                                yOffset = 0;
                            }
                            tessellator.draw();
                            ResourceLocation id = (ResourceLocation)SymbolEffect.REGISTRY.getKey(effect.getResult());
                            String text2 = I18n.format((String)("spell." + id.getNamespace() + "." + id.getPath()), (Object[])new Object[0]);
                            int tx = screen.getScaledWidth() / 2 - (int)(ClientEvents.getStringWidth(text2) / 2.0);
                            int ty = screen.getScaledHeight() / 2 + 20;
                            Minecraft.getMinecraft().fontRenderer.drawStringWithShadow(text2, (float)tx, (float)ty, 0xFFFFFF);
                        }
                        GlStateManager.popMatrix();
                    } else if (stack.getItem() == WitcheryGeneralItems.BREW_BAG && !player.isSneaking()) {
                        InventoryBrewBag inv = new InventoryBrewBag((EntityPlayer)player);
                        StrokeArray strokes = new StrokeArray(player.getEntityData().getByteArray("Strokes"));
                        GlStateManager.pushMatrix();
                        int x2 = screen.getScaledWidth() / 2 - 8;
                        int y = screen.getScaledHeight() / 2 - 8;
                        if (strokes.isEmpty()) {
                            this.mc.getTextureManager().bindTexture(RADIAL_LOCATION);
                            GlStateManager.pushMatrix();
                            float scale2 = 0.33333334f;
                            GlStateManager.translate((float)(x2 - 42 + 5), (float)(y - 42 + 5), (float)0.0f);
                            GlStateManager.scale((float)scale2, (float)scale2, (float)scale2);
                            int color2 = ((Dyeable)stack.getItem()).getColor(stack);
                            float r = (float)(color2 >>> 16 & 0xFF) / 255.0f;
                            float g = (float)(color2 >>> 8 & 0xFF) / 255.0f;
                            float b = (float)(color2 & 0xFF) / 255.0f;
                            GlStateManager.color((float)r, (float)g, (float)b, (float)1.0f);
                            this.drawTexturedModalRect(8, 8, 0, 0, 256, 256);
                            GlStateManager.popMatrix();
                        }
                        ClientEvents.drawBrewInSlot(inv, 0, strokes, x2, y - 32, 0, -11, 1);
                        ClientEvents.drawBrewInSlot(inv, 1, strokes, x2 + 24, y - 24, 23, 6, 0);
                        ClientEvents.drawBrewInSlot(inv, 2, strokes, x2 + 32, y, 23, 6, 0);
                        ClientEvents.drawBrewInSlot(inv, 3, strokes, x2 + 24, y + 24, 23, 6, 0);
                        ClientEvents.drawBrewInSlot(inv, 4, strokes, x2, y + 32, 0, 19, 1);
                        ClientEvents.drawBrewInSlot(inv, 5, strokes, x2 - 24, y + 24, -5, 6, 2);
                        ClientEvents.drawBrewInSlot(inv, 6, strokes, x2 - 32, y, -5, 6, 2);
                        ClientEvents.drawBrewInSlot(inv, 7, strokes, x2 - 24, y - 24, -5, 6, 2);
                        GlStateManager.popMatrix();
                    }
                }
                if (this.mc.getRenderViewEntity() instanceof EntityPlayer) {
                    ScaledResolution sr = event.getResolution();
                    EntityPlayer player = (EntityPlayer)this.mc.getRenderViewEntity();
                    PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                    VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
                    int level = transformation.getLevel();
                    if (level > 0) {
                        int power;
                        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.mc.getTextureManager().bindTexture(WIDGETS_TEX_PATH);
                        ItemStack itemstack = player.getHeldItemOffhand();
                        int i = sr.getScaledWidth() / 2;
                        int xSize = 90;
                        int k = xSize + 1;
                        int offset = 2;
                        if (!itemstack.isEmpty()) {
                            offset += 29;
                        }
                        x = i - xSize - offset - 18;
                        int boxStart = x + 16;
                        int side = 1;
                        if (player.getPrimaryHand() == EnumHandSide.LEFT) {
                            x = i + xSize + offset + 2;
                            boxStart = x - 24;
                            side = -1;
                        }
                        if ((power = transformation.getSelectedPower().ordinal()) != 0) {
                            GlStateManager.color((float)0.8f, (float)0.05f, (float)0.2f);
                            this.drawTexturedModalRect(boxStart - power * 20 * side, sr.getScaledHeight() - 23, 0, 22, 24, 22);
                            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f);
                        }
                        int y = sr.getScaledHeight() - 19;
                        this.mc.renderEngine.bindTexture(TEETH);
                        GUIOverlay.drawModalRectWithCustomSizedTexture((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                        if (level >= 2) {
                            this.mc.renderEngine.bindTexture(EYE);
                            GUIOverlay.drawModalRectWithCustomSizedTexture((int)(x -= 20 * side), (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                            if (level >= 4) {
                                this.mc.renderEngine.bindTexture(RUN);
                                GUIOverlay.drawModalRectWithCustomSizedTexture((int)(x -= 20 * side), (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                                if (level >= 7) {
                                    this.mc.renderEngine.bindTexture(BAT);
                                    GUIOverlay.drawModalRectWithCustomSizedTexture((int)(x -= 20 * side), (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                                    if (level >= 10) {
                                        x -= 20 * side;
                                        switch (transformation.getUltimatePower()) {
                                            case FARM: {
                                                this.mc.renderEngine.bindTexture(COFFIN);
                                                break;
                                            }
                                            case STORM: {
                                                this.mc.renderEngine.bindTexture(STORM);
                                                break;
                                            }
                                            default: {
                                                this.mc.renderEngine.bindTexture(FIST);
                                            }
                                        }
                                        if (transformation.getCharges() == 0 || transformation.getUltimatePower() == VampireTransformation.Ultimate.NONE) {
                                            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                                        }
                                        GUIOverlay.drawModalRectWithCustomSizedTexture((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                                    }
                                }
                            }
                        }
                        this.renderToolHighlight(playerEx, sr.getScaledWidth(), sr.getScaledHeight());
                    }
                }
            }
        }

        private void renderRectangle(BufferBuilder buffer, double xStart, double yStart, double xEnd, double yEnd, boolean darker) {
            int blue = darker ? 128 : 255;
            int alpha = darker ? 120 : 80;
            double perpendicularX = yEnd - yStart;
            double perpendicularY = xStart - xEnd;
            double factor = MathHelper.fastInvSqrt((double)(perpendicularX * perpendicularX + perpendicularY * perpendicularY));
            buffer.pos(xStart + (perpendicularX *= factor), yStart + (perpendicularY *= factor), (double)this.zLevel).color(1, 1, blue, alpha).endVertex();
            buffer.pos(xStart - perpendicularX, yStart - perpendicularY, (double)this.zLevel).color(1, 1, blue, alpha).endVertex();
            buffer.pos(xEnd - perpendicularX, yEnd - perpendicularY, (double)this.zLevel).color(1, 1, blue, alpha).endVertex();
            buffer.pos(xEnd - perpendicularX, yEnd - perpendicularY, (double)this.zLevel).color(1, 1, blue, alpha).endVertex();
            buffer.pos(xEnd + perpendicularX, yEnd + perpendicularY, (double)this.zLevel).color(1, 1, blue, alpha).endVertex();
            buffer.pos(xStart + perpendicularX, yStart + perpendicularY, (double)this.zLevel).color(1, 1, blue, alpha).endVertex();
        }

        protected void renderToolHighlight(PlayerExtendedData playerEx, int width, int height2) {
            Minecraft mc = Minecraft.getMinecraft();
            VampireTransformation transformation = playerEx.getTransformation(WitcheryTransformations.VAMPIRE);
            if (mc.gameSettings.heldItemTooltips) {
                transformation.setHighlightTicks(transformation.getHighlightTicks() - 1);
                if (transformation.getHighlightTicks() > 0) {
                    String name2 = "";
                    block0 : switch (transformation.getSelectedPower()) {
                        case DRINK: {
                            name2 = I18n.format((String)"witchery.vampire_power.feed", (Object[])new Object[0]);
                            break;
                        }
                        case MESMERIZE: {
                            name2 = I18n.format((String)"witchery.vampire_power.eye", (Object[])new Object[0]);
                            break;
                        }
                        case SPEED: {
                            name2 = I18n.format((String)"witchery.vampire_power.speed", (Object[])new Object[0]);
                            break;
                        }
                        case BAT: {
                            name2 = I18n.format((String)"witchery.vampire_power.bat", (Object[])new Object[0]);
                            break;
                        }
                        case ULTIMATE: {
                            switch (transformation.getUltimatePower()) {
                                case NONE: {
                                    name2 = I18n.format((String)"witchery.vampire_ultimate.none", (Object[])new Object[]{transformation.getCharges()});
                                    break block0;
                                }
                                case FARM: {
                                    name2 = I18n.format((String)"witchery.vampire_ultimate.teleport", (Object[])new Object[]{transformation.getCharges()});
                                    break block0;
                                }
                                case SWARM: {
                                    name2 = I18n.format((String)"witchery.vampire_ultimate.bats", (Object[])new Object[]{transformation.getCharges()});
                                    break block0;
                                }
                                case STORM: {
                                    name2 = I18n.format((String)"witchery.vampire_ultimate.storm", (Object[])new Object[]{transformation.getCharges()});
                                }
                            }
                        }
                    }
                    if (name2.equals("")) {
                        return;
                    }
                    int opacity = (int)((float)transformation.getHighlightTicks() * 256.0f / 10.0f);
                    if (opacity > 255) {
                        opacity = 255;
                    }
                    if (opacity > 0) {
                        FontRenderer font;
                        int y = height2 - 69;
                        if (mc.playerController == null || !mc.playerController.shouldDrawHUD()) {
                            y += 14;
                        }
                        GlStateManager.pushMatrix();
                        RenderManager renderManager = mc.getRenderManager();
                        if (renderManager != null && (font = renderManager.getFontRenderer()) != null) {
                            int x = (width - font.getStringWidth(name2)) / 2;
                            font.drawStringWithShadow(name2, (float)x, (float)y, 0xFFFFFF | opacity << 24);
                        }
                        GlStateManager.popMatrix();
                    }
                }
            }
        }
    }
}

