/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.ritual;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ritual.SmallRitual;
import net.msrandom.witchery.entity.EntityRitualItem;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.potion.PotionEnderInhibition;
import net.msrandom.witchery.rite.RitualCircle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/msrandom/witchery/brewing/ritual/TransposeRitual;", "Lnet/msrandom/witchery/brewing/ritual/SmallRitual;", "()V", "activate", "Lnet/msrandom/witchery/brewing/ritual/SmallRitual$Result;", "world", "Lnet/minecraft/world/World;", "item", "Lnet/msrandom/witchery/entity/EntityRitualItem;", "stack", "Lnet/minecraft/item/ItemStack;", "position", "Lnet/minecraft/util/math/BlockPos;", "WitcheryResurrected"})
public final class TransposeRitual
extends SmallRitual {
    @Override
    @NotNull
    public SmallRitual.Result activate(@NotNull World world, @NotNull EntityRitualItem item, @NotNull ItemStack stack, @NotNull BlockPos position) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)((Object)item), (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        ItemStack itemStack = stack.splitStack(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack.splitStack(1)");
        ItemStack usedStone = itemStack;
        if (!stack.isEmpty()) {
            world.spawnEntity((Entity)new EntityItem(world, item.posX, item.posY, item.posZ, stack));
        }
        for (Entity entity : world.getEntitiesWithinAABB(Entity.class, new AxisAlignedBB(position.add(-4, -4, -4), position.add(4, 4, 4)))) {
            if (entity.isDead || !(entity.getDistanceSq(0.5 + (double)position.getX(), entity.posY, 0.5 + (double)position.getZ()) <= (double)16) || !(entity instanceof EntityLivingBase) && !(entity instanceof EntityItem) || !PotionEnderInhibition.canTeleport(entity, 1) || WitcheryIngredientItem.teleportToLocation(world, usedStone, entity, 0, true)) continue;
            world.playSound(null, entity.posX, entity.posY, entity.posZ, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            world.setEntityState(entity, (byte)4);
        }
        return SmallRitual.Result.DONE;
    }

    public TransposeRitual() {
        RitualCircle ritualCircle = RitualCircle.Companion.get(WitcheryBlocks.GLYPH_OTHERWHERE, 1);
        Item[] itemArray = new Item[2];
        Item item = WitcheryIngredientItems.BOUND_WAYSTONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"WitcheryIngredientItems.BOUND_WAYSTONE");
        itemArray[0] = item;
        Item item2 = WitcheryIngredientItems.PLAYER_BOUND_WAYSTONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)item2, (String)"WitcheryIngredientItems.PLAYER_BOUND_WAYSTONE");
        itemArray[1] = item2;
        super(ritualCircle, itemArray);
    }
}

