/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.ritual;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ritual.SmallRitual;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.entity.EntityRitualItem;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.rite.RitualCircle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/msrandom/witchery/brewing/ritual/BindWaystoneRitual;", "Lnet/msrandom/witchery/brewing/ritual/SmallRitual;", "()V", "activate", "Lnet/msrandom/witchery/brewing/ritual/SmallRitual$Result;", "world", "Lnet/minecraft/world/World;", "item", "Lnet/msrandom/witchery/entity/EntityRitualItem;", "stack", "Lnet/minecraft/item/ItemStack;", "position", "Lnet/minecraft/util/math/BlockPos;", "WitcheryResurrected"})
public final class BindWaystoneRitual
extends SmallRitual {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SmallRitual.Result activate(@NotNull World world, @NotNull EntityRitualItem item, @NotNull ItemStack stack, @NotNull BlockPos position) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)((Object)item), (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        int originalStackSize = stack.getCount();
        int remainingStackSize = 0;
        AxisAlignedBB bounds = new AxisAlignedBB(position.add(-2, -2, -2), position.add(2, 2, 2));
        ItemStack boundStone = null;
        EntityLivingBase target = null;
        double targetDistSq = -1.0;
        for (EntityPlayer player : world.getEntitiesWithinAABB(EntityPlayer.class, bounds)) {
            double distSq = player.getDistanceSq(position);
            if (!(distSq <= (double)4) || target != null && !(distSq < targetDistSq)) continue;
            target = (EntityLivingBase)player;
            targetDistSq = distSq;
        }
        if (target == null) {
            for (EntityLiving creature : world.getEntitiesWithinAABB(EntityLiving.class, bounds)) {
                double distSq2 = creature.getDistanceSq(position);
                if (!(distSq2 <= (double)4) || target != null && !(distSq2 < targetDistSq)) continue;
                target = (EntityLivingBase)creature;
                targetDistSq = distSq2;
            }
        }
        if (target != null) {
            IPowerSource power = PowerSources.findClosestPowerSource(world, position);
            if (power == null) {
                world.playSound(null, position, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                return SmallRitual.Result.NO_POWER;
            }
            if (!power.consumePower(4000.0f)) {
                world.playSound(null, position, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                return SmallRitual.Result.NO_POWER;
            }
            int convertableStackSize = RangesKt.coerceAtMost((int)originalStackSize, (int)1);
            remainingStackSize = originalStackSize - convertableStackSize;
            boundStone = new ItemStack(WitcheryIngredientItems.PLAYER_BOUND_WAYSTONE, convertableStackSize);
            ItemTaglockKit.setEntityTaglock(boundStone, null, (Entity)target, false, 0);
        } else {
            int convertableStackSize2 = RangesKt.coerceAtMost((int)originalStackSize, (int)8);
            remainingStackSize = originalStackSize - convertableStackSize2;
            boundStone = new ItemStack(WitcheryIngredientItems.BOUND_WAYSTONE, convertableStackSize2);
            WitcheryIngredientItem.bindToLocation(position, item.dimension, boundStone);
        }
        if (boundStone.isEmpty()) {
            return SmallRitual.Result.DONE;
        }
        world.spawnEntity((Entity)new EntityItem(world, item.posX, item.posY, item.posZ, boundStone));
        if (remainingStackSize > 0) {
            world.spawnEntity((Entity)new EntityItem(world, item.posX, item.posY, item.posZ, new ItemStack(WitcheryIngredientItems.WAYSTONE, remainingStackSize)));
        }
        world.playSound(null, item.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        return SmallRitual.Result.EXPLODE;
    }

    public BindWaystoneRitual() {
        RitualCircle ritualCircle = RitualCircle.Companion.get(WitcheryBlocks.GLYPH_OTHERWHERE, 0);
        Item[] itemArray = new Item[1];
        Item item = WitcheryIngredientItems.WAYSTONE;
        Intrinsics.checkExpressionValueIsNotNull((Object)item, (String)"WitcheryIngredientItems.WAYSTONE");
        itemArray[0] = item;
        super(ritualCircle, itemArray);
    }
}

