/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;

public class WastingBrewEffect
extends BrewActionEffect {
    public WastingBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        int hungerTicks = modifiers.getModifiedDuration(400);
        int poisonTicks = Math.max(modifiers.getModifiedDuration(60), 40);
        int strength = 1 + modifiers.getStrength() / 2;
        if (targetEntity instanceof EntityPlayer) {
            EntityPlayer victim = (EntityPlayer)targetEntity;
            if (modifiers.inverted) {
                int minLevel = 6 + 2 * modifiers.getStrength();
                victim.getFoodStats().addStats(minLevel, (float)minLevel);
            } else {
                int minLevel = 10 - modifiers.getStrength();
                if (victim.getFoodStats().getFoodLevel() > minLevel) {
                    victim.getFoodStats().addStats(-minLevel, 2.0f);
                }
                victim.addPotionEffect(new PotionEffect(MobEffects.HUNGER, hungerTicks, strength));
                victim.addPotionEffect(new PotionEffect(MobEffects.POISON, poisonTicks, 0));
            }
        } else if (modifiers.inverted) {
            targetEntity.addPotionEffect(new PotionEffect(MobEffects.REGENERATION, 600, modifiers.getStrength()));
        } else {
            targetEntity.addPotionEffect(new PotionEffect(MobEffects.WITHER, hungerTicks, strength));
            targetEntity.addPotionEffect(new PotionEffect(MobEffects.POISON, poisonTicks));
        }
    }
}

