/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.brewing.action.effect.PotionBrewEffect;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.util.BlockUtil;

public class VinesBrewEffect
extends BrewActionEffect {
    public VinesBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        IBlockState state = WitcheryBlocks.VINE.getDefaultState();
        switch (side) {
            case NORTH: {
                state = state.withProperty((IProperty)BlockVine.NORTH, (Comparable)Boolean.valueOf(true));
                break;
            }
            case SOUTH: {
                state = state.withProperty((IProperty)BlockVine.SOUTH, (Comparable)Boolean.valueOf(true));
                break;
            }
            case WEST: {
                state = state.withProperty((IProperty)BlockVine.WEST, (Comparable)Boolean.valueOf(true));
                break;
            }
            case EAST: {
                state = state.withProperty((IProperty)BlockVine.EAST, (Comparable)Boolean.valueOf(true));
                break;
            }
            default: {
                return;
            }
        }
        BlockPos n = pos.offset(side);
        int offsetY = 0;
        while (BlockUtil.isReplaceableBlock(world, n.up(offsetY)) && pos.getY() + offsetY > 0 && (modifiers.getStrength() > 0 || world.getBlockState(pos.up(offsetY)).getMaterial().isSolid())) {
            world.setBlockState(n.up(offsetY), state, 3);
            --offsetY;
        }
        offsetY = 1;
        while ((BlockUtil.isReplaceableBlock(world, n.up(offsetY)) || world.getBlockState(n.up(offsetY)).getMaterial() == Material.LEAVES) && world.getBlockState(pos).getMaterial().isSolid() && pos.getY() + offsetY < 255) {
            world.setBlockState(n.up(offsetY), state, 3);
            ++offsetY;
        }
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        PotionBrewEffect.applyPotionEffect(targetEntity, modifiers, WitcheryPotionEffects.WRAPPED_IN_VINE, 1800, modifiers.noParticles, modifiers.caster);
    }
}

