/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.CreatureUtil;

public class UndeadbaneBrewEffect
extends BrewActionEffect {
    public UndeadbaneBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack actionStack) {
        if (targetEntity instanceof EntityPlayer && ((EntityPlayer)targetEntity).capabilities.isCreativeMode) {
            return;
        }
        int strength = Math.min(modifiers.getStrength(), modifiers.strengthCeilingDisabled ? 3 : 1);
        if (CreatureUtil.isUndead((Entity)targetEntity)) {
            targetEntity.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)modifiers.caster, (Entity)modifiers.caster), (float)MathHelper.ceil((double)((double)(10 << strength) * modifiers.powerScalingFactor)));
        } else {
            targetEntity.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)modifiers.caster, (Entity)modifiers.caster), (float)MathHelper.ceil((double)((double)(3 << strength) * modifiers.powerScalingFactor)));
        }
    }
}

