/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersRitual;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class TransposeOreBrewEffect
extends BrewActionEffect {
    public TransposeOreBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        int depth = radius + modifiers.strength.getValue();
        Block[] blockTypes = new Block[]{Blocks.IRON_ORE, Blocks.GOLD_ORE, Blocks.LAPIS_ORE, Blocks.EMERALD_ORE};
        this.slurpOres(world, pos, radius, depth, blockTypes, modifiers);
    }

    @Override
    protected void doApplyRitualToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersRitual ritualModifiers, ModifiersEffect modifiers, ItemStack stack) {
        int r = ritualModifiers.covenSize + radius;
        int maxDepth = 4 * ritualModifiers.covenSize * (1 + modifiers.getStrength());
        int steps = 4;
        Block[] blockTypes = new Block[]{Blocks.IRON_ORE, Blocks.GOLD_ORE, Blocks.LAPIS_ORE, Blocks.EMERALD_ORE};
        this.slurpOres(world, pos.down((ritualModifiers.pulses - 1) * steps), r, steps, blockTypes, modifiers);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENTITY_FIREWORK_BLAST, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 1.0f, 1.0f, EnumParticleTypes.FLAME), world, pos, 16.0);
        ritualModifiers.setRitualStatus(RitualStatus.success(ritualModifiers.pulses * 4 >= maxDepth));
    }

    private void slurpOres(World world, BlockPos pos, int radius, int depth, Block[] blockTypes, ModifiersEffect modifiers) {
        int maxType = modifiers.getStrength();
        for (BlockPos p : BlockPos.getAllInBox((BlockPos)pos.add(-radius, -depth, -radius), (BlockPos)pos.add(radius, radius, radius))) {
            Block blockID = world.getBlockState(p).getBlock();
            for (int t = 0; t < blockTypes.length && t < maxType; ++t) {
                if (blockID != blockTypes[t]) continue;
                ItemStack newStack = new ItemStack(blockID);
                EntityItem entity = new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, newStack);
                if (world.isRemote) continue;
                world.setBlockToAir(p);
                world.spawnEntity((Entity)entity);
            }
        }
    }
}

