/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionBlockCircle;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;

public class TillingBrewEffect
extends BrewActionBlockCircle {
    public TillingBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void onCircleBlock(World world, BlockPos p, ModifiersEffect modifiers, AtomicInteger counter) {
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)p.down(1), (BlockPos)p.up(1))) {
            IBlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            if (!(block == Blocks.GRASS || block == Blocks.DIRT || block == Blocks.SAND && modifiers.getStrength() > 0 || block == Blocks.NETHERRACK && modifiers.getStrength() > 1) && (block != Blocks.SOUL_SAND || modifiers.getStrength() <= 2) || !world.isAirBlock(pos.up())) continue;
            world.setBlockState(pos, Blocks.FARMLAND.getDefaultState());
            counter.incrementAndGet();
            if (world.rand.nextInt(counter.get()) != 0) continue;
            SoundType stepSound = block.getSoundType(state, world, pos, null);
            world.playSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), stepSound.getStepSound(), SoundCategory.BLOCKS, (stepSound.getVolume() + 1.0f) / 2.0f, stepSound.getPitch() * 0.8f, false);
        }
    }
}

