/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.potion.WitcheryPotion;

public class StealBuffsBrewEffect
extends BrewActionEffect {
    public StealBuffsBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        double radius = (modifiers.getStrength() + 1) * 8;
        double radiusSq = radius * radius;
        AxisAlignedBB bounds = targetEntity.getEntityBoundingBox().expand(radius, radius, radius);
        int maxBuffs = (int)Math.ceil(((double)modifiers.getStrength() + 1.0) * 2.0 * modifiers.powerScalingFactor);
        List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, bounds);
        targetEntity = modifiers.caster;
        for (EntityLivingBase otherEntity : entities) {
            if (otherEntity == targetEntity || !(otherEntity.getDistanceSq((Entity)targetEntity) < radiusSq)) continue;
            Collection potionEffects = otherEntity.getActivePotionEffects();
            ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
            for (PotionEffect effect : potionEffects) {
                Potion potion = effect.getPotion();
                if (WitcheryPotion.isDebuff(potion) || !WitcheryPotion.isCurable(potion) || effect.getAmplifier() > modifiers.getStrength()) continue;
                PotionEffect myEffect = targetEntity.getActivePotionEffect(potion);
                if (myEffect != null) {
                    if (myEffect.getDuration() <= effect.getDuration() && myEffect.getAmplifier() <= effect.getAmplifier()) {
                        targetEntity.addPotionEffect(new PotionEffect(effect));
                        effectsToRemove.add(effect.getPotion());
                        --maxBuffs;
                    }
                } else {
                    targetEntity.addPotionEffect(new PotionEffect(effect));
                    effectsToRemove.add(effect.getPotion());
                    --maxBuffs;
                }
                if (maxBuffs > 0) continue;
                break;
            }
            for (Potion id : effectsToRemove) {
                otherEntity.removePotionEffect(id);
            }
            if (maxBuffs > 0) continue;
            break;
        }
    }
}

