/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.potion.WitcheryPotion;

public class SpreadDebuffsBrewEffect
extends BrewActionEffect {
    public SpreadDebuffsBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        int strength = modifiers.getStrength();
        double radius = (strength + 1) * 4;
        double radiusSq = radius * radius;
        AxisAlignedBB bounds = targetEntity.getEntityBoundingBox().expand(radius, radius, radius);
        int maxBuffs = (int)Math.ceil(((double)strength + 1.0) * modifiers.powerScalingFactor);
        List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, bounds);
        ArrayList<EntityLivingBase> others = new ArrayList<EntityLivingBase>();
        for (EntityLivingBase otherEntity : entities) {
            if (otherEntity == targetEntity || !(otherEntity.getDistanceSq((Entity)targetEntity) < radiusSq)) continue;
            others.add(otherEntity);
        }
        Collection effects2 = targetEntity.getActivePotionEffects();
        ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
        for (PotionEffect effect : effects2) {
            Potion potion = effect.getPotion();
            if (!WitcheryPotion.isDebuff(potion) || !WitcheryPotion.isCurable(potion) || effect.getAmplifier() > Math.max(strength - 1, 1)) continue;
            effectsToRemove.add(potion);
            for (EntityLivingBase other : others) {
                other.addPotionEffect(new PotionEffect(effect));
            }
            if (--maxBuffs > 0) continue;
            break;
        }
        for (Potion id : effectsToRemove) {
            targetEntity.removePotionEffect(id);
        }
    }
}

