/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.EntitySummonedUndead;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.data.WitcheryAlternateForms;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;

public class RevealingBrewEffect
extends BrewActionEffect {
    public RevealingBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase targetEntity, ModifiersEffect modifiers, ItemStack stack) {
        EntityPlayer player;
        PlayerExtendedData playerEx;
        if (targetEntity.isPotionActive(MobEffects.INVISIBILITY)) {
            targetEntity.removePotionEffect(MobEffects.INVISIBILITY);
        }
        if (targetEntity instanceof EntityPlayer && targetEntity.isInvisible()) {
            targetEntity.setInvisible(false);
        }
        if (targetEntity instanceof EntityPlayer && (playerEx = WitcheryUtils.getExtension(player = (EntityPlayer)targetEntity)).getCurrentForm() == WitcheryAlternateForms.PLAYER) {
            player.playSound(WitcherySounds.ENTITY_VAMPIRE_POOF, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 0.5f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)player);
            playerEx.setCurrentForm(null);
        }
        if (targetEntity instanceof EntitySummonedUndead && ((EntitySummonedUndead)targetEntity).isObscured()) {
            ((EntitySummonedUndead)targetEntity).setObscured(false);
        }
    }
}

