/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockActionSphere;
import net.msrandom.witchery.util.WitcheryUtils;

public class PulverisationBrewEffect
extends BrewActionEffect {
    public PulverisationBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack actionStack) {
        if (!world.isRemote) {
            new BlockActionSphere(){

                @Override
                public void onBlock(World world, BlockPos pos) {
                    IBlockState state = world.getBlockState(pos);
                    Block block = state.getBlock();
                    if (WitcheryUtils.isBlockBreakable(world, pos, state) && WitcheryUtils.canBreak(state)) {
                        if (block == Blocks.STONE) {
                            world.setBlockState(pos, Blocks.COBBLESTONE.getDefaultState());
                        } else if (block == Blocks.COBBLESTONE) {
                            world.setBlockState(pos, Blocks.GRAVEL.getDefaultState());
                        } else if (block == Blocks.GRAVEL || block == Blocks.SANDSTONE) {
                            world.setBlockState(pos, Blocks.SAND.getDefaultState());
                        } else {
                            if (block != Blocks.SAND) {
                                return;
                            }
                            world.setBlockToAir(pos);
                            world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((Block)Blocks.SAND)));
                        }
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 0.25f, 0.25f, EnumParticleTypes.SMOKE_NORMAL), world, pos.up());
                    }
                }
            }.drawFilledSphere(world, pos, Math.max(radius - 1, 1));
            world.playSound(null, pos, SoundEvents.ENTITY_GHAST_SHOOT, modifiers.caster.getSoundCategory(), 0.5f, 2.0f);
        }
    }
}

