/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockCircle;
import net.msrandom.witchery.block.BlockCircleGlyph;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.util.WitcheryUtils;

public class PruningBrewEffect
extends BrewActionEffect {
    public PruningBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToBlock(World world, BlockPos pos, EnumFacing side, int radius, ModifiersEffect modifiers, ItemStack stack) {
        int r = radius - 1;
        int rSq = r * r;
        for (BlockPos p : BlockPos.getAllInBox((BlockPos)pos.add(-r, -r, -r), (BlockPos)pos.add(r, r, r))) {
            Block blockID;
            Material material;
            IBlockState state = world.getBlockState(p);
            if (!(p.distanceSq((Vec3i)pos) <= (double)rSq) || !WitcheryUtils.isBlockBreakable(world, p, state) || (material = state.getMaterial()) != Material.LEAVES && (material != Material.PLANTS && material != Material.VINE || !material.isReplaceable()) || (blockID = world.getBlockState(p).getBlock()) instanceof BlockCircle || blockID instanceof BlockCircleGlyph) continue;
            blockID.dropBlockAsItem(world, p, state, modifiers.getStrength());
            world.setBlockToAir(p);
        }
    }
}

