/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewActionEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.init.WitcheryPotionEffects;

public class PotionLongevityBrewEffect
extends BrewActionEffect {
    public PotionLongevityBrewEffect(BrewEffectSerializer<?> serializer, boolean invertible) {
        super(serializer, invertible);
    }

    @Override
    protected void doApplyToEntity(World world, EntityLivingBase target, ModifiersEffect modifiers, ItemStack actionStack) {
        if (target.isPotionActive(WitcheryPotionEffects.QUEASY)) {
            if (target.world.rand.nextInt(3) == 0) {
                target.addPotionEffect(new PotionEffect(MobEffects.BLINDNESS, 2400, 0, true, true));
            } else {
                target.addPotionEffect(new PotionEffect(MobEffects.NAUSEA, 6000, 0, true, true));
            }
        } else {
            Collection potionEffects = target.getActivePotionEffects();
            if (!potionEffects.isEmpty()) {
                ArrayList<PotionEffect> newEffects = new ArrayList<PotionEffect>();
                int durationBoost = MathHelper.ceil((double)(modifiers.powerScalingFactor * 3600.0));
                for (PotionEffect potionEffect : potionEffects) {
                    if (potionEffect.getPotion().isInstant()) continue;
                    int remainingTicks = potionEffect.getDuration();
                    int newDuration = remainingTicks + Math.min(remainingTicks, durationBoost);
                    newEffects.add(new PotionEffect(potionEffect.getPotion(), newDuration, potionEffect.getAmplifier(), potionEffect.getIsAmbient(), true));
                }
                target.clearActivePotions();
                for (PotionEffect potionEffect : newEffects) {
                    target.addPotionEffect(potionEffect);
                }
                int mins = 3 * Math.max(1, 4 - modifiers.getStrength());
                target.addPotionEffect(new PotionEffect(WitcheryPotionEffects.QUEASY, mins * 1200, 0, true, true));
            }
        }
    }
}

