/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.brewing.action.effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.msrandom.witchery.brewing.BrewNamePart;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffect;
import net.msrandom.witchery.brewing.action.effect.BrewEffectSerializer;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.util.CreatureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 '2\u00020\u0001:\u0002'(B9\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\r\u00a8\u0006)"}, d2={"Lnet/msrandom/witchery/brewing/action/effect/PotionBrewEffect;", "Lnet/msrandom/witchery/brewing/action/effect/BrewEffect;", "serializer", "Lnet/msrandom/witchery/brewing/action/effect/BrewEffectSerializer;", "potion", "Lnet/minecraft/potion/Potion;", "baseDuration", "", "invertedPotion", "invertedDuration", "strengthCeiling", "(Lnet/msrandom/witchery/brewing/action/effect/BrewEffectSerializer;Lnet/minecraft/potion/Potion;ILnet/minecraft/potion/Potion;II)V", "getBaseDuration", "()I", "getInvertedDuration", "getInvertedPotion", "()Lnet/minecraft/potion/Potion;", "isInvertible", "", "()Z", "getPotion", "getStrengthCeiling", "applyToEntity", "", "world", "Lnet/minecraft/world/World;", "victim", "Lnet/minecraft/entity/EntityLivingBase;", "effectModifiers", "Lnet/msrandom/witchery/brewing/ModifiersEffect;", "stack", "Lnet/minecraft/item/ItemStack;", "augmentName", "Lnet/msrandom/witchery/brewing/BrewNamePart;", "namePart", "getDefaultKey", "", "description", "inverted", "Companion", "Serializer", "WitcheryResurrected"})
public class PotionBrewEffect
extends BrewEffect {
    @NotNull
    private final Potion potion;
    private final int baseDuration;
    @NotNull
    private final Potion invertedPotion;
    private final int invertedDuration;
    private final int strengthCeiling;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isInvertible() {
        return this.potion != this.invertedPotion;
    }

    @Override
    public void applyToEntity(@NotNull World world, @NotNull EntityLivingBase victim, @NotNull ModifiersEffect effectModifiers, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)victim, (String)"victim");
        Intrinsics.checkParameterIsNotNull((Object)effectModifiers, (String)"effectModifiers");
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!effectModifiers.disableEntityTarget) {
            if (effectModifiers.inverted) {
                if (!WitcheryPotion.isDebuff(this.invertedPotion) || !effectModifiers.protectedFromNegativePotions) {
                    Companion.applyPotionEffect(victim, effectModifiers, this.invertedPotion, this.invertedDuration, effectModifiers.noParticles, effectModifiers.caster, this.strengthCeiling);
                }
            } else if (!WitcheryPotion.isDebuff(this.potion) || !effectModifiers.protectedFromNegativePotions) {
                if (this.potion == WitcheryPotionEffects.DOUBLE_JUMP) {
                    if (effectModifiers.caster == null || !Familiars.hasFamiliarPower(effectModifiers.caster, WitcheryFamiliars.BREW_MASTERY)) {
                        effectModifiers.reset();
                        return;
                    }
                } else if (this.potion == WitcheryPotionEffects.DISEASED && CreatureUtil.isImmuneToDisease(victim)) {
                    effectModifiers.reset();
                    return;
                }
                Companion.applyPotionEffect(victim, effectModifiers, this.potion, this.baseDuration, effectModifiers.noParticles, effectModifiers.caster, this.strengthCeiling);
            }
            effectModifiers.reset();
        }
    }

    @Override
    @NotNull
    protected String getDefaultKey(boolean description, boolean inverted) {
        String string;
        if (inverted) {
            String string2 = this.invertedPotion.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"invertedPotion.name");
        } else {
            String string3 = this.potion.getName();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"potion.name");
        }
        return string;
    }

    @Override
    @NotNull
    public BrewNamePart augmentName(@NotNull BrewNamePart namePart) {
        Intrinsics.checkParameterIsNotNull((Object)namePart, (String)"namePart");
        BrewNamePart brewNamePart = super.augmentName(namePart).setBaseDuration(this.baseDuration, this.invertedDuration);
        Intrinsics.checkExpressionValueIsNotNull((Object)brewNamePart, (String)"super.augmentName(namePa\u2026nvertedDuration.toLong())");
        return brewNamePart;
    }

    @NotNull
    public final Potion getPotion() {
        return this.potion;
    }

    public final int getBaseDuration() {
        return this.baseDuration;
    }

    @NotNull
    public final Potion getInvertedPotion() {
        return this.invertedPotion;
    }

    public final int getInvertedDuration() {
        return this.invertedDuration;
    }

    public final int getStrengthCeiling() {
        return this.strengthCeiling;
    }

    public PotionBrewEffect(@NotNull BrewEffectSerializer<?> serializer, @NotNull Potion potion, int baseDuration, @NotNull Potion invertedPotion, int invertedDuration, int strengthCeiling) {
        Intrinsics.checkParameterIsNotNull(serializer, (String)"serializer");
        Intrinsics.checkParameterIsNotNull((Object)potion, (String)"potion");
        Intrinsics.checkParameterIsNotNull((Object)invertedPotion, (String)"invertedPotion");
        super(serializer);
        this.potion = potion;
        this.baseDuration = baseDuration;
        this.invertedPotion = invertedPotion;
        this.invertedDuration = invertedDuration;
        this.strengthCeiling = strengthCeiling;
    }

    @JvmStatic
    @JvmOverloads
    public static final void applyPotionEffect(@NotNull EntityLivingBase entity, @NotNull ModifiersEffect modifiers, @NotNull Potion potion, int duration, boolean noParticles, @Nullable EntityPlayer thrower, int strengthCeiling) {
        Companion.applyPotionEffect(entity, modifiers, potion, duration, noParticles, thrower, strengthCeiling);
    }

    @JvmStatic
    @JvmOverloads
    public static final void applyPotionEffect(@NotNull EntityLivingBase entity, @NotNull ModifiersEffect modifiers, @NotNull Potion potion, int duration, boolean noParticles, @Nullable EntityPlayer thrower) {
        net.msrandom.witchery.brewing.action.effect.PotionBrewEffect$Companion.applyPotionEffect$default(Companion, entity, modifiers, potion, duration, noParticles, thrower, 0, 64, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lnet/msrandom/witchery/brewing/action/effect/PotionBrewEffect$Serializer;", "Lnet/msrandom/witchery/brewing/action/effect/BrewEffectSerializer;", "Lnet/msrandom/witchery/brewing/action/effect/PotionBrewEffect;", "()V", "read", "json", "Lcom/google/gson/JsonObject;", "buffer", "Lnet/minecraft/network/PacketBuffer;", "write", "", "effect", "WitcheryResurrected"})
    public static final class Serializer
    implements BrewEffectSerializer<PotionBrewEffect> {
        public static final Serializer INSTANCE;

        @Override
        @NotNull
        public PotionBrewEffect read(@NotNull JsonObject json) {
            JsonElement jsonElement;
            int n;
            Potion potion;
            BrewEffectSerializer brewEffectSerializer;
            int duration;
            block5: {
                Potion potion2;
                block4: {
                    Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
                    JsonElement jsonElement2 = json.get("potion");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"json[\"potion\"]");
                    Potion potion3 = Potion.getPotionFromResourceLocation((String)jsonElement2.getAsString());
                    if (potion3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)potion3, (String)"Potion.getPotionFromReso\u2026son[\"potion\"].asString)!!");
                    potion2 = potion3;
                    JsonElement jsonElement3 = json.get("duration");
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"json[\"duration\"]");
                    duration = jsonElement3.getAsInt();
                    brewEffectSerializer = this;
                    potion = potion2;
                    n = duration;
                    jsonElement = json.get("inverted_potion");
                    if (jsonElement == null) break block4;
                    JsonElement jsonElement4 = jsonElement;
                    int n2 = n;
                    Potion potion4 = potion;
                    BrewEffectSerializer brewEffectSerializer2 = brewEffectSerializer;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsonElement it = jsonElement4;
                    boolean bl3 = false;
                    Potion potion5 = Potion.getPotionFromResourceLocation((String)it.getAsString());
                    brewEffectSerializer = brewEffectSerializer2;
                    potion = potion4;
                    n = n2;
                    jsonElement = potion5;
                    if (jsonElement != null) break block5;
                }
                jsonElement = potion2;
            }
            JsonElement jsonElement5 = json.get("inverted_duration");
            JsonElement jsonElement6 = json.get("power_limit");
            int n3 = jsonElement6 != null ? jsonElement6.getAsInt() : 10;
            int n4 = jsonElement5 != null ? jsonElement5.getAsInt() : duration;
            JsonElement jsonElement7 = jsonElement;
            int n5 = n;
            Potion potion6 = potion;
            BrewEffectSerializer brewEffectSerializer3 = brewEffectSerializer;
            return new PotionBrewEffect(brewEffectSerializer3, potion6, n5, (Potion)jsonElement7, n4, n3);
        }

        @Override
        @NotNull
        public PotionBrewEffect read(@NotNull PacketBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            BrewEffectSerializer brewEffectSerializer = this;
            Potion potion = Potion.getPotionById((int)buffer.readVarInt());
            if (potion == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)potion, (String)"Potion.getPotionById(buffer.readVarInt())!!");
            int n = buffer.readVarInt();
            Potion potion2 = Potion.getPotionById((int)buffer.readVarInt());
            if (potion2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)potion2, (String)"Potion.getPotionById(buffer.readVarInt())!!");
            return new PotionBrewEffect(brewEffectSerializer, potion, n, potion2, buffer.readVarInt(), buffer.readVarInt());
        }

        @Override
        public void write(@NotNull PacketBuffer buffer, @NotNull PotionBrewEffect effect) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull((Object)effect, (String)"effect");
            buffer.writeVarInt(Potion.getIdFromPotion((Potion)effect.getPotion()));
            buffer.writeVarInt(effect.getBaseDuration());
            buffer.writeVarInt(Potion.getIdFromPotion((Potion)effect.getInvertedPotion()));
            buffer.writeVarInt(effect.getInvertedDuration());
            buffer.writeVarInt(effect.getStrengthCeiling());
        }

        private Serializer() {
        }

        static {
            Serializer serializer;
            INSTANCE = serializer = new Serializer();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\fH\u0007\u00a8\u0006\u0012"}, d2={"Lnet/msrandom/witchery/brewing/action/effect/PotionBrewEffect$Companion;", "", "()V", "applyPotionEffect", "", "entity", "Lnet/minecraft/entity/EntityLivingBase;", "modifiers", "Lnet/msrandom/witchery/brewing/ModifiersEffect;", "potion", "Lnet/minecraft/potion/Potion;", "duration", "", "noParticles", "", "thrower", "Lnet/minecraft/entity/player/EntityPlayer;", "strengthCeiling", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        public final void applyPotionEffect(@NotNull EntityLivingBase entity, @NotNull ModifiersEffect modifiers, @NotNull Potion potion, int duration, boolean noParticles, @Nullable EntityPlayer thrower, int strengthCeiling) {
            Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
            Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
            Intrinsics.checkParameterIsNotNull((Object)potion, (String)"potion");
            int strength = RangesKt.coerceAtMost((int)modifiers.getStrength(), (int)(modifiers.strengthCeilingDisabled ? 10 : strengthCeiling));
            if (potion.isInstant()) {
                potion.affectEntity(null, (Entity)thrower, entity, strength, modifiers.powerScalingFactor);
            } else {
                entity.addPotionEffect(new PotionEffect(potion, modifiers.getModifiedDuration(duration), strength, noParticles, true));
            }
        }

        public static /* synthetic */ void applyPotionEffect$default(Companion companion, EntityLivingBase entityLivingBase, ModifiersEffect modifiersEffect, Potion potion, int n, boolean bl, EntityPlayer entityPlayer, int n2, int n3, Object object) {
            if ((n3 & 0x40) != 0) {
                n2 = 10;
            }
            companion.applyPotionEffect(entityLivingBase, modifiersEffect, potion, n, bl, entityPlayer, n2);
        }

        @JvmStatic
        @JvmOverloads
        public final void applyPotionEffect(@NotNull EntityLivingBase entity, @NotNull ModifiersEffect modifiers, @NotNull Potion potion, int duration, boolean noParticles, @Nullable EntityPlayer thrower) {
            net.msrandom.witchery.brewing.action.effect.PotionBrewEffect$Companion.applyPotionEffect$default(this, entity, modifiers, potion, duration, noParticles, thrower, 0, 64, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

